/*
 * Decompiled with CFR 0.152.
 */
package io.livekit.android.room.track;

import androidx.compose.runtime.internal.StabilityInferred;
import io.livekit.android.room.track.Track;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.webrtc.MediaStreamTrack;
import org.webrtc.VideoSink;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0012H\u0016J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0012H\u0016J\b\u0010\u0019\u001a\u00020\u0016H\u0016R$\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001a"}, d2={"Lio/livekit/android/room/track/VideoTrack;", "Lio/livekit/android/room/track/Track;", "name", "", "rtcTrack", "Lorg/webrtc/VideoTrack;", "(Ljava/lang/String;Lorg/webrtc/VideoTrack;)V", "value", "", "enabled", "getEnabled", "()Z", "setEnabled", "(Z)V", "getRtcTrack", "()Lorg/webrtc/VideoTrack;", "sinks", "", "Lorg/webrtc/VideoSink;", "getSinks", "()Ljava/util/List;", "addRenderer", "", "renderer", "removeRenderer", "stop", "livekit-android-sdk_release"})
@StabilityInferred(parameters=0)
public class VideoTrack
extends Track {
    @NotNull
    private final org.webrtc.VideoTrack rtcTrack;
    @NotNull
    private final List<VideoSink> sinks;
    public static final int $stable = 8;

    public VideoTrack(@NotNull String name, @NotNull org.webrtc.VideoTrack rtcTrack) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)rtcTrack, (String)"rtcTrack");
        super(name, Track.Kind.VIDEO, (MediaStreamTrack)rtcTrack);
        this.rtcTrack = rtcTrack;
        this.sinks = new ArrayList();
    }

    @NotNull
    public org.webrtc.VideoTrack getRtcTrack() {
        return this.rtcTrack;
    }

    @NotNull
    protected final List<VideoSink> getSinks() {
        return this.sinks;
    }

    public final boolean getEnabled() {
        return this.getRtcTrack().enabled();
    }

    public final void setEnabled(boolean value) {
        this.getRtcTrack().setEnabled(value);
    }

    public void addRenderer(@NotNull VideoSink renderer) {
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        this.sinks.add(renderer);
        this.getRtcTrack().addSink(renderer);
    }

    public void removeRenderer(@NotNull VideoSink renderer) {
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        this.getRtcTrack().removeSink(renderer);
        this.sinks.remove(renderer);
    }

    @Override
    public void stop() {
        for (VideoSink sink : this.sinks) {
            this.getRtcTrack().removeSink(sink);
        }
        this.sinks.clear();
        super.stop();
    }
}

