/*
 * Decompiled with CFR 0.152.
 */
package io.livekit.android.room.track.video;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.os.Build;
import android.view.Surface;
import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.CapturerObserver;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.VideoCapturer;
import org.webrtc.VideoFrame;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\bH\u0016J\b\u0010\u0014\u001a\u00020\u0012H\u0002J\b\u0010\u0015\u001a\u00020\u0012H\u0016J \u0010\u0016\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0004H\u0016J\b\u0010\u001a\u001a\u00020\u0006H\u0016J\u0016\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\bJ \u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\bH\u0016J\b\u0010 \u001a\u00020\u0012H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lio/livekit/android/room/track/video/BitmapFrameCapturer;", "Lorg/webrtc/VideoCapturer;", "()V", "capturerObserver", "Lorg/webrtc/CapturerObserver;", "disposed", "", "height", "", "rotation", "stateLock", "", "surface", "Landroid/view/Surface;", "surfaceTextureHelper", "Lorg/webrtc/SurfaceTextureHelper;", "width", "changeCaptureFormat", "", "framerate", "checkNotDisposed", "dispose", "initialize", "context", "Landroid/content/Context;", "observer", "isScreencast", "pushBitmap", "bitmap", "Landroid/graphics/Bitmap;", "rotationDegrees", "startCapture", "stopCapture", "livekit-android-sdk_release"})
@StabilityInferred(parameters=0)
public class BitmapFrameCapturer
implements VideoCapturer {
    @Nullable
    private SurfaceTextureHelper surfaceTextureHelper;
    @Nullable
    private CapturerObserver capturerObserver;
    private boolean disposed;
    private int rotation;
    private int width;
    private int height;
    @NotNull
    private final Object stateLock = new Object();
    @Nullable
    private Surface surface;
    public static final int $stable = 8;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(@NotNull SurfaceTextureHelper surfaceTextureHelper, @NotNull Context context, @NotNull CapturerObserver observer) {
        Intrinsics.checkNotNullParameter((Object)surfaceTextureHelper, (String)"surfaceTextureHelper");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        Object object = this.stateLock;
        synchronized (object) {
            boolean bl = false;
            this.surfaceTextureHelper = surfaceTextureHelper;
            this.capturerObserver = observer;
            this.surface = new Surface(surfaceTextureHelper.getSurfaceTexture());
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void checkNotDisposed() {
        if (!(!this.disposed)) {
            boolean bl = false;
            String string = "Capturer is disposed.";
            throw new IllegalStateException(string.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCapture(int width, int height, int framerate) {
        Object object = this.stateLock;
        synchronized (object) {
            Unit unit;
            boolean bl = false;
            this.checkNotDisposed();
            if (this.surfaceTextureHelper == null) {
                boolean bl2 = false;
                String string = "BitmapFrameCapturer must be initialized before calling startCapture.";
                throw new IllegalStateException(string.toString());
            }
            CapturerObserver capturerObserver = this.capturerObserver;
            if (capturerObserver != null) {
                capturerObserver.onCapturerStarted(true);
            }
            SurfaceTextureHelper surfaceTextureHelper = this.surfaceTextureHelper;
            if (surfaceTextureHelper != null) {
                surfaceTextureHelper.startListening(arg_0 -> BitmapFrameCapturer.startCapture$lambda-4$lambda-3(this, arg_0));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopCapture() {
        Object object = this.stateLock;
        synchronized (object) {
            Unit unit;
            boolean bl = false;
            SurfaceTextureHelper surfaceTextureHelper = this.surfaceTextureHelper;
            if (surfaceTextureHelper != null) {
                surfaceTextureHelper.stopListening();
            }
            CapturerObserver capturerObserver = this.capturerObserver;
            if (capturerObserver != null) {
                capturerObserver.onCapturerStopped();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
    }

    public void changeCaptureFormat(int width, int height, int framerate) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.stateLock;
        synchronized (object) {
            boolean bl = false;
            if (this.disposed) {
                return;
            }
            this.stopCapture();
            Surface surface = this.surface;
            if (surface != null) {
                surface.release();
            }
            this.disposed = true;
            Unit unit = Unit.INSTANCE;
        }
    }

    public boolean isScreencast() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pushBitmap(@NotNull Bitmap bitmap, int rotationDegrees) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Object object = this.stateLock;
        synchronized (object) {
            SurfaceTextureHelper surfaceTextureHelper;
            boolean bl = false;
            if (this.disposed) {
                return;
            }
            if (this.surfaceTextureHelper == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            if (this.surface == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            if (this.rotation != rotationDegrees) {
                SurfaceTextureHelper surfaceTextureHelper2 = this.surfaceTextureHelper;
                if (surfaceTextureHelper2 != null) {
                    surfaceTextureHelper2.setFrameRotation(rotationDegrees);
                }
                this.rotation = rotationDegrees;
            }
            if (this.width != bitmap.getWidth() || this.height != bitmap.getHeight()) {
                SurfaceTextureHelper surfaceTextureHelper3 = this.surfaceTextureHelper;
                if (surfaceTextureHelper3 != null) {
                    surfaceTextureHelper3.setTextureSize(bitmap.getWidth(), bitmap.getHeight());
                }
                this.width = bitmap.getWidth();
                this.height = bitmap.getHeight();
            }
            Boolean bl2 = (surfaceTextureHelper = this.surfaceTextureHelper) != null && (surfaceTextureHelper = surfaceTextureHelper.getHandler()) != null ? Boolean.valueOf(surfaceTextureHelper.post(() -> BitmapFrameCapturer.pushBitmap$lambda-8$lambda-7(this, bitmap))) : null;
        }
    }

    private static final void startCapture$lambda-4$lambda-3(BitmapFrameCapturer this$0, VideoFrame frame) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            CapturerObserver capturerObserver = this$0.capturerObserver;
            if (capturerObserver == null) break block0;
            capturerObserver.onFrameCaptured(frame);
        }
    }

    private static final void pushBitmap$lambda-8$lambda-7(BitmapFrameCapturer this$0, Bitmap $bitmap) {
        block3: {
            Canvas canvas;
            Object object;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$bitmap, (String)"$bitmap");
            if (Build.VERSION.SDK_INT >= 23) {
                Surface surface = this$0.surface;
                object = surface != null ? surface.lockHardwareCanvas() : null;
            } else {
                Surface surface = this$0.surface;
                object = canvas = surface != null ? surface.lockCanvas(null) : null;
            }
            if (canvas == null) break block3;
            canvas.drawBitmap($bitmap, new Matrix(), new Paint());
            Surface surface = this$0.surface;
            if (surface != null) {
                surface.unlockCanvasAndPost(canvas);
            }
        }
    }
}

