/*
 * Decompiled with CFR 0.152.
 */
package io.livekit.android.room.track.video;

import android.graphics.Rect;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import androidx.compose.runtime.internal.StabilityInferred;
import io.livekit.android.room.track.Track;
import io.livekit.android.room.track.video.VideoSinkVisibility;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010\u0015\u001a\u00020\fH\u0016J\u0006\u0010\u0016\u001a\u00020\u0013J\b\u0010\u0017\u001a\u00020\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/livekit/android/room/track/video/ViewVisibility;", "Lio/livekit/android/room/track/video/VideoSinkVisibility;", "view", "Landroid/view/View;", "(Landroid/view/View;)V", "globalLayoutListener", "Landroid/view/ViewTreeObserver$OnGlobalLayoutListener;", "handler", "Landroid/os/Handler;", "lastSize", "Lio/livekit/android/room/track/Track$Dimensions;", "lastVisibility", "", "loc", "", "viewRect", "Landroid/graphics/Rect;", "windowRect", "close", "", "isViewAncestorsVisible", "isVisible", "recalculate", "size", "Notifier", "livekit-android-sdk_release"})
@StabilityInferred(parameters=0)
public final class ViewVisibility
extends VideoSinkVisibility {
    @NotNull
    private final View view;
    private final boolean lastVisibility;
    @NotNull
    private final Track.Dimensions lastSize;
    @NotNull
    private final Handler handler;
    @NotNull
    private final ViewTreeObserver.OnGlobalLayoutListener globalLayoutListener;
    @NotNull
    private final int[] loc;
    @NotNull
    private final Rect viewRect;
    @NotNull
    private final Rect windowRect;
    public static final int $stable = 8;

    public ViewVisibility(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.view = view;
        this.lastSize = new Track.Dimensions(0, 0);
        this.handler = new Handler(Looper.getMainLooper());
        this.globalLayoutListener = () -> ViewVisibility.globalLayoutListener$lambda-1(this);
        this.view.getViewTreeObserver().addOnGlobalLayoutListener(this.globalLayoutListener);
        if (this.view instanceof Notifier) {
            ((Notifier)this.view).setViewVisibility(this);
        }
        this.loc = new int[2];
        this.viewRect = new Rect();
        this.windowRect = new Rect();
    }

    public final void recalculate() {
        boolean shouldNotify = false;
        boolean newVisibility = this.isVisible();
        Track.Dimensions newSize = this.size();
        if (newVisibility != this.lastVisibility) {
            shouldNotify = true;
        }
        if (!Intrinsics.areEqual((Object)newSize, (Object)this.lastSize)) {
            shouldNotify = true;
        }
        if (shouldNotify) {
            this.notifyChanged();
        }
    }

    private final boolean isViewAncestorsVisible(View view) {
        View parent;
        if (view.getVisibility() != 0) {
            return false;
        }
        ViewParent viewParent = view.getParent();
        View view2 = parent = viewParent instanceof View ? (View)viewParent : null;
        if (parent != null) {
            return this.isViewAncestorsVisible(parent);
        }
        return true;
    }

    @Override
    public boolean isVisible() {
        if (this.view.getWindowVisibility() != 0 || !this.isViewAncestorsVisible(this.view)) {
            return false;
        }
        this.view.getLocationInWindow(this.loc);
        this.viewRect.set(this.loc[0], this.loc[1], this.loc[0] + this.view.getWidth(), this.loc[1] + this.view.getHeight());
        this.view.getWindowVisibleDisplayFrame(this.windowRect);
        this.windowRect.offset(-this.windowRect.left, -this.windowRect.top);
        return this.viewRect.intersect(this.windowRect);
    }

    @Override
    @NotNull
    public Track.Dimensions size() {
        return new Track.Dimensions(this.view.getWidth(), this.view.getHeight());
    }

    @Override
    public void close() {
        super.close();
        this.handler.removeCallbacksAndMessages(null);
        this.view.getViewTreeObserver().removeOnGlobalLayoutListener(this.globalLayoutListener);
        if (this.view instanceof Notifier && Intrinsics.areEqual((Object)((Notifier)this.view).getViewVisibility(), (Object)this)) {
            ((Notifier)this.view).setViewVisibility(null);
        }
    }

    private static final void globalLayoutListener$lambda-1$lambda-0(ViewVisibility this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.recalculate();
    }

    private static final void globalLayoutListener$lambda-1(ViewVisibility this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.handler.removeCallbacksAndMessages(null);
        this$0.handler.postDelayed(() -> ViewVisibility.globalLayoutListener$lambda-1$lambda-0(this$0), 2000L);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001R\u001a\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lio/livekit/android/room/track/video/ViewVisibility$Notifier;", "", "viewVisibility", "Lio/livekit/android/room/track/video/ViewVisibility;", "getViewVisibility", "()Lio/livekit/android/room/track/video/ViewVisibility;", "setViewVisibility", "(Lio/livekit/android/room/track/video/ViewVisibility;)V", "livekit-android-sdk_release"})
    public static interface Notifier {
        @Nullable
        public ViewVisibility getViewVisibility();

        public void setViewVisibility(@Nullable ViewVisibility var1);
    }
}

