/*
 * Decompiled with CFR 0.152.
 */
package io.livekit.android.room.util;

import io.livekit.android.room.track.VideoEncoding;
import io.livekit.android.room.track.VideoPreset;
import io.livekit.android.room.track.VideoPreset169;
import io.livekit.android.room.track.VideoPreset43;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import livekit.LivekitModels;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.RtpParameters;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011J\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0016\u001a\u00020\u0017J*\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00042\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00112\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0004J\u000e\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\nR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\f\u00a8\u0006 "}, d2={"Lio/livekit/android/room/util/EncodingUtils;", "", "()V", "PRESETS_16_9", "", "Lio/livekit/android/room/track/VideoPreset169;", "PRESETS_4_3", "Lio/livekit/android/room/track/VideoPreset43;", "VIDEO_RIDS", "", "", "getVIDEO_RIDS", "()[Ljava/lang/String;", "[Ljava/lang/String;", "determineAppropriateEncoding", "Lio/livekit/android/room/track/VideoEncoding;", "width", "", "height", "presetsForResolution", "Lio/livekit/android/room/track/VideoPreset;", "ridForVideoQuality", "quality", "Llivekit/LivekitModels$VideoQuality;", "videoLayersFromEncodings", "Llivekit/LivekitModels$VideoLayer;", "trackWidth", "trackHeight", "encodings", "Lorg/webrtc/RtpParameters$Encoding;", "videoQualityForRid", "rid", "livekit-android-sdk_release"})
public final class EncodingUtils {
    @NotNull
    public static final EncodingUtils INSTANCE = new EncodingUtils();
    @NotNull
    private static final String[] VIDEO_RIDS;
    @NotNull
    private static final List<VideoPreset169> PRESETS_16_9;
    @NotNull
    private static final List<VideoPreset43> PRESETS_4_3;

    private EncodingUtils() {
    }

    @NotNull
    public final String[] getVIDEO_RIDS() {
        return VIDEO_RIDS;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final VideoEncoding determineAppropriateEncoding(int width, int height) {
        VideoPreset videoPreset;
        Object v0;
        List<VideoPreset> presets;
        block2: {
            void $this$firstOrNull$iv;
            presets = this.presetsForResolution(width, height);
            int longestSize = Math.max(width, height);
            Iterable iterable = presets;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                VideoPreset it = (VideoPreset)element$iv;
                boolean bl = false;
                if (!(it.getCapture().getWidth() >= longestSize)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        if ((videoPreset = (VideoPreset)v0) == null) {
            videoPreset = (VideoPreset)CollectionsKt.last(presets);
        }
        VideoPreset preset = videoPreset;
        return preset.getEncoding();
    }

    @NotNull
    public final List<VideoPreset> presetsForResolution(int width, int height) {
        int shortestSize;
        int longestSize = Math.max(width, height);
        float aspectRatio = (float)longestSize / (float)(shortestSize = Math.min(width, height));
        return Math.abs(aspectRatio - 1.7777778f) < Math.abs(aspectRatio - 1.3333334f) ? PRESETS_16_9 : PRESETS_4_3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LivekitModels.VideoLayer> videoLayersFromEncodings(int trackWidth, int trackHeight, @NotNull List<? extends RtpParameters.Encoding> encodings) {
        List list;
        Intrinsics.checkNotNullParameter(encodings, (String)"encodings");
        if (encodings.isEmpty()) {
            LivekitModels.VideoLayer.Builder builder;
            LivekitModels.VideoLayer.Builder $this$videoLayersFromEncodings_u24lambda_u2d1 = builder = LivekitModels.VideoLayer.newBuilder();
            boolean bl = false;
            $this$videoLayersFromEncodings_u24lambda_u2d1.setWidth(trackWidth);
            $this$videoLayersFromEncodings_u24lambda_u2d1.setHeight(trackHeight);
            $this$videoLayersFromEncodings_u24lambda_u2d1.setQuality(LivekitModels.VideoQuality.HIGH);
            $this$videoLayersFromEncodings_u24lambda_u2d1.setBitrate(0);
            $this$videoLayersFromEncodings_u24lambda_u2d1.setSsrc(0);
            list = CollectionsKt.listOf((Object)builder.build());
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = encodings;
            boolean $i$f$map = false;
            Iterable bl = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                int n;
                Integer n2;
                LivekitModels.VideoLayer.Builder builder;
                void encoding;
                RtpParameters.Encoding encoding2 = (RtpParameters.Encoding)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Double d = encoding.scaleResolutionDownBy;
                if (d == null) {
                    d = 1.0;
                }
                Intrinsics.checkNotNullExpressionValue((Object)d, (String)"encoding.scaleResolutionDownBy ?: 1.0");
                double scaleDownBy = ((Number)d).doubleValue();
                LivekitModels.VideoQuality videoQuality = null;
                String string = encoding.rid;
                if (string == null) {
                    string = "";
                }
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encoding.rid ?: \"\"");
                videoQuality = INSTANCE.videoQualityForRid(string);
                if (videoQuality == LivekitModels.VideoQuality.UNRECOGNIZED && encodings.size() == 1) {
                    videoQuality = LivekitModels.VideoQuality.HIGH;
                }
                LivekitModels.VideoLayer.Builder $this$videoLayersFromEncodings_u24lambda_u2d3_u24lambda_u2d2 = builder = LivekitModels.VideoLayer.newBuilder();
                boolean bl3 = false;
                $this$videoLayersFromEncodings_u24lambda_u2d3_u24lambda_u2d2.setWidth((int)((double)trackWidth / scaleDownBy));
                $this$videoLayersFromEncodings_u24lambda_u2d3_u24lambda_u2d2.setHeight((int)((double)trackHeight / scaleDownBy));
                $this$videoLayersFromEncodings_u24lambda_u2d3_u24lambda_u2d2.setQuality(videoQuality);
                Integer n3 = n2 = encoding.maxBitrateBps;
                if (n3 == null) {
                    n = 0;
                } else {
                    Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"encoding.maxBitrateBps ?: 0");
                    n = n2;
                }
                $this$videoLayersFromEncodings_u24lambda_u2d3_u24lambda_u2d2.setBitrate(n);
                $this$videoLayersFromEncodings_u24lambda_u2d3_u24lambda_u2d2.setSsrc(0);
                collection.add((LivekitModels.VideoLayer)builder.build());
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    @NotNull
    public final LivekitModels.VideoQuality videoQualityForRid(@NotNull String rid) {
        LivekitModels.VideoQuality videoQuality;
        Intrinsics.checkNotNullParameter((Object)rid, (String)"rid");
        switch (rid) {
            case "f": {
                videoQuality = LivekitModels.VideoQuality.HIGH;
                break;
            }
            case "h": {
                videoQuality = LivekitModels.VideoQuality.MEDIUM;
                break;
            }
            case "q": {
                videoQuality = LivekitModels.VideoQuality.LOW;
                break;
            }
            default: {
                videoQuality = LivekitModels.VideoQuality.UNRECOGNIZED;
            }
        }
        return videoQuality;
    }

    @Nullable
    public final String ridForVideoQuality(@NotNull LivekitModels.VideoQuality quality) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)quality), (String)"quality");
        switch (WhenMappings.$EnumSwitchMapping$0[quality.ordinal()]) {
            case 1: {
                string = "f";
                break;
            }
            case 2: {
                string = "h";
                break;
            }
            case 3: {
                string = "q";
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    static {
        Object[] objectArray = new String[]{"q", "h", "f"};
        VIDEO_RIDS = objectArray;
        objectArray = new VideoPreset169[]{VideoPreset169.QVGA, VideoPreset169.VGA, VideoPreset169.QHD, VideoPreset169.HD, VideoPreset169.FHD};
        PRESETS_16_9 = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new VideoPreset43[]{VideoPreset43.QVGA, VideoPreset43.VGA, VideoPreset43.QHD, VideoPreset43.HD, VideoPreset43.FHD};
        PRESETS_4_3 = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LivekitModels.VideoQuality.values().length];
            nArray[LivekitModels.VideoQuality.HIGH.ordinal()] = 1;
            nArray[LivekitModels.VideoQuality.MEDIUM.ordinal()] = 2;
            nArray[LivekitModels.VideoQuality.LOW.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

