/*
 * Decompiled with CFR 0.152.
 */
package io.livekit.android.stats;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.os.Build;
import androidx.compose.runtime.internal.StabilityInferred;
import io.livekit.android.stats.NetworkInfo;
import io.livekit.android.stats.NetworkType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/livekit/android/stats/AndroidNetworkInfo;", "Lio/livekit/android/stats/NetworkInfo;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getNetworkType", "Lio/livekit/android/stats/NetworkType;", "livekit-android-sdk_release"})
@StabilityInferred(parameters=0)
public final class AndroidNetworkInfo
implements NetworkInfo {
    @NotNull
    private final Context context;
    public static final int $stable = 8;

    public AndroidNetworkInfo(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @Override
    @NotNull
    public NetworkType getNetworkType() {
        NetworkType networkType;
        Object object = this.context.getSystemService("connectivity");
        ConnectivityManager connectivityManager = object instanceof ConnectivityManager ? (ConnectivityManager)object : null;
        if (connectivityManager == null) {
            return NetworkType.UNKNOWN;
        }
        ConnectivityManager connectivityManager2 = connectivityManager;
        if (Build.VERSION.SDK_INT >= 23) {
            Network network = connectivityManager2.getActiveNetwork();
            if (network == null) {
                return NetworkType.UNKNOWN;
            }
            Network nw = network;
            NetworkCapabilities networkCapabilities = connectivityManager2.getNetworkCapabilities(nw);
            if (networkCapabilities == null) {
                return NetworkType.UNKNOWN;
            }
            NetworkCapabilities actNw = networkCapabilities;
            return actNw.hasTransport(1) ? NetworkType.WIFI : (actNw.hasTransport(3) ? NetworkType.ETHERNET : (actNw.hasTransport(0) ? NetworkType.CELLULAR : (actNw.hasTransport(4) ? NetworkType.VPN : (actNw.hasTransport(2) ? NetworkType.BLUETOOTH : (actNw.hasTransport(5) ? NetworkType.OTHER : (actNw.hasTransport(6) ? NetworkType.OTHER : (actNw.hasTransport(8) ? NetworkType.OTHER : NetworkType.UNKNOWN)))))));
        }
        android.net.NetworkInfo info = connectivityManager2.getActiveNetworkInfo();
        if (info == null || !info.isConnected()) {
            return NetworkType.UNKNOWN;
        }
        switch (info.getType()) {
            case 7: {
                networkType = NetworkType.BLUETOOTH;
                break;
            }
            case 8: {
                networkType = NetworkType.UNKNOWN;
                break;
            }
            case 9: {
                networkType = NetworkType.ETHERNET;
                break;
            }
            case 0: {
                networkType = NetworkType.CELLULAR;
                break;
            }
            case 4: {
                networkType = NetworkType.CELLULAR;
                break;
            }
            case 5: {
                networkType = NetworkType.CELLULAR;
                break;
            }
            case 2: {
                networkType = NetworkType.CELLULAR;
                break;
            }
            case 3: {
                networkType = NetworkType.CELLULAR;
                break;
            }
            case 17: {
                networkType = NetworkType.VPN;
                break;
            }
            case 1: {
                networkType = NetworkType.WIFI;
                break;
            }
            case 6: {
                networkType = NetworkType.CELLULAR;
                break;
            }
            default: {
                networkType = NetworkType.UNKNOWN;
            }
        }
        return networkType;
    }
}

