/*
 * Decompiled with CFR 0.152.
 */
package io.livekit.android.webrtc;

import io.livekit.android.util.LKLog;
import io.livekit.android.util.LoggingLevel;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.webrtc.MediaStreamTrack;
import org.webrtc.RTCStats;
import org.webrtc.RTCStatsReport;
import timber.log.Timber;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a^\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00012\b\u0010\b\u001a\u0004\u0018\u00010\u00042\b\u0010\t\u001a\u0004\u0018\u00010\u00042\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u000bH\u0002\u001a&\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\u00042\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u000bH\u0002\u001a&\u0010\u000e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u000bH\u0002\u001a\u0012\u0010\u000f\u001a\u00020\u0010*\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u000f\u001a\u00020\u0010*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u0013"}, d2={"getExtraStats", "", "Lorg/webrtc/RTCStats;", "trackIdentifier", "", "ssrcs", "", "codecIds", "localCandidateId", "remoteCandidateId", "statsMap", "", "getStreamStats", "trackId", "getTrackStats", "getFilteredStats", "Lorg/webrtc/RTCStatsReport;", "track", "Lorg/webrtc/MediaStreamTrack;", "livekit-android-sdk_release"})
public final class RTCStatsExtKt {
    @NotNull
    public static final RTCStatsReport getFilteredStats(@NotNull RTCStatsReport $this$getFilteredStats, @NotNull MediaStreamTrack track2) {
        Intrinsics.checkNotNullParameter((Object)$this$getFilteredStats, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)track2, (String)"track");
        String string = track2.id();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"track.id()");
        return RTCStatsExtKt.getFilteredStats($this$getFilteredStats, string);
    }

    @NotNull
    public static final RTCStatsReport getFilteredStats(@NotNull RTCStatsReport $this$getFilteredStats, @NotNull String trackIdentifier) {
        Intrinsics.checkNotNullParameter((Object)$this$getFilteredStats, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)trackIdentifier, (String)"trackIdentifier");
        RTCStatsReport rtcStatsReport = $this$getFilteredStats;
        Map statsMap = rtcStatsReport.getStatsMap();
        Set filteredStats = new LinkedHashSet();
        Intrinsics.checkNotNullExpressionValue((Object)statsMap, (String)"statsMap");
        RTCStats trackStats = RTCStatsExtKt.getTrackStats(trackIdentifier, statsMap);
        if (trackStats == null) {
            LKLog.Companion $this$iv = LKLog.Companion;
            Throwable t$iv = null;
            boolean $i$f$i = false;
            LKLog.Companion companion = $this$iv;
            LoggingLevel loggingLevel$iv$iv = LoggingLevel.INFO;
            boolean $i$f$log$livekit_android_sdk_release = false;
            if (loggingLevel$iv$iv.compareTo((Enum)LKLog.Companion.getLoggingLevel()) >= 0 && Timber.treeCount() > 0) {
                boolean bl = false;
                Throwable throwable = t$iv;
                boolean bl2 = false;
                Timber.i(throwable, (String)"getStats: couldn't find track stats!", (Object[])new Object[0]);
            }
            return new RTCStatsReport((long)rtcStatsReport.getTimestampUs(), (Map)new HashMap());
        }
        filteredStats.add(trackStats);
        String trackId = trackStats.getId();
        Intrinsics.checkNotNullExpressionValue((Object)trackId, (String)"trackId");
        RTCStats streamStats = RTCStatsExtKt.getStreamStats(trackId, statsMap);
        if (streamStats != null) {
            filteredStats.add(streamStats);
        }
        Set ssrcs = new HashSet();
        Set codecIds = new HashSet();
        for (Object stats : statsMap.values()) {
            if (!Intrinsics.areEqual((Object)stats.getType(), (Object)"inbound-rtp") && !Intrinsics.areEqual((Object)stats.getType(), (Object)"outbound-rtp") || !Intrinsics.areEqual((Object)trackId, stats.getMembers().get("trackId"))) continue;
            ssrcs.add((Long)stats.getMembers().get("ssrc"));
            codecIds.add((String)stats.getMembers().get("codecId"));
            Intrinsics.checkNotNullExpressionValue((Object)stats, (String)"stats");
            filteredStats.add(stats);
        }
        RTCStats candidatePairStats = null;
        for (RTCStats stats : statsMap.values()) {
            if (!Intrinsics.areEqual((Object)stats.getType(), (Object)"candidate-pair") || !Intrinsics.areEqual(stats.getMembers().get("nominated"), (Object)true)) continue;
            candidatePairStats = stats;
            break;
        }
        String localCandidateId = null;
        String remoteCandidateId = null;
        if (candidatePairStats != null) {
            filteredStats.add(candidatePairStats);
            localCandidateId = (String)candidatePairStats.getMembers().get("localCandidateId");
            remoteCandidateId = (String)candidatePairStats.getMembers().get("remoteCandidateId");
        }
        filteredStats.addAll((Collection)RTCStatsExtKt.getExtraStats(trackIdentifier, ssrcs, codecIds, localCandidateId, remoteCandidateId, statsMap));
        Map filteredStatsMap = new HashMap();
        for (RTCStats stats : filteredStats) {
            Map map2 = filteredStatsMap;
            String string = stats.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stats.id");
            map2.put(string, stats);
        }
        return new RTCStatsReport((long)rtcStatsReport.getTimestampUs(), filteredStatsMap);
    }

    private static final RTCStats getTrackStats(String trackIdentifier, Map<String, ? extends RTCStats> statsMap) {
        for (RTCStats rTCStats : statsMap.values()) {
            if (!Intrinsics.areEqual((Object)rTCStats.getType(), (Object)"track") || !Intrinsics.areEqual((Object)trackIdentifier, rTCStats.getMembers().get("trackIdentifier"))) continue;
            return rTCStats;
        }
        return null;
    }

    private static final RTCStats getStreamStats(String trackId, Map<String, ? extends RTCStats> statsMap) {
        for (RTCStats rTCStats : statsMap.values()) {
            Object trackIds;
            if (!Intrinsics.areEqual((Object)rTCStats.getType(), (Object)"stream")) continue;
            Object v = rTCStats.getMembers().get("trackIds");
            Object object = v instanceof Object[] ? (Object[])v : null;
            if (object == null || (object = ArraysKt.toList((Object[])object)) == null) {
                object = CollectionsKt.emptyList();
            }
            if (!(trackIds = object).contains(trackId)) continue;
            return rTCStats;
        }
        return null;
    }

    private static final Set<RTCStats> getExtraStats(String trackIdentifier, Set<Long> ssrcs, Set<String> codecIds, String localCandidateId, String remoteCandidateId, Map<String, ? extends RTCStats> statsMap) {
        Set extraStats = new HashSet();
        for (RTCStats rTCStats : statsMap.values()) {
            String string = rTCStats.getType();
            if (Intrinsics.areEqual((Object)string, (Object)"certificate") ? true : Intrinsics.areEqual((Object)string, (Object)"transport")) {
                extraStats.add(rTCStats);
            }
            if (Intrinsics.areEqual((Object)rTCStats.getId(), (Object)localCandidateId) || Intrinsics.areEqual((Object)rTCStats.getId(), (Object)remoteCandidateId)) {
                extraStats.add(rTCStats);
                continue;
            }
            if (CollectionsKt.contains((Iterable)ssrcs, rTCStats.getMembers().get("ssrc"))) {
                extraStats.add(rTCStats);
                continue;
            }
            if (Intrinsics.areEqual((Object)trackIdentifier, rTCStats.getMembers().get("trackIdentifier"))) {
                extraStats.add(rTCStats);
                continue;
            }
            if (!codecIds.contains(rTCStats.getId())) continue;
            extraStats.add(rTCStats);
        }
        return extraStats;
    }
}

