/*
 * Decompiled with CFR 0.152.
 */
package io.livekit.lint;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallableReferenceExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.kotlin.KotlinUQualifiedReferenceExpression;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lio/livekit/lint/FlowDelegateUsageDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "getApplicableReferenceNames", "", "", "visitReference", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "reference", "Lorg/jetbrains/uast/UReferenceExpression;", "referenced", "Lcom/intellij/psi/PsiElement;", "Companion", "livekit-lint"})
public final class FlowDelegateUsageDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String GET_FLOW = "getFlow";
    @NotNull
    private static final String FLOW_DELEGATE = "io.livekit.android.util.FlowDelegateKt";
    @NotNull
    private static final String FLOW_OBSERVABLE_ANNOTATION = "io.livekit.android.util.FlowObservable";
    @NotNull
    private static final String DEFAULT_MSG = "Incorrect flow property usage: Only properties marked with the @FlowObservable annotation can be observed using `io.livekit.android.util.flow`. Improper usage will result in a NullPointerException.";
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(FlowDelegateUsageDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    /*
     * WARNING - void declaration
     */
    public void visitReference(@NotNull JavaContext context, @NotNull UReferenceExpression reference, @NotNull PsiElement referenced) {
        boolean isAnnotated;
        boolean bl;
        String accumulator$iv;
        StringBuilder stringBuilder;
        UExpression rec;
        KotlinUQualifiedReferenceExpression parent;
        block14: {
            block13: {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
                Intrinsics.checkNotNullParameter((Object)referenced, (String)"referenced");
                PsiMethod psiMethod = referenced instanceof PsiMethod ? (PsiMethod)referenced : null;
                if (psiMethod == null) {
                    return;
                }
                PsiMethod referencedMethod = psiMethod;
                if (!Intrinsics.areEqual((Object)((PsiMethod)referenced).getName(), (Object)GET_FLOW)) break block13;
                PsiClass psiClass = referencedMethod.getContainingClass();
                if (Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)FLOW_DELEGATE)) break block14;
            }
            return;
        }
        UElement uElement = reference.getUastParent();
        KotlinUQualifiedReferenceExpression kotlinUQualifiedReferenceExpression = parent = uElement instanceof KotlinUQualifiedReferenceExpression ? (KotlinUQualifiedReferenceExpression)uElement : null;
        UExpression uExpression = rec = kotlinUQualifiedReferenceExpression != null ? kotlinUQualifiedReferenceExpression.getReceiver() : null;
        PsiElement resolve = uExpression != null ? UastUtils.tryResolve((UElement)((UElement)uExpression)) : null;
        System.out.println((Object)("parent: " + parent + ", rec: " + rec + ", resolve: " + resolve));
        Object object = reference.getUastParent();
        Object[] objectArray = object instanceof KotlinUQualifiedReferenceExpression ? (Object[])object : null;
        UExpression uExpression2 = objectArray != null ? objectArray.getReceiver() : null;
        UCallableReferenceExpression uCallableReferenceExpression = uExpression2 instanceof UCallableReferenceExpression ? (UCallableReferenceExpression)uExpression2 : null;
        PsiElement receiver = uCallableReferenceExpression != null ? uCallableReferenceExpression.resolve() : null;
        uExpression2 = receiver;
        if (uExpression2 instanceof PsiMethod) {
            void $this$fold$iv;
            void initial$iv;
            StringBuilder stringBuilder2 = new StringBuilder().append(((PsiMethod)receiver).getName()).append(",  ");
            PsiAnnotation[] psiAnnotationArray = ((PsiMethod)receiver).getAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationArray, (String)"receiver.annotations");
            objectArray = psiAnnotationArray;
            object = "";
            stringBuilder = stringBuilder2;
            boolean $i$f$fold = false;
            accumulator$iv = initial$iv;
            for (void element$iv : $this$fold$iv) {
                void next;
                PsiAnnotation psiAnnotation = (PsiAnnotation)element$iv;
                String total = accumulator$iv;
                boolean bl2 = false;
                accumulator$iv = total + ", " + next.getText();
            }
            System.out.println((Object)stringBuilder.append(accumulator$iv).toString());
            bl = ((PsiMethod)receiver).hasAnnotation(FLOW_OBSERVABLE_ANNOTATION);
        } else if (uExpression2 instanceof PsiField) {
            String string;
            PsiAnnotation[] $i$f$fold = ((PsiField)receiver).getType();
            PsiClassType psiClassType = $i$f$fold instanceof PsiClassType ? (PsiClassType)$i$f$fold : null;
            PsiAnnotation[] receiverClass = psiClassType != null ? psiClassType.resolve() : null;
            StringBuilder stringBuilder3 = new StringBuilder().append(receiverClass).append(",  ");
            PsiAnnotation[] psiAnnotationArray = receiverClass;
            if (receiverClass != null && (psiAnnotationArray = psiAnnotationArray.getAnnotations()) != null) {
                void $this$fold$iv;
                void initial$iv;
                $i$f$fold = psiAnnotationArray;
                accumulator$iv = "";
                stringBuilder = stringBuilder3;
                boolean $i$f$fold2 = false;
                String accumulator$iv2 = initial$iv;
                int n = ((void)$this$fold$iv).length;
                for (int i = 0; i < n; ++i) {
                    void next;
                    void element$iv;
                    void bl2 = element$iv = $this$fold$iv[i];
                    void total = accumulator$iv2;
                    boolean bl3 = false;
                    accumulator$iv2 = (String)total + ", " + next.getText();
                }
                string = accumulator$iv2;
                stringBuilder3 = stringBuilder;
            } else {
                string = null;
            }
            System.out.println((Object)stringBuilder3.append(string).toString());
            bl = receiverClass != null ? receiverClass.hasAnnotation(FLOW_OBSERVABLE_ANNOTATION) : false;
        } else {
            bl = isAnnotated = false;
        }
        if (!isAnnotated) {
            String message = DEFAULT_MSG;
            Location location = context.getLocation((UElement)reference);
            JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)reference), (Location)location, (String)message, null, (int)16, null);
        }
    }

    @Nullable
    public List<String> getApplicableReferenceNames() {
        return CollectionsKt.listOf((Object)"flow");
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"FlowDelegateUsageDetector", (String)"flow on a non-@FlowObservable property", (String)"\n                Only properties marked with the @FlowObservable annotation can be observed using\n                `io.livekit.android.util.flow`.\n                ", (Implementation)implementation, (String)"https://issuetracker.google.com/116789824", (Category)category, (int)4, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3328, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/livekit/lint/FlowDelegateUsageDetector$Companion;", "", "()V", "DEFAULT_MSG", "", "FLOW_DELEGATE", "FLOW_OBSERVABLE_ANNOTATION", "GET_FLOW", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "livekit-lint"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

