/*
 * Decompiled with CFR 0.152.
 */
package io.livekit.lint;

import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UastBinaryOperator;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u00012\u00020\u0002:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\u000e\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u00100\u000fH\u0016\u00a8\u0006\u0013"}, d2={"Lio/livekit/lint/MediaTrackEqualsDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "checkCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "checkExpression", "Lorg/jetbrains/uast/UBinaryExpression;", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UExpression;", "Companion", "livekit-lint"})
public final class MediaTrackEqualsDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String MEDIA_STREAM_TRACK = "org.webrtc.MediaStreamTrack";
    @NotNull
    private static final String DEFAULT_MSG = "Suspicious equality check: MediaStreamTracks should not be checked for equality. Check id() instead.";
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(MediaTrackEqualsDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @NotNull
    public List<Class<? extends UExpression>> getApplicableUastTypes() {
        Object[] objectArray = new Class[]{UBinaryExpression.class, UCallExpression.class};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Nullable
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new UElementHandler(this, context){
            final /* synthetic */ MediaTrackEqualsDetector this$0;
            final /* synthetic */ JavaContext $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
            }

            public void visitBinaryExpression(@NotNull UBinaryExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                MediaTrackEqualsDetector.access$checkExpression(this.this$0, this.$context, node);
            }

            public void visitCallExpression(@NotNull UCallExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                MediaTrackEqualsDetector.access$checkCall(this.this$0, this.$context, node);
            }
        };
    }

    private final void checkCall(JavaContext context, UCallExpression node) {
        if (Intrinsics.areEqual((Object)node.getMethodName(), (Object)"equals")) {
            PsiType psiType;
            List list;
            List list2;
            PsiType psiType2 = node.getReceiverType();
            if (psiType2 == null) {
                return;
            }
            PsiType left = psiType2;
            List it = list2 = node.getValueArguments();
            boolean bl = false;
            List list3 = list = !((Collection)it).isEmpty() ? list2 : null;
            if (list == null || (list2 = (UExpression)list.get(0)) == null || (psiType = list2.getExpressionType()) == null) {
                return;
            }
            PsiType right = psiType;
            if (left instanceof PsiClassType && right instanceof PsiClassType && (Intrinsics.areEqual((Object)((PsiClassType)left).getCanonicalText(), (Object)MEDIA_STREAM_TRACK) || Intrinsics.areEqual((Object)((PsiClassType)right).getCanonicalText(), (Object)MEDIA_STREAM_TRACK))) {
                String message = DEFAULT_MSG;
                Location location = context.getLocation((UElement)node);
                JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)node), (Location)location, (String)message, null, (int)16, null);
            }
        }
    }

    private final void checkExpression(JavaContext context, UBinaryExpression node) {
        block5: {
            UIdentifier uIdentifier;
            String message;
            block7: {
                block6: {
                    if (!Intrinsics.areEqual((Object)node.getOperator(), (Object)UastBinaryOperator.IDENTITY_EQUALS) && !Intrinsics.areEqual((Object)node.getOperator(), (Object)UastBinaryOperator.EQUALS)) break block5;
                    PsiType psiType = node.getLeftOperand().getExpressionType();
                    if (psiType == null) {
                        return;
                    }
                    PsiType left = psiType;
                    PsiType psiType2 = node.getRightOperand().getExpressionType();
                    if (psiType2 == null) {
                        return;
                    }
                    PsiType right = psiType2;
                    if (!(left instanceof PsiClassType) || !(right instanceof PsiClassType) || !Intrinsics.areEqual((Object)((PsiClassType)left).getCanonicalText(), (Object)MEDIA_STREAM_TRACK) && !Intrinsics.areEqual((Object)((PsiClassType)right).getCanonicalText(), (Object)MEDIA_STREAM_TRACK)) break block5;
                    message = DEFAULT_MSG;
                    uIdentifier = node.getOperatorIdentifier();
                    if (uIdentifier == null) break block6;
                    UIdentifier it = uIdentifier;
                    boolean bl = false;
                    Location location = context.getLocation((UElement)it);
                    uIdentifier = location;
                    if (location != null) break block7;
                }
                uIdentifier = context.getLocation((UElement)node);
            }
            UIdentifier location = uIdentifier;
            JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)node), (Location)location, (String)message, null, (int)16, null);
        }
    }

    public static final /* synthetic */ void access$checkExpression(MediaTrackEqualsDetector $this, JavaContext context, UBinaryExpression node) {
        $this.checkExpression(context, node);
    }

    public static final /* synthetic */ void access$checkCall(MediaTrackEqualsDetector $this, JavaContext context, UCallExpression node) {
        $this.checkCall(context, node);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"MediaTrackEqualsDetector", (String)"Suspicious MediaStreamTrack Equality", (String)"\n                MediaStreamTrack does not implement `equals`, and therefore cannot be relied upon.\n                Additionally, many MediaStreamTrack objects may exist for the same underlying stream,\n                and therefore the identity operator `===` is unreliable. \n                ", (Implementation)implementation, (String)"https://github.com/livekit/client-sdk-android/commit/01152f2ac01dae59759383d587cdc21035718b8e", (Category)category, (int)4, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3328, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/livekit/lint/MediaTrackEqualsDetector$Companion;", "", "()V", "DEFAULT_MSG", "", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "MEDIA_STREAM_TRACK", "livekit-lint"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

