/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender;

import io.logz.sender.FormattedLogMessage;
import io.logz.sender.HttpsRequestConfiguration;
import io.logz.sender.SenderStatusReporter;
import io.logz.sender.exceptions.LogzioServerErrorException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.util.List;

public class HttpsSyncSender {
    private final HttpsRequestConfiguration configuration;
    private final SenderStatusReporter reporter;

    public HttpsSyncSender(HttpsRequestConfiguration configuration, SenderStatusReporter reporter) {
        this.configuration = configuration;
        this.reporter = reporter;
    }

    public HttpsRequestConfiguration getConfiguration() {
        return this.configuration;
    }

    private boolean shouldRetry(int statusCode) {
        boolean shouldRetry = true;
        switch (statusCode) {
            case 200: 
            case 400: 
            case 401: {
                shouldRetry = false;
            }
        }
        return shouldRetry;
    }

    /*
     * Exception decompiling
     */
    private byte[] toNewLineSeparatedByteArray(List<FormattedLogMessage> messages) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int sizeInBytes(List<FormattedLogMessage> logMessages) {
        int totalSize = 0;
        for (FormattedLogMessage currLog : logMessages) {
            totalSize += currLog.getSize();
        }
        return totalSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendToLogzio(List<FormattedLogMessage> messages) throws LogzioServerErrorException {
        try {
            byte[] payload = this.toNewLineSeparatedByteArray(messages);
            int currentRetrySleep = this.configuration.getInitialWaitBeforeRetryMS();
            for (int currTry = 1; currTry <= this.configuration.getMaxRetriesAttempts(); ++currTry) {
                boolean shouldRetry = true;
                int responseCode = 0;
                String responseMessage = "";
                IOException savedException = null;
                try {
                    HttpURLConnection conn = (HttpURLConnection)this.configuration.getLogzioListenerUrl().openConnection();
                    conn.setRequestMethod(this.configuration.getRequestMethod());
                    conn.setRequestProperty("Content-length", String.valueOf(payload.length));
                    conn.setRequestProperty("Content-Type", "text/plain");
                    if (this.configuration.isCompressRequests()) {
                        conn.setRequestProperty("Content-Encoding", "gzip");
                    }
                    conn.setReadTimeout(this.configuration.getSocketTimeout());
                    conn.setConnectTimeout(this.configuration.getConnectTimeout());
                    conn.setDoOutput(true);
                    conn.setDoInput(true);
                    conn.getOutputStream().write(payload);
                    responseCode = conn.getResponseCode();
                    responseMessage = conn.getResponseMessage();
                    if (responseCode == 400) {
                        BufferedReader bufferedReader = null;
                        try {
                            StringBuilder problemDescription = new StringBuilder();
                            InputStream errorStream = conn.getErrorStream();
                            if (errorStream != null) {
                                bufferedReader = new BufferedReader(new InputStreamReader(errorStream));
                                bufferedReader.lines().forEach(line -> problemDescription.append("\n").append((String)line));
                                this.reporter.warning(String.format("Got 400 from logzio, here is the output: %s", problemDescription));
                            }
                        }
                        finally {
                            if (bufferedReader != null) {
                                try {
                                    bufferedReader.close();
                                }
                                catch (Exception exception) {}
                            }
                        }
                    }
                    if (responseCode == 401) {
                        this.reporter.error("Logz.io: Got forbidden! Your token is not right. Unfortunately, dropping logs. Message: " + responseMessage);
                    }
                    shouldRetry = this.shouldRetry(responseCode);
                }
                catch (IOException e) {
                    savedException = e;
                    this.reporter.error("Got IO exception - " + e.getMessage());
                }
                if (!shouldRetry && responseCode == 200) {
                    this.reporter.info("Successfully sent bulk to logz.io, size: " + payload.length);
                    break;
                }
                if (currTry == this.configuration.getMaxRetriesAttempts()) {
                    if (savedException != null) {
                        this.reporter.error("Got IO exception on the last bulk try to logz.io", savedException);
                    }
                    throw new LogzioServerErrorException("Got HTTP " + responseCode + " code from logz.io, with message: " + responseMessage);
                }
                this.reporter.warning("Could not send log to logz.io, retry (" + currTry + "/" + this.configuration.getMaxRetriesAttempts() + ")");
                this.reporter.warning("Sleeping for " + currentRetrySleep + " ms and will try again.");
                Thread.sleep(currentRetrySleep);
                currentRetrySleep *= 2;
            }
        }
        catch (InterruptedException e) {
            this.reporter.info("Got interrupted exception");
            Thread.currentThread().interrupt();
        }
    }
}

