/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.org.kairosdb.metrics4j.configuration;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;

public class PluginClassLoader
extends URLClassLoader {
    ClassLoader m_parentLoader;

    public PluginClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this.m_parentLoader = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                try {
                    c = this.findClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (c == null) {
                c = this.m_parentLoader.loadClass(name);
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
    }

    @Override
    public URL getResource(String name) {
        URL url = this.findResource(name);
        if (url == null) {
            url = this.m_parentLoader.getResource(name);
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return new ConcatEnumeration(this.findResources(name), this.m_parentLoader.getResources(name));
    }

    private class ConcatEnumeration
    implements Enumeration<URL> {
        Enumeration<URL> m_first;
        Enumeration<URL> m_second;

        public ConcatEnumeration(Enumeration<URL> first, Enumeration<URL> second) {
            this.m_first = first;
            this.m_second = second;
        }

        @Override
        public boolean hasMoreElements() {
            return this.m_first.hasMoreElements() || this.m_second.hasMoreElements();
        }

        @Override
        public URL nextElement() {
            return this.m_first.hasMoreElements() ? this.m_first.nextElement() : this.m_second.nextElement();
        }
    }
}

