/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.org.kairosdb.metrics4j.internal;

import io.logz.sender.org.kairosdb.metrics4j.configuration.MissingReferenceException;
import io.logz.sender.org.kairosdb.metrics4j.internal.ArgKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ComponentTracker<T> {
    protected final Map<String, T> m_components;
    private final Map<List<String>, T> m_mappedComponents;
    protected final String m_componentType;
    private final List<ComponentListener> m_listeners;

    public ComponentTracker(String componentType) {
        this.m_componentType = componentType;
        this.m_components = new HashMap<String, T>();
        this.m_mappedComponents = new HashMap<List<String>, T>();
        this.m_listeners = new ArrayList<ComponentListener>();
    }

    public void addToPath(String name, List<String> path) {
        T component = this.m_components.get(name);
        if (component == null) {
            throw new MissingReferenceException(this.m_componentType, name);
        }
        this.m_mappedComponents.put(path, component);
    }

    public T getComponentForKey(ArgKey key) {
        ArrayList<String> searchPath;
        T ret = null;
        List<String> configPath = key.getConfigPath();
        for (int i = configPath.size(); i >= 0 && (ret = (T)this.m_mappedComponents.get(searchPath = new ArrayList<String>(configPath.subList(0, i)))) == null; --i) {
        }
        return ret;
    }

    public void addComponent(String name, T component) {
        this.m_components.put(name, component);
        for (ComponentListener listener : this.m_listeners) {
            listener.newComponent(name, component);
        }
    }

    public T getComponent(String name) {
        return this.m_components.get(name);
    }

    public void addComponentListener(ComponentListener<T> listener) {
        for (String name : this.m_components.keySet()) {
            listener.newComponent(name, this.m_components.get(name));
        }
        this.m_listeners.add(listener);
    }

    public static interface ComponentListener<T> {
        public void newComponent(String var1, T var2);
    }
}

