/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.org.kairosdb.metrics4j.internal;

import io.logz.sender.org.kairosdb.metrics4j.annotation.Key;
import io.logz.sender.org.kairosdb.metrics4j.configuration.ImplementationException;
import io.logz.sender.org.kairosdb.metrics4j.internal.ArgKey;
import io.logz.sender.org.kairosdb.metrics4j.internal.TagKey;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class MethodArgKey
implements ArgKey {
    private final Method m_method;
    private final Object[] m_args;
    private final List<String> m_configPath;

    public MethodArgKey(Method method, Object[] args) {
        String[] split;
        this.m_method = method;
        this.m_args = args;
        this.m_configPath = new ArrayList<String>();
        for (String s : split = this.m_method.getDeclaringClass().getName().split("\\.")) {
            this.m_configPath.add(s);
        }
        this.m_configPath.add(this.m_method.getName());
    }

    @Override
    public List<String> getConfigPath() {
        return this.m_configPath;
    }

    public Method getMethod() {
        return this.m_method;
    }

    public TagKey getTagKey() {
        if (this.m_args == null || this.m_args.length == 0) {
            return TagKey.newBuilder().build();
        }
        TagKey.Builder builder = TagKey.newBuilder();
        Annotation[][] parameterAnnotations = this.m_method.getParameterAnnotations();
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            Annotation[] annotations;
            String tagKey = null;
            for (Annotation annotation : annotations = parameterAnnotations[i]) {
                if (!(annotation instanceof Key)) continue;
                Key key = (Key)annotation;
                tagKey = key.value();
            }
            if (tagKey == null) {
                throw new ImplementationException("All parameters on " + this.m_method.getDeclaringClass().getName() + "." + this.m_method.getName() + " must be annotated with @Key()");
            }
            if (!(this.m_args[i] instanceof String)) {
                throw new ImplementationException("All parameters on " + this.m_method.getDeclaringClass().getName() + "." + this.m_method.getName() + " must be of type String");
            }
            builder.addTag(tagKey, (String)this.m_args[i]);
        }
        TagKey tag = builder.build();
        return tag;
    }

    @Override
    public String getMethodName() {
        return this.m_method.getName();
    }

    @Override
    public String getClassName() {
        return this.m_method.getDeclaringClass().getName();
    }

    public String toString() {
        return this.m_method.getDeclaringClass().getName() + "." + this.m_method.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodArgKey that = (MethodArgKey)o;
        return this.m_configPath.equals(that.m_configPath);
    }

    public int hashCode() {
        return Objects.hash(this.m_configPath);
    }
}

