/*
 * Decompiled with CFR 0.152.
 */
package io.logz.log4j2;

import io.logz.log4j2appender.com.google.common.base.Splitter;
import io.logz.log4j2appender.com.google.common.base.Throwables;
import io.logz.sender.HttpsRequestConfiguration;
import io.logz.sender.LogzioSender;
import io.logz.sender.SenderStatusReporter;
import io.logz.sender.com.google.gson.JsonObject;
import io.logz.sender.exceptions.LogzioParameterErrorException;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.util.Log4jThreadFactory;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.ReadOnlyStringMap;

@Plugin(name="LogzioAppender", category="Core", elementType="appender", printObject=true)
public class LogzioAppender
extends AbstractAppender {
    private static final String TIMESTAMP = "@timestamp";
    private static final String LOGLEVEL = "loglevel";
    private static final String MARKER = "marker";
    private static final String MESSAGE = "message";
    private static final String LOGGER = "logger";
    private static final String THREAD = "thread";
    private static final String EXCEPTION = "exception";
    private static final Set<String> reservedFields = new HashSet<String>(Arrays.asList("@timestamp", "loglevel", "marker", "message", "logger", "thread", "exception"));
    private static Logger statusLogger = StatusLogger.getLogger();
    private static final int DONT_LIMIT_CAPACITY = -1;
    private static final int LOWER_PERCENTAGE_FS_SPACE = 1;
    private static final int UPPER_PERCENTAGE_FS_SPACE = 100;
    private LogzioSender logzioSender;
    private final String logzioToken;
    private final String logzioType;
    private final int drainTimeoutSec;
    private final int fileSystemFullPercentThreshold;
    private final String queueDir;
    private final String logzioUrl;
    private final int connectTimeout;
    private final int socketTimeout;
    private final boolean debug;
    private final boolean addHostname;
    private final int gcPersistedQueueFilesIntervalSeconds;
    private final boolean compressRequests;
    private final boolean inMemoryQueue;
    private final long inMemoryQueueCapacityBytes;
    private final long inMemoryLogsCountCapacity;
    private String exceedMaxSizeAction;
    private final Map<String, String> additionalFieldsMap = new HashMap<String, String>();
    private final boolean addOpentelemetryContext;
    private static final Map<String, ScheduledExecutorService> tasksExecutors = new HashMap<String, ScheduledExecutorService>();
    private static final Map<LogzioAppender, LogzioSender> appenderToLogzioSender = new HashMap<LogzioAppender, LogzioSender>();

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    private LogzioAppender(String name, Filter filter, boolean ignoreExceptions, String url, String token, String type, int drainTimeoutSec, int fileSystemFullPercentThreshold, String queueDir, int socketTimeout, int connectTimeout, boolean addHostname, String additionalFields, boolean debug, int gcPersistedQueueFilesIntervalSeconds, boolean compressRequests, boolean inMemoryQueue, long inMemoryQueueCapacityBytes, long inMemoryLogsCountCapacity, String exceedMaxSizeAction, boolean addOpentelemetryContext) {
        super(name, filter, null, ignoreExceptions);
        this.logzioToken = LogzioAppender.getValueFromSystemEnvironmentIfNeeded(token);
        this.logzioUrl = LogzioAppender.getValueFromSystemEnvironmentIfNeeded(url);
        this.logzioType = LogzioAppender.getValueFromSystemEnvironmentIfNeeded(type);
        this.drainTimeoutSec = drainTimeoutSec;
        this.fileSystemFullPercentThreshold = fileSystemFullPercentThreshold;
        this.queueDir = queueDir;
        this.socketTimeout = socketTimeout;
        this.connectTimeout = connectTimeout;
        this.debug = debug;
        this.addHostname = addHostname;
        this.gcPersistedQueueFilesIntervalSeconds = gcPersistedQueueFilesIntervalSeconds;
        this.compressRequests = compressRequests;
        this.inMemoryQueue = inMemoryQueue;
        this.inMemoryQueueCapacityBytes = inMemoryQueueCapacityBytes;
        this.inMemoryLogsCountCapacity = inMemoryLogsCountCapacity;
        this.exceedMaxSizeAction = exceedMaxSizeAction;
        this.addOpentelemetryContext = addOpentelemetryContext;
        this.verifyExceedMaxSizeAction(exceedMaxSizeAction);
        if (additionalFields != null) {
            Splitter.on(';').omitEmptyStrings().withKeyValueSeparator('=').split(additionalFields).forEach((k, v) -> {
                if (reservedFields.contains(k)) {
                    statusLogger.warn("The field name '" + k + "' defined in additionalFields configuration can't be used since it's a reserved field name. This field will not be added to the outgoing log messages");
                } else {
                    String value = LogzioAppender.getValueFromSystemEnvironmentIfNeeded(v);
                    if (value != null) {
                        this.additionalFieldsMap.put((String)k, value);
                    }
                }
            });
            statusLogger.info("The additional fields that would be added: " + this.additionalFieldsMap.toString());
        }
    }

    private void verifyExceedMaxSizeAction(String exceedMaxSizeAction) {
        if (!Arrays.asList("cut", "drop").contains(exceedMaxSizeAction.toLowerCase())) {
            statusLogger.warn("Invalid value for parameter exceedMaxSizeAction, using default: cut");
            this.exceedMaxSizeAction = "cut";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        HttpsRequestConfiguration conf;
        this.safeStopLogzioSender();
        try {
            conf = this.getHttpsRequestConfiguration();
        }
        catch (LogzioParameterErrorException e) {
            statusLogger.error("Some of the configuration parameters of logz.io is wrong: " + e.getMessage(), (Throwable)e);
            return;
        }
        this.setHostname();
        LogzioSender.Builder logzioSenderBuilder = new LogzioSender.Builder().setDebug(this.debug).setDrainTimeoutSec(this.drainTimeoutSec).setReporter(new StatusReporter()).setHttpsRequestConfiguration(conf).setExceedMaxSizeAction(this.exceedMaxSizeAction).setWithOpentelemetryContext(this.addOpentelemetryContext);
        if (this.inMemoryQueue) {
            if (!this.validateQueueCapacity()) {
                return;
            }
            ScheduledExecutorService tasksExecutor = this.safeExecutorCreate(() -> Executors.newScheduledThreadPool(1, (ThreadFactory)Log4jThreadFactory.createDaemonThreadFactory((String)((Object)((Object)this)).getClass().getSimpleName())));
            logzioSenderBuilder.setTasksExecutor(tasksExecutor).withInMemoryQueue().setCapacityInBytes(this.inMemoryQueueCapacityBytes).setLogsCountLimit(this.inMemoryLogsCountCapacity).endInMemoryQueue();
        } else {
            if (!this.validateFSFullPercentThreshold()) {
                return;
            }
            File queueDirFile = this.getQueueDirFile();
            if (queueDirFile == null) {
                return;
            }
            ScheduledExecutorService tasksExecutor = this.safeExecutorCreate(() -> Executors.newScheduledThreadPool(3, (ThreadFactory)Log4jThreadFactory.createDaemonThreadFactory((String)((Object)((Object)this)).getClass().getSimpleName())));
            logzioSenderBuilder.setTasksExecutor(tasksExecutor).withDiskQueue().setQueueDir(queueDirFile).setFsPercentThreshold(this.fileSystemFullPercentThreshold).setGcPersistedQueueFilesIntervalSeconds(this.gcPersistedQueueFilesIntervalSeconds).endDiskQueue();
        }
        try {
            this.logzioSender = logzioSenderBuilder.build();
        }
        catch (LogzioParameterErrorException | IOException e) {
            statusLogger.error("Couldn't build logzio sender: " + e.getMessage(), (Throwable)e);
            return;
        }
        Map<LogzioAppender, LogzioSender> map = appenderToLogzioSender;
        synchronized (map) {
            appenderToLogzioSender.put(this, this.logzioSender);
        }
        this.logzioSender.start();
        super.start();
    }

    private void setHostname() {
        try {
            if (this.addHostname) {
                String hostname = InetAddress.getLocalHost().getHostName();
                this.additionalFieldsMap.put("hostname", hostname);
            }
        }
        catch (UnknownHostException e) {
            statusLogger.warn("The configuration addHostName was specified but the host could not be resolved, thus the field 'hostname' will not be added", (Throwable)e);
        }
    }

    private HttpsRequestConfiguration getHttpsRequestConfiguration() throws LogzioParameterErrorException {
        return HttpsRequestConfiguration.builder().setLogzioListenerUrl(this.logzioUrl).setSocketTimeout(this.socketTimeout).setLogzioType(this.logzioType).setLogzioToken(this.logzioToken).setConnectTimeout(this.connectTimeout).setCompressRequests(this.compressRequests).build();
    }

    private boolean validateQueueCapacity() {
        if (this.inMemoryQueueCapacityBytes <= 0L && this.inMemoryQueueCapacityBytes != -1L) {
            statusLogger.error("inMemoryQueueCapacityBytes should be a non zero integer or -1");
            return false;
        }
        if (this.inMemoryLogsCountCapacity <= 0L && this.inMemoryLogsCountCapacity != -1L) {
            statusLogger.error("inMemoryLogsCountCapacity should be a non zero integer or -1");
            return false;
        }
        return true;
    }

    private File getQueueDirFile() {
        Object queueDirPath;
        if (this.queueDir != null) {
            queueDirPath = this.queueDir;
            File queueFile = new File((String)queueDirPath);
            if (queueFile.exists()) {
                if (!queueFile.canWrite()) {
                    statusLogger.error("We cant write to your queueDir location: " + queueFile.getAbsolutePath());
                    return null;
                }
            } else if (!queueFile.mkdirs()) {
                statusLogger.error("We cant create your queueDir location: " + queueFile.getAbsolutePath());
                return null;
            }
        } else {
            queueDirPath = System.getProperty("java.io.tmpdir") + File.separator + "logzio-log4j2-buffer";
        }
        return new File((String)queueDirPath, this.logzioType);
    }

    private boolean validateFSFullPercentThreshold() {
        if ((this.fileSystemFullPercentThreshold < 1 || this.fileSystemFullPercentThreshold > 100) && this.fileSystemFullPercentThreshold != -1) {
            statusLogger.error("fileSystemFullPercentThreshold should be a number between 1 and 100, or -1");
            return false;
        }
        return true;
    }

    public boolean stop(long timeout, TimeUnit timeUnit) {
        this.setStopping();
        boolean stopped = super.stop(timeout, timeUnit, false);
        this.safeStopLogzioSender();
        this.setStopped();
        return stopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safeStopLogzioSender() {
        if (this.logzioSender == null) {
            return;
        }
        boolean doStop = false;
        Map<LogzioAppender, LogzioSender> map = appenderToLogzioSender;
        synchronized (map) {
            appenderToLogzioSender.remove((Object)this);
            if (!appenderToLogzioSender.containsValue(this.logzioSender)) {
                doStop = true;
            }
        }
        if (doStop) {
            statusLogger.info("Stop {}", (Object)this.logzioSender);
            this.logzioSender.stop();
            this.safeExecutorTerminate();
        } else {
            statusLogger.info("Stop skipped for reused {}", (Object)this.logzioSender);
        }
    }

    public void append(LogEvent logEvent) {
        if (!logEvent.getLoggerName().contains("io.logz.sender")) {
            this.logzioSender.send(this.formatMessageAsJson(logEvent));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScheduledExecutorService safeExecutorCreate(Supplier<ScheduledExecutorService> doCreate) {
        ScheduledExecutorService tasksExecutor = doCreate.get();
        Map<String, ScheduledExecutorService> map = tasksExecutors;
        synchronized (map) {
            String key = this.getExecutorKey();
            this.safeExecutorTerminate(key);
            statusLogger.info("Created new tasksExecutor: {} for key.length: {}", (Object)tasksExecutor, (Object)key.length());
            tasksExecutors.put(key, tasksExecutor);
        }
        return tasksExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safeExecutorTerminate() {
        Map<String, ScheduledExecutorService> map = tasksExecutors;
        synchronized (map) {
            this.safeExecutorTerminate(this.getExecutorKey());
        }
    }

    private void safeExecutorTerminate(String key) {
        ScheduledExecutorService tasksExecutor = tasksExecutors.remove(key);
        if (tasksExecutor != null) {
            statusLogger.info("Terminating old tasksExecutor: {} for key.length: {}", (Object)tasksExecutor, (Object)key.length());
            try {
                tasksExecutor.shutdownNow();
                while (!tasksExecutor.isTerminated()) {
                    Thread.sleep(500L);
                }
            }
            catch (Exception e) {
                statusLogger.error("Failed to stop old executor", (Throwable)e);
            }
        } else {
            statusLogger.info("Skip terminating no tasksExecutor for key.length: {}", (Object)key.length());
        }
    }

    private String getExecutorKey() {
        return this.logzioToken + this.logzioType;
    }

    private JsonObject formatMessageAsJson(LogEvent loggingEvent) {
        JsonObject logMessage = new JsonObject();
        ReadOnlyStringMap mdcProperties = loggingEvent.getContextData();
        if (mdcProperties != null) {
            mdcProperties.toMap().forEach(logMessage::addProperty);
        }
        logMessage.addProperty(TIMESTAMP, new Date(loggingEvent.getTimeMillis()).toInstant().toString());
        logMessage.addProperty(LOGLEVEL, loggingEvent.getLevel().toString());
        Marker marker = loggingEvent.getMarker();
        if (marker != null) {
            logMessage.addProperty(MARKER, marker.toString());
        }
        logMessage.addProperty(MESSAGE, loggingEvent.getMessage().getFormattedMessage());
        logMessage.addProperty(LOGGER, loggingEvent.getLoggerName());
        logMessage.addProperty(THREAD, loggingEvent.getThreadName());
        Throwable throwable = loggingEvent.getThrown();
        if (throwable != null) {
            logMessage.addProperty(EXCEPTION, Throwables.getStackTraceAsString(throwable));
        }
        if (this.additionalFieldsMap != null) {
            this.additionalFieldsMap.forEach(logMessage::addProperty);
        }
        return logMessage;
    }

    private static String getValueFromSystemEnvironmentIfNeeded(String value) {
        if (value == null) {
            return null;
        }
        if (value.startsWith("$")) {
            return System.getenv(value.replace("$", ""));
        }
        return value;
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<LogzioAppender> {
        @PluginElement(value="Filter")
        private Filter filter;
        @PluginBuilderAttribute
        String name = "LogzioAppender";
        @PluginBuilderAttribute
        String logzioUrl;
        @PluginBuilderAttribute(sensitive=true)
        @Required
        String logzioToken;
        @PluginBuilderAttribute
        String logzioType = "java";
        @PluginBuilderAttribute
        int drainTimeoutSec = 5;
        @PluginBuilderAttribute
        int fileSystemFullPercentThreshold = 98;
        @Deprecated
        @PluginBuilderAttribute
        String bufferDir;
        @PluginBuilderAttribute
        String queueDir;
        @PluginBuilderAttribute
        int socketTimeoutMs = 10000;
        @PluginBuilderAttribute
        int connectTimeoutMs = 10000;
        @PluginBuilderAttribute
        boolean addHostname = false;
        @PluginBuilderAttribute
        String additionalFields;
        @PluginBuilderAttribute
        boolean debug = false;
        @PluginBuilderAttribute
        int gcPersistedQueueFilesIntervalSeconds = 30;
        @PluginBuilderAttribute
        private boolean ignoreExceptions = true;
        @PluginBuilderAttribute
        boolean compressRequests = false;
        @PluginBuilderAttribute
        boolean inMemoryQueue = false;
        @PluginBuilderAttribute
        long inMemoryQueueCapacityBytes = 0x6400000L;
        @PluginBuilderAttribute
        long inMemoryLogsCountCapacity = -1L;
        @PluginBuilderAttribute
        String exceedMaxSizeAction = "cut";
        @PluginBuilderAttribute
        boolean addOpentelemetryContext = true;

        public LogzioAppender build() {
            return new LogzioAppender(this.name, this.filter, this.ignoreExceptions, this.logzioUrl, this.logzioToken, this.logzioType, this.drainTimeoutSec, this.fileSystemFullPercentThreshold, this.queueDir == null ? this.bufferDir : this.queueDir, this.socketTimeoutMs, this.connectTimeoutMs, this.addHostname, this.additionalFields, this.debug, this.gcPersistedQueueFilesIntervalSeconds, this.compressRequests, this.inMemoryQueue, this.inMemoryQueueCapacityBytes, this.inMemoryLogsCountCapacity, this.exceedMaxSizeAction, this.addOpentelemetryContext);
        }

        public Builder setFilter(Filter filter) {
            this.filter = filter;
            return this;
        }

        public Builder setIgnoreExceptions(boolean ignoreExceptions) {
            this.ignoreExceptions = ignoreExceptions;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setLogzioUrl(String logzioUrl) {
            this.logzioUrl = logzioUrl;
            return this;
        }

        public Builder setLogzioToken(String logzioToken) {
            this.logzioToken = logzioToken;
            return this;
        }

        public Builder setLogzioType(String logzioType) {
            this.logzioType = logzioType;
            return this;
        }

        public Builder setDrainTimeoutSec(int drainTimeoutSec) {
            this.drainTimeoutSec = drainTimeoutSec;
            return this;
        }

        public Builder setFileSystemFullPercentThreshold(int fileSystemFullPercentThreshold) {
            this.fileSystemFullPercentThreshold = fileSystemFullPercentThreshold;
            return this;
        }

        @Deprecated
        public Builder setBufferDir(String queueDir) {
            this.queueDir = queueDir;
            return this;
        }

        public Builder setQueueDir(String queueDir) {
            this.queueDir = queueDir;
            return this;
        }

        public Builder setSocketTimeoutMs(int socketTimeoutMs) {
            this.socketTimeoutMs = socketTimeoutMs;
            return this;
        }

        public Builder setConnectTimeoutMs(int connectTimeoutMs) {
            this.connectTimeoutMs = connectTimeoutMs;
            return this;
        }

        public Builder setAddHostname(boolean addHostname) {
            this.addHostname = addHostname;
            return this;
        }

        public Builder setAdditionalFields(String additionalFields) {
            this.additionalFields = additionalFields;
            return this;
        }

        public Builder setDebug(boolean debug) {
            this.debug = debug;
            return this;
        }

        public Builder setGcPersistedQueueFilesIntervalSeconds(int gcPersistedQueueFilesIntervalSeconds) {
            this.gcPersistedQueueFilesIntervalSeconds = gcPersistedQueueFilesIntervalSeconds;
            return this;
        }

        public Builder setCompressRequests(boolean compressRequests) {
            this.compressRequests = compressRequests;
            return this;
        }

        public Builder setInMemoryQueue(boolean inMemoryQueue) {
            this.inMemoryQueue = inMemoryQueue;
            return this;
        }

        public Builder setInMemoryQueueCapacityBytes(long inMemoryQueueCapacityBytes) {
            this.inMemoryQueueCapacityBytes = inMemoryQueueCapacityBytes;
            return this;
        }

        public Builder setInMemoryLogsCountCapacity(long inMemoryLogsCountCapacity) {
            this.inMemoryLogsCountCapacity = inMemoryLogsCountCapacity;
            return this;
        }

        public Builder setExceedMaxSizeAction(String exceedMaxSizeAction) {
            this.exceedMaxSizeAction = exceedMaxSizeAction;
            return this;
        }

        public Builder setAddOpentelemetryContext(boolean addOpentelemetryContext) {
            this.addOpentelemetryContext = addOpentelemetryContext;
            return this;
        }
    }

    private class StatusReporter
    implements SenderStatusReporter {
        private StatusReporter() {
        }

        @Override
        public void error(String msg) {
            statusLogger.error(msg);
        }

        @Override
        public void error(String msg, Throwable e) {
            statusLogger.error(msg, e);
        }

        @Override
        public void warning(String msg) {
            statusLogger.warn(msg);
        }

        @Override
        public void warning(String msg, Throwable e) {
            statusLogger.warn(msg, e);
        }

        @Override
        public void info(String msg) {
            statusLogger.info(msg);
        }

        @Override
        public void info(String msg, Throwable e) {
            statusLogger.info(msg, e);
        }
    }
}

