/*
 * Decompiled with CFR 0.152.
 */
package io.logz.com.google.gson.internal.bind;

import io.logz.com.google.gson.Gson;
import io.logz.com.google.gson.TypeAdapter;
import io.logz.com.google.gson.TypeAdapterFactory;
import io.logz.com.google.gson.annotations.JsonAdapter;
import io.logz.com.google.gson.internal.ConstructorConstructor;
import io.logz.com.google.gson.reflect.TypeToken;

public final class JsonAdapterAnnotationTypeAdapterFactory
implements TypeAdapterFactory {
    private final ConstructorConstructor constructorConstructor;

    public JsonAdapterAnnotationTypeAdapterFactory(ConstructorConstructor constructorConstructor) {
        this.constructorConstructor = constructorConstructor;
    }

    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> targetType) {
        JsonAdapter annotation = targetType.getRawType().getAnnotation(JsonAdapter.class);
        if (annotation == null) {
            return null;
        }
        return JsonAdapterAnnotationTypeAdapterFactory.getTypeAdapter(this.constructorConstructor, gson, targetType, annotation);
    }

    static TypeAdapter<?> getTypeAdapter(ConstructorConstructor constructorConstructor, Gson gson, TypeToken<?> fieldType, JsonAdapter annotation) {
        TypeAdapter<Object> typeAdapter;
        Class<?> value = annotation.value();
        if (TypeAdapter.class.isAssignableFrom(value)) {
            Class<?> typeAdapterClass = value;
            typeAdapter = (TypeAdapter)constructorConstructor.get(TypeToken.get(typeAdapterClass)).construct();
        } else if (TypeAdapterFactory.class.isAssignableFrom(value)) {
            Class<?> typeAdapterFactory = value;
            typeAdapter = ((TypeAdapterFactory)constructorConstructor.get(TypeToken.get(typeAdapterFactory)).construct()).create(gson, fieldType);
        } else {
            throw new IllegalArgumentException("@JsonAdapter value must be TypeAdapter or TypeAdapterFactory reference.");
        }
        if (typeAdapter != null) {
            typeAdapter = typeAdapter.nullSafe();
        }
        return typeAdapter;
    }
}

