/*
 * Decompiled with CFR 0.152.
 */
package io.logz.logback;

import ch.qos.logback.classic.pattern.LineOfCallerConverter;
import ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import io.logz.logback.com.google.common.base.Splitter;
import io.logz.sender.LogzioSender;
import io.logz.sender.SenderStatusReporter;
import io.logz.sender.com.google.gson.JsonObject;
import io.logz.sender.exceptions.LogzioParameterErrorException;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LogzioLogbackAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private static final String TIMESTAMP = "@timestamp";
    private static final String LOGLEVEL = "loglevel";
    private static final String MARKER = "marker";
    private static final String MESSAGE = "message";
    private static final String LOGGER = "logger";
    private static final String LINE = "line";
    private static final String THREAD = "thread";
    private static final String EXCEPTION = "exception";
    private static final Set<String> reservedFields = new HashSet<String>(Arrays.asList("@timestamp", "loglevel", "marker", "message", "logger", "thread", "exception"));
    private LogzioSender logzioSender;
    private ThrowableProxyConverter throwableProxyConverter;
    private LineOfCallerConverter lineOfCallerConverter;
    private Map<String, String> additionalFieldsMap = new HashMap<String, String>();
    private String logzioToken;
    private String logzioType = "java";
    private int drainTimeoutSec = 5;
    private int fileSystemFullPercentThreshold = 98;
    private String bufferDir;
    private String logzioUrl;
    private int connectTimeout = 10000;
    private int socketTimeout = 10000;
    private boolean debug = false;
    private boolean addHostname = false;
    private boolean line = false;
    private int gcPersistedQueueFilesIntervalSeconds = 30;

    public void setToken(String logzioToken) {
        this.logzioToken = this.getValueFromSystemEnvironmentIfNeeded(logzioToken);
    }

    public void setLogzioType(String logzioType) {
        this.logzioType = logzioType;
    }

    public void setDrainTimeoutSec(int drainTimeoutSec) {
        if (drainTimeoutSec < 1) {
            this.drainTimeoutSec = 1;
            this.addInfo("Got unsupported drain timeout " + drainTimeoutSec + ". The timeout must be number greater then 1. I have set to 1 as fallback.");
        } else {
            this.drainTimeoutSec = drainTimeoutSec;
        }
    }

    public void setFileSystemFullPercentThreshold(int fileSystemFullPercentThreshold) {
        this.fileSystemFullPercentThreshold = fileSystemFullPercentThreshold;
    }

    public void setBufferDir(String bufferDir) {
        this.bufferDir = bufferDir;
    }

    public void setLogzioUrl(String logzioUrl) {
        this.logzioUrl = this.getValueFromSystemEnvironmentIfNeeded(logzioUrl);
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setAdditionalFields(String additionalFields) {
        if (additionalFields != null) {
            Splitter.on(';').omitEmptyStrings().withKeyValueSeparator('=').split(additionalFields).forEach((k, v) -> {
                if (reservedFields.contains(k)) {
                    this.addWarn("The field name '" + k + "' defined in additionalFields configuration can't be used since it's a reserved field name. This field will not be added to the outgoing log messages");
                } else {
                    String value = this.getValueFromSystemEnvironmentIfNeeded((String)v);
                    if (value != null) {
                        this.additionalFieldsMap.put((String)k, value);
                    }
                }
            });
            this.addInfo("The additional fields that would be added: " + this.additionalFieldsMap.toString());
        }
    }

    public boolean isAddHostname() {
        return this.addHostname;
    }

    public void setAddHostname(boolean addHostname) {
        this.addHostname = addHostname;
    }

    public boolean isLine() {
        return this.line;
    }

    public void setLine(boolean line) {
        this.line = line;
    }

    public void setGcPersistedQueueFilesIntervalSeconds(int gcPersistedQueueFilesIntervalSeconds) {
        this.gcPersistedQueueFilesIntervalSeconds = gcPersistedQueueFilesIntervalSeconds;
    }

    public void start() {
        if (this.logzioToken == null) {
            this.addError("Logz.io Token is missing! Bailing out..");
            return;
        }
        if ((this.fileSystemFullPercentThreshold < 1 || this.fileSystemFullPercentThreshold > 100) && this.fileSystemFullPercentThreshold != -1) {
            this.addError("fileSystemFullPercentThreshold should be a number between 1 and 100, or -1");
            return;
        }
        try {
            if (this.addHostname) {
                String hostname = InetAddress.getLocalHost().getHostName();
                this.additionalFieldsMap.put("hostname", hostname);
            }
        }
        catch (UnknownHostException e) {
            this.addWarn("The configuration addHostName was specified but the host could not be resolved, thus the field 'hostname' will not be added", e);
        }
        if (this.bufferDir != null) {
            this.bufferDir = this.bufferDir + File.separator + this.logzioType;
            File bufferFile = new File(this.bufferDir);
            if (bufferFile.exists()) {
                if (!bufferFile.canWrite()) {
                    this.addError("We cant write to your bufferDir location: " + bufferFile.getAbsolutePath());
                    return;
                }
            } else if (!bufferFile.mkdirs()) {
                this.addError("We cant create your bufferDir location: " + bufferFile.getAbsolutePath());
                return;
            }
        } else {
            this.bufferDir = System.getProperty("java.io.tmpdir") + File.separator + "logzio-logback-buffer" + File.separator + this.logzioType;
        }
        File bufferDirFile = new File(this.bufferDir, "logzio-logback-appender");
        try {
            StatusReporter reporter = new StatusReporter();
            this.logzioSender = LogzioSender.getOrCreateSenderByType(this.logzioToken, this.logzioType, this.drainTimeoutSec, this.fileSystemFullPercentThreshold, bufferDirFile, this.logzioUrl, this.socketTimeout, this.connectTimeout, this.debug, reporter, this.context.getScheduledExecutorService(), this.gcPersistedQueueFilesIntervalSeconds);
            this.logzioSender.start();
        }
        catch (LogzioParameterErrorException e) {
            this.addError("Some of the configuration parameters of logz.io is wrong: " + e.getMessage(), e);
            return;
        }
        this.throwableProxyConverter = new ThrowableProxyConverter();
        this.lineOfCallerConverter = new LineOfCallerConverter();
        this.throwableProxyConverter.setOptionList(Arrays.asList("full"));
        this.throwableProxyConverter.start();
        super.start();
    }

    public void stop() {
        if (this.logzioSender != null) {
            this.logzioSender.stop();
        }
        if (this.throwableProxyConverter != null) {
            this.throwableProxyConverter.stop();
        }
        super.stop();
    }

    private String getValueFromSystemEnvironmentIfNeeded(String value) {
        if (value != null && value.startsWith("$")) {
            return System.getenv(value.replace("$", ""));
        }
        return value;
    }

    private JsonObject formatMessageAsJson(ILoggingEvent loggingEvent) {
        JsonObject logMessage = new JsonObject();
        if (loggingEvent.getMDCPropertyMap() != null) {
            loggingEvent.getMDCPropertyMap().forEach(logMessage::addProperty);
        }
        logMessage.addProperty(TIMESTAMP, new Date(loggingEvent.getTimeStamp()).toInstant().toString());
        logMessage.addProperty(LOGLEVEL, loggingEvent.getLevel().levelStr);
        if (loggingEvent.getMarker() != null) {
            logMessage.addProperty(MARKER, loggingEvent.getMarker().toString());
        }
        logMessage.addProperty(MESSAGE, loggingEvent.getFormattedMessage());
        logMessage.addProperty(LOGGER, loggingEvent.getLoggerName());
        logMessage.addProperty(THREAD, loggingEvent.getThreadName());
        if (this.line) {
            logMessage.addProperty(LINE, this.lineOfCallerConverter.convert(loggingEvent));
        }
        if (loggingEvent.getThrowableProxy() != null) {
            logMessage.addProperty(EXCEPTION, this.throwableProxyConverter.convert(loggingEvent));
        }
        if (this.additionalFieldsMap != null) {
            this.additionalFieldsMap.forEach(logMessage::addProperty);
        }
        return logMessage;
    }

    protected void append(ILoggingEvent loggingEvent) {
        if (!loggingEvent.getLoggerName().contains("io.logz.sender")) {
            this.logzioSender.send(this.formatMessageAsJson(loggingEvent));
        }
    }

    private class StatusReporter
    implements SenderStatusReporter {
        private StatusReporter() {
        }

        @Override
        public void error(String msg) {
            LogzioLogbackAppender.this.addError(msg);
        }

        @Override
        public void error(String msg, Throwable e) {
            LogzioLogbackAppender.this.addError(msg, e);
        }

        @Override
        public void warning(String msg) {
            LogzioLogbackAppender.this.addWarn(msg);
        }

        @Override
        public void warning(String msg, Throwable e) {
            LogzioLogbackAppender.this.addWarn(msg, e);
        }

        @Override
        public void info(String msg) {
            LogzioLogbackAppender.this.addInfo(msg);
        }

        @Override
        public void info(String msg, Throwable e) {
            LogzioLogbackAppender.this.addInfo(msg, e);
        }
    }
}

