/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender;

import io.logz.sender.DiskQueue;
import io.logz.sender.FormattedLogMessage;
import io.logz.sender.HttpsRequestConfiguration;
import io.logz.sender.HttpsSyncSender;
import io.logz.sender.InMemoryQueue;
import io.logz.sender.LogsQueue;
import io.logz.sender.SenderStatusReporter;
import io.logz.sender.com.google.gson.JsonObject;
import io.logz.sender.exceptions.LogzioParameterErrorException;
import io.logz.sender.exceptions.LogzioServerErrorException;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

public class LogzioSender {
    private static final int MAX_SIZE_IN_BYTES = 0x300000;
    private static final Map<String, LogzioSender> logzioSenderInstances = new HashMap<String, LogzioSender>();
    private static final int FINAL_DRAIN_TIMEOUT_SEC = 20;
    private final LogsQueue logsQueue;
    private final int drainTimeout;
    private final boolean debug;
    private final SenderStatusReporter reporter;
    private ScheduledExecutorService tasksExecutor;
    private final AtomicBoolean drainRunning = new AtomicBoolean(false);
    private final HttpsSyncSender httpsSyncSender;

    private LogzioSender(HttpsRequestConfiguration httpsRequestConfiguration, int drainTimeout, boolean debug, SenderStatusReporter reporter, ScheduledExecutorService tasksExecutor, LogsQueue logsQueue) throws LogzioParameterErrorException {
        if (logsQueue == null || reporter == null || httpsRequestConfiguration == null) {
            throw new LogzioParameterErrorException("logsQueue=" + logsQueue + " reporter=" + reporter + " httpsRequestConfiguration=" + httpsRequestConfiguration, "For some reason could not initialize URL. Cant recover..");
        }
        this.logsQueue = logsQueue;
        this.drainTimeout = drainTimeout;
        this.debug = debug;
        this.reporter = reporter;
        this.httpsSyncSender = new HttpsSyncSender(httpsRequestConfiguration, reporter);
        this.tasksExecutor = tasksExecutor;
        this.debug("Created new LogzioSender class");
    }

    @Deprecated
    public static synchronized LogzioSender getOrCreateSenderByType(String logzioToken, String logzioType, int drainTimeout, int fsPercentThreshold, File queueDir, String logzioUrl, int socketTimeout, int connectTimeout, boolean debug, SenderStatusReporter reporter, ScheduledExecutorService tasksExecutor, int gcPersistedQueueFilesIntervalSeconds, boolean compressRequests) throws LogzioParameterErrorException {
        DiskQueue logsQueue = null;
        if (queueDir != null) {
            logsQueue = DiskQueue.builder(null, null).setDiskSpaceTasks(tasksExecutor).setGcPersistedQueueFilesIntervalSeconds(gcPersistedQueueFilesIntervalSeconds).setReporter(reporter).setFsPercentThreshold(fsPercentThreshold).setQueueDir(queueDir).build();
        }
        HttpsRequestConfiguration httpsRequestConfiguration = HttpsRequestConfiguration.builder().setCompressRequests(compressRequests).setConnectTimeout(connectTimeout).setSocketTimeout(socketTimeout).setLogzioListenerUrl(logzioUrl).setLogzioType(logzioType).setLogzioToken(logzioToken).build();
        return LogzioSender.getLogzioSender(httpsRequestConfiguration, drainTimeout, debug, reporter, tasksExecutor, logsQueue);
    }

    @Deprecated
    public static synchronized LogzioSender getOrCreateSenderByType(String logzioToken, String logzioType, int drainTimeout, int fsPercentThreshold, File queueDir, String logzioUrl, int socketTimeout, int connectTimeout, boolean debug, SenderStatusReporter reporter, ScheduledExecutorService tasksExecutor, int gcPersistedQueueFilesIntervalSeconds) throws LogzioParameterErrorException {
        return LogzioSender.getOrCreateSenderByType(logzioToken, logzioType, drainTimeout, fsPercentThreshold, queueDir, logzioUrl, socketTimeout, connectTimeout, debug, reporter, tasksExecutor, gcPersistedQueueFilesIntervalSeconds, false);
    }

    private static LogzioSender getLogzioSender(HttpsRequestConfiguration httpsRequestConfiguration, int drainTimeout, boolean debug, SenderStatusReporter reporter, ScheduledExecutorService tasksExecutor, LogsQueue logsQueue) throws LogzioParameterErrorException {
        LogzioSender logzioSenderInstance = logzioSenderInstances.get(httpsRequestConfiguration.getLogzioType());
        if (logzioSenderInstance == null) {
            if (logsQueue == null) {
                throw new LogzioParameterErrorException("logsQueue", "null");
            }
            LogzioSender logzioSender = new LogzioSender(httpsRequestConfiguration, drainTimeout, debug, reporter, tasksExecutor, logsQueue);
            logzioSenderInstances.put(httpsRequestConfiguration.getLogzioType(), logzioSender);
            return logzioSender;
        }
        reporter.info("Already found appender configured for type " + httpsRequestConfiguration.getLogzioType() + ", re-using the same one.");
        if (logzioSenderInstance.tasksExecutor.isTerminated()) {
            reporter.info("The old task executor is terminated! replacing it with a new one");
            logzioSenderInstance.tasksExecutor = tasksExecutor;
        }
        return logzioSenderInstance;
    }

    public void start() {
        this.tasksExecutor.scheduleWithFixedDelay(this::drainQueueAndSend, 0L, this.drainTimeout, TimeUnit.SECONDS);
    }

    public void stop() {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        this.debug("Got stop request, Submitting a final drain queue task to drain before shutdown. Will timeout in 20 seconds.");
        try {
            executorService.submit(this::drainQueue).get(20L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            this.debug("Waited 20 seconds, but could not finish draining. quitting.", e);
        }
        finally {
            executorService.shutdownNow();
        }
    }

    public void drainQueueAndSend() {
        try {
            if (this.drainRunning.get()) {
                this.debug("Drain is running so we won't run another one in parallel");
                return;
            }
            this.drainRunning.set(true);
            this.drainQueue();
        }
        catch (Exception e) {
            this.reporter.error("Uncaught error from Logz.io sender", e);
        }
        finally {
            this.drainRunning.set(false);
        }
    }

    public void send(JsonObject jsonMessage) {
        this.logsQueue.enqueue(jsonMessage.toString().getBytes(StandardCharsets.UTF_8));
    }

    public void send(byte[] jsonStringAsUTF8ByteArray) {
        this.logsQueue.enqueue(jsonStringAsUTF8ByteArray);
    }

    private List<FormattedLogMessage> dequeueUpToMaxBatchSize() {
        ArrayList<FormattedLogMessage> logsList = new ArrayList<FormattedLogMessage>();
        int totalSize = 0;
        while (!this.logsQueue.isEmpty()) {
            byte[] message = this.logsQueue.dequeue();
            if (message == null || message.length <= 0) continue;
            logsList.add(new FormattedLogMessage(message));
            if ((totalSize += message.length) < 0x300000) continue;
            break;
        }
        return logsList;
    }

    private void drainQueue() {
        this.debug("Attempting to drain queue");
        if (!this.logsQueue.isEmpty()) {
            while (!this.logsQueue.isEmpty()) {
                List<FormattedLogMessage> logsList = this.dequeueUpToMaxBatchSize();
                try {
                    this.httpsSyncSender.sendToLogzio(logsList);
                }
                catch (LogzioServerErrorException e) {
                    this.debug("Could not send log to logz.io: ", e);
                    this.debug("Will retry in the next interval");
                    logsList.forEach(logMessage -> this.logsQueue.enqueue(logMessage.getMessage()));
                    break;
                }
                if (!Thread.interrupted()) continue;
                this.debug("Stopping drainQueue to thread being interrupted");
                break;
            }
        }
    }

    private void debug(String message) {
        if (this.debug) {
            this.reporter.info("DEBUG: " + message);
        }
    }

    private void debug(String message, Throwable e) {
        if (this.debug) {
            this.reporter.info("DEBUG: " + message, e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean debug = false;
        private int drainTimeoutSec = 5;
        private SenderStatusReporter reporter;
        private ScheduledExecutorService tasksExecutor;
        private InMemoryQueue.Builder inMemoryQueueBuilder;
        private DiskQueue.Builder diskQueueBuilder;
        private HttpsRequestConfiguration httpsRequestConfiguration;

        public Builder setDrainTimeoutSec(int drainTimeoutSec) {
            this.drainTimeoutSec = drainTimeoutSec;
            return this;
        }

        public Builder setDebug(boolean debug) {
            this.debug = debug;
            return this;
        }

        public Builder setTasksExecutor(ScheduledExecutorService tasksExecutor) {
            this.tasksExecutor = tasksExecutor;
            return this;
        }

        public Builder setReporter(SenderStatusReporter reporter) {
            this.reporter = reporter;
            return this;
        }

        public Builder setHttpsRequestConfiguration(HttpsRequestConfiguration httpsRequestConfiguration) {
            this.httpsRequestConfiguration = httpsRequestConfiguration;
            return this;
        }

        public InMemoryQueue.Builder withInMemoryQueue() {
            if (this.inMemoryQueueBuilder == null) {
                this.inMemoryQueueBuilder = InMemoryQueue.builder(this);
            }
            return this.inMemoryQueueBuilder;
        }

        public DiskQueue.Builder withDiskQueue() {
            if (this.diskQueueBuilder == null) {
                this.diskQueueBuilder = DiskQueue.builder(this, this.tasksExecutor);
            }
            return this.diskQueueBuilder;
        }

        void setDiskQueueBuilder(DiskQueue.Builder diskQueueBuilder) {
            this.diskQueueBuilder = diskQueueBuilder;
        }

        void setInMemoryQueueBuilder(InMemoryQueue.Builder inMemoryQueueBuilder) {
            this.inMemoryQueueBuilder = inMemoryQueueBuilder;
        }

        public LogzioSender build() throws LogzioParameterErrorException {
            return LogzioSender.getLogzioSender(this.httpsRequestConfiguration, this.drainTimeoutSec, this.debug, this.reporter, this.tasksExecutor, this.getLogsQueue());
        }

        private LogsQueue getLogsQueue() throws LogzioParameterErrorException {
            if (this.diskQueueBuilder != null) {
                this.diskQueueBuilder.setDiskSpaceTasks(this.tasksExecutor);
                this.diskQueueBuilder.setReporter(this.reporter);
                return this.diskQueueBuilder.build();
            }
            this.inMemoryQueueBuilder.setReporter(this.reporter);
            return this.inMemoryQueueBuilder.build();
        }
    }
}

