/*
 * Decompiled with CFR 0.152.
 */
package io.logz.logback;

import io.logz.sender.HttpsRequestConfiguration;
import io.logz.sender.LogzioSender;
import io.logz.sender.SenderStatusReporter;
import io.logz.sender.ch.qos.logback.classic.pattern.LineOfCallerConverter;
import io.logz.sender.ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import io.logz.sender.ch.qos.logback.classic.spi.ILoggingEvent;
import io.logz.sender.ch.qos.logback.core.UnsynchronizedAppenderBase;
import io.logz.sender.ch.qos.logback.core.encoder.Encoder;
import io.logz.sender.com.google.gson.Gson;
import io.logz.sender.com.google.gson.JsonObject;
import io.logz.sender.exceptions.LogzioParameterErrorException;
import io.logz.sender.java.io.File;
import io.logz.sender.java.lang.CharSequence;
import io.logz.sender.java.lang.Deprecated;
import io.logz.sender.java.lang.Exception;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.lang.StringBuilder;
import io.logz.sender.java.lang.System;
import io.logz.sender.java.lang.Throwable;
import io.logz.sender.java.net.InetAddress;
import io.logz.sender.java.net.UnknownHostException;
import io.logz.sender.java.util.Arrays;
import io.logz.sender.java.util.Collection;
import io.logz.sender.java.util.Collections;
import io.logz.sender.java.util.HashMap;
import io.logz.sender.java.util.HashSet;
import io.logz.sender.java.util.Map;
import io.logz.sender.java.util.Set;

public class LogzioLogbackAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private static final Gson gson = new Gson();
    private static final String TIMESTAMP = "io.logz.sender.@timestamp";
    private static final String LOGLEVEL = "io.logz.sender.loglevel";
    private static final String MARKER = "io.logz.sender.marker";
    private static final String MESSAGE = "io.logz.sender.message";
    private static final String LOGGER = "io.logz.sender.logger";
    private static final String LINE = "io.logz.sender.line";
    private static final String THREAD = "io.logz.sender.thread";
    private static final String EXCEPTION = "io.logz.sender.exception";
    private static final String FORMAT_TEXT = "io.logz.sender.text";
    private static final String FORMAT_JSON = "io.logz.sender.json";
    private static final int DONT_LIMIT_CAPACITY = -1;
    private static final int LOWER_PERCENTAGE_FS_SPACE = 1;
    private static final int UPPER_PERCENTAGE_FS_SPACE = 100;
    private static final Set<String> reservedFields = new HashSet((Collection)Arrays.asList((io.logz.sender.java.lang.Object[])new String[]{"io.logz.sender.@timestamp", "io.logz.sender.loglevel", "io.logz.sender.marker", "io.logz.sender.message", "io.logz.sender.logger", "io.logz.sender.thread", "io.logz.sender.exception"}));
    private LogzioSender logzioSender;
    private ThrowableProxyConverter throwableProxyConverter;
    private LineOfCallerConverter lineOfCallerConverter;
    private Map<String, String> additionalFieldsMap = new HashMap();
    private String logzioToken;
    private String logzioType = "io.logz.sender.java";
    private int drainTimeoutSec = 5;
    private int fileSystemFullPercentThreshold = 98;
    private String queueDir;
    private String logzioUrl;
    private int connectTimeout = 10000;
    private int socketTimeout = 10000;
    private boolean debug = false;
    private boolean addHostname = false;
    private boolean line = false;
    private boolean compressRequests = false;
    private boolean inMemoryQueue = false;
    private long inMemoryQueueCapacityBytes = 0x6400000L;
    private long inMemoryLogsCountCapacity = -1L;
    private int gcPersistedQueueFilesIntervalSeconds = 30;
    private String format = "io.logz.sender.text";
    private Encoder<ILoggingEvent> encoder = null;

    public void setEncoder(Encoder<ILoggingEvent> encoder) {
        this.encoder = encoder;
    }

    public Encoder<ILoggingEvent> getEncoder() {
        return this.encoder;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setToken(String logzioToken) {
        this.logzioToken = this.getValueFromSystemEnvironmentIfNeeded(logzioToken);
    }

    public void setLogzioType(String logzioType) {
        this.logzioType = logzioType;
    }

    public void setDrainTimeoutSec(int drainTimeoutSec) {
        if (drainTimeoutSec < 1) {
            this.drainTimeoutSec = 1;
            this.addInfo(new StringBuilder().append((String)"io.logz.sender.Got unsupported drain timeout ").append(drainTimeoutSec).append((String)"io.logz.sender.. The timeout must be number greater then 1. I have set to 1 as fallback.").toString());
        } else {
            this.drainTimeoutSec = drainTimeoutSec;
        }
    }

    public void setFileSystemFullPercentThreshold(int fileSystemFullPercentThreshold) {
        this.fileSystemFullPercentThreshold = fileSystemFullPercentThreshold;
    }

    @Deprecated
    public void setBufferDir(String bufferDir) {
        this.queueDir = bufferDir;
    }

    public void setQueueDir(String queueDir) {
        this.queueDir = queueDir;
    }

    public void setLogzioUrl(String logzioUrl) {
        this.logzioUrl = this.getValueFromSystemEnvironmentIfNeeded(logzioUrl);
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setInMemoryQueue(boolean inMemoryQueue) {
        this.inMemoryQueue = inMemoryQueue;
    }

    public boolean isInMemoryQueue() {
        return this.inMemoryQueue;
    }

    public void setInMemoryQueueCapacityBytes(long inMemoryQueueCapacityBytes) {
        this.inMemoryQueueCapacityBytes = inMemoryQueueCapacityBytes;
    }

    public long getInMemoryQueueCapacityBytes() {
        return this.inMemoryQueueCapacityBytes;
    }

    public void setInMemoryLogsCountCapacity(long inMemoryLogsCountCapacity) {
        this.inMemoryLogsCountCapacity = inMemoryLogsCountCapacity;
    }

    @Deprecated
    public long getInMemoryLogsCountLimit() {
        return this.inMemoryLogsCountCapacity;
    }

    public long getInMemoryLogsCountCapacity() {
        return this.inMemoryLogsCountCapacity;
    }

    public boolean isCompressRequests() {
        return this.compressRequests;
    }

    public void setCompressRequests(boolean compressRequests) {
        this.compressRequests = compressRequests;
    }

    /*
     * Exception decompiling
     */
    public void setAdditionalFields(String additionalFields) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Dynamic invoke Expected io.logz.sender.java.lang.invoke.MethodType, got (Lio/logz/sender/java/lang/Object;Lio/logz/sender/java/lang/Object;)V
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isAddHostname() {
        return this.addHostname;
    }

    public void setAddHostname(boolean addHostname) {
        this.addHostname = addHostname;
    }

    public boolean isLine() {
        return this.line;
    }

    public void setLine(boolean line) {
        this.line = line;
    }

    public void setGcPersistedQueueFilesIntervalSeconds(int gcPersistedQueueFilesIntervalSeconds) {
        this.gcPersistedQueueFilesIntervalSeconds = gcPersistedQueueFilesIntervalSeconds;
    }

    public void start() {
        HttpsRequestConfiguration conf;
        this.setHostname();
        try {
            conf = this.getHttpsRequestConfiguration();
        }
        catch (LogzioParameterErrorException e) {
            this.addError(new StringBuilder().append((String)"io.logz.sender.Some of the configuration parameters of logz.io are wrong: ").append(e.getMessage()).toString(), (Throwable)e);
            return;
        }
        LogzioSender.Builder logzioSenderBuilder = this.getSenderBuilder(conf);
        if (this.inMemoryQueue) {
            if (!this.validateInMemoryThresholds()) {
                return;
            }
            logzioSenderBuilder.withInMemoryQueue().setCapacityInBytes(this.inMemoryQueueCapacityBytes).setLogsCountLimit(this.inMemoryLogsCountCapacity).endInMemoryQueue();
        } else {
            if (!this.validateFsPercentThreshold()) {
                return;
            }
            File queueDirFile = this.getQueueFile();
            if (queueDirFile == null) {
                return;
            }
            logzioSenderBuilder.withDiskQueue().setQueueDir(queueDirFile).setGcPersistedQueueFilesIntervalSeconds(this.gcPersistedQueueFilesIntervalSeconds).setFsPercentThreshold(this.fileSystemFullPercentThreshold).endDiskQueue();
        }
        try {
            this.logzioSender = logzioSenderBuilder.build();
        }
        catch (LogzioParameterErrorException e) {
            this.addError((String)"io.logz.sender.Could not create logzio sender", (Throwable)e);
            return;
        }
        this.logzioSender.start();
        this.throwableProxyConverter = new ThrowableProxyConverter();
        this.lineOfCallerConverter = new LineOfCallerConverter();
        this.throwableProxyConverter.setOptionList(Collections.singletonList((io.logz.sender.java.lang.Object)"io.logz.sender.full"));
        this.throwableProxyConverter.start();
        super.start();
    }

    private LogzioSender.Builder getSenderBuilder(HttpsRequestConfiguration conf) {
        return LogzioSender.builder().setDebug(this.debug).setDrainTimeoutSec(this.drainTimeoutSec).setHttpsRequestConfiguration(conf).setReporter(new StatusReporter()).setTasksExecutor(this.context.getScheduledExecutorService());
    }

    private File getQueueFile() {
        if (this.queueDir != null) {
            this.queueDir = new StringBuilder().append(this.queueDir).append(File.separator).append(this.logzioType).toString();
            File queueFile = new File(this.queueDir);
            if (queueFile.exists()) {
                if (!queueFile.canWrite()) {
                    this.addError(new StringBuilder().append((String)"io.logz.sender.We cant write to your queueDir location: ").append(queueFile.getAbsolutePath()).toString());
                    return null;
                }
            } else if (!queueFile.mkdirs()) {
                this.addError(new StringBuilder().append((String)"io.logz.sender.We cant create your queueDir location: ").append(queueFile.getAbsolutePath()).toString());
                return null;
            }
        } else {
            this.queueDir = new StringBuilder().append(System.getProperty((String)"io.logz.sender.java.io.tmpdir")).append(File.separator).append((String)"io.logz.sender.logzio-logback-queue").append(File.separator).append(this.logzioType).toString();
        }
        return new File(this.queueDir, (String)"io.logz.sender.logzio-logback-appender");
    }

    private boolean validateInMemoryThresholds() {
        if (this.inMemoryQueueCapacityBytes <= 0L && this.inMemoryQueueCapacityBytes != -1L) {
            this.addError((String)"io.logz.sender.inMemoryQueueCapacityBytes should be a non zero integer or -1");
            return false;
        }
        if (this.inMemoryLogsCountCapacity <= 0L && this.inMemoryLogsCountCapacity != -1L) {
            this.addError((String)"io.logz.sender.inMemoryLogsCountCapacity should be a non zero integer or -1");
            return false;
        }
        return true;
    }

    private boolean validateFsPercentThreshold() {
        if ((this.fileSystemFullPercentThreshold < 1 || this.fileSystemFullPercentThreshold > 100) && this.fileSystemFullPercentThreshold != -1) {
            this.addError((String)"io.logz.sender.fileSystemFullPercentThreshold should be a number between 1 and 100, or -1");
            return false;
        }
        return true;
    }

    private void setHostname() {
        try {
            if (this.addHostname) {
                String hostname = InetAddress.getLocalHost().getHostName();
                this.additionalFieldsMap.put((io.logz.sender.java.lang.Object)"io.logz.sender.hostname", (io.logz.sender.java.lang.Object)hostname);
            }
        }
        catch (UnknownHostException e) {
            this.addWarn((String)"io.logz.sender.The configuration addHostName was specified but the host could not be resolved, thus the field 'hostname' will not be added", (Throwable)e);
        }
    }

    private HttpsRequestConfiguration getHttpsRequestConfiguration() throws LogzioParameterErrorException {
        return HttpsRequestConfiguration.builder().setLogzioListenerUrl(this.logzioUrl).setSocketTimeout(this.socketTimeout).setLogzioType(this.logzioType).setLogzioToken(this.logzioToken).setConnectTimeout(this.connectTimeout).setCompressRequests(this.compressRequests).build();
    }

    public void drainQueueAndSend() {
        if (this.logzioSender != null) {
            this.logzioSender.drainQueueAndSend();
        }
    }

    public void stop() {
        if (this.logzioSender != null) {
            this.logzioSender.stop();
        }
        if (this.throwableProxyConverter != null) {
            this.throwableProxyConverter.stop();
        }
        super.stop();
    }

    private String getValueFromSystemEnvironmentIfNeeded(String value) {
        if (value != null && value.startsWith((String)"io.logz.sender.$")) {
            String variableName = value.replace((CharSequence)"io.logz.sender.$", (CharSequence)"io.logz.sender.");
            String envVariable = System.getenv((String)variableName);
            if (envVariable == null || envVariable.isEmpty()) {
                envVariable = System.getProperty((String)variableName);
            }
            return envVariable;
        }
        return value;
    }

    private void formatMessageAndSend(ILoggingEvent loggingEvent) {
        try {
            if (this.encoder == null) {
                this.logzioSender.send(this.formatMessageAsJsonInternal(loggingEvent));
            } else {
                this.logzioSender.send(this.encoder.encode((io.logz.sender.java.lang.Object)loggingEvent));
            }
        }
        catch (Exception e) {
            this.addWarn((String)"io.logz.sender.Failed to format and send message", (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    private JsonObject formatMessageAsJsonInternal(ILoggingEvent loggingEvent) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Dynamic invoke Expected io.logz.sender.java.lang.invoke.MethodType, got (Lio/logz/sender/java/lang/Object;Lio/logz/sender/java/lang/Object;)V
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void append(ILoggingEvent loggingEvent) {
        if (!loggingEvent.getLoggerName().contains((CharSequence)"io.logz.sender")) {
            this.formatMessageAndSend(loggingEvent);
        }
    }

    private /* synthetic */ void lambda$setAdditionalFields$0(String k, String v) {
        if (reservedFields.contains((io.logz.sender.java.lang.Object)k)) {
            this.addWarn(new StringBuilder().append((String)"io.logz.sender.The field name '").append(k).append((String)"io.logz.sender.' defined in additionalFields configuration can't be used since it's a reserved field name. This field will not be added to the outgoing log messages").toString());
        } else {
            String value = this.getValueFromSystemEnvironmentIfNeeded(v);
            if (value != null) {
                this.additionalFieldsMap.put((io.logz.sender.java.lang.Object)k, (io.logz.sender.java.lang.Object)value);
            }
        }
    }

    private class StatusReporter
    extends io.logz.sender.java.lang.Object
    implements SenderStatusReporter {
        private StatusReporter() {
        }

        @Override
        public void error(String msg) {
            LogzioLogbackAppender.this.addError(msg);
        }

        @Override
        public void error(String msg, Throwable e) {
            LogzioLogbackAppender.this.addError(msg, e);
        }

        @Override
        public void warning(String msg) {
            LogzioLogbackAppender.this.addWarn(msg);
        }

        @Override
        public void warning(String msg, Throwable e) {
            LogzioLogbackAppender.this.addWarn(msg, e);
        }

        @Override
        public void info(String msg) {
            LogzioLogbackAppender.this.addInfo(msg);
        }

        @Override
        public void info(String msg, Throwable e) {
            LogzioLogbackAppender.this.addInfo(msg, e);
        }
    }
}

