/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender;

import io.logz.sender.LogsQueue;
import io.logz.sender.LogzioSender;
import io.logz.sender.SenderStatusReporter;
import io.logz.sender.com.bluejeans.common.bigqueue.BigQueue;
import io.logz.sender.exceptions.LogzioParameterErrorException;
import io.logz.sender.java.io.File;
import io.logz.sender.java.lang.Integer;
import io.logz.sender.java.lang.Object;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.lang.Throwable;
import io.logz.sender.java.util.concurrent.ScheduledExecutorService;

public class DiskQueue
extends Object
implements LogsQueue {
    private final BigQueue logsQueue;
    private final File queueDirectory;
    private final boolean dontCheckEnoughDiskSpace;
    private final int fsPercentThreshold;
    private final SenderStatusReporter reporter;
    private volatile boolean isEnoughSpace;

    /*
     * Exception decompiling
     */
    private DiskQueue(File queueDir, boolean dontCheckEnoughDiskSpace, int fsPercentThreshold, int gcPersistedQueueFilesIntervalSeconds, SenderStatusReporter reporter, int checkDiskSpaceInterval, ScheduledExecutorService diskSpaceTasks) throws LogzioParameterErrorException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Dynamic invoke Expected io.logz.sender.java.lang.invoke.MethodType, got ()V
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void validateParameters() throws LogzioParameterErrorException {
        if (this.queueDirectory == null) {
            throw new LogzioParameterErrorException((String)"io.logz.sender.bufferDir", (String)"io.logz.sender.value is null.");
        }
        if (this.reporter == null) {
            throw new LogzioParameterErrorException((String)"io.logz.sender.reporter", (String)"io.logz.sender.value is null.");
        }
    }

    @Override
    public void enqueue(byte[] log) {
        if (this.isEnoughSpace) {
            this.logsQueue.enqueue(log);
        }
    }

    @Override
    public byte[] dequeue() {
        return this.logsQueue.dequeue();
    }

    @Override
    public boolean isEmpty() {
        return this.logsQueue.isEmpty();
    }

    private void validateEnoughSpace() {
        try {
            if (this.dontCheckEnoughDiskSpace) {
                return;
            }
            int actualUsedFsPercent = 100 - (int)((double)this.queueDirectory.getUsableSpace() / (double)this.queueDirectory.getTotalSpace() * 100.0);
            if (actualUsedFsPercent >= this.fsPercentThreshold) {
                if (this.isEnoughSpace) {
                    this.reporter.warning(String.format((String)"io.logz.sender.Logz.io: Dropping logs, as FS used space on %s is %d percent, and the drop threshold is %d percent", (Object[])new Object[]{this.queueDirectory.getAbsolutePath(), Integer.valueOf((int)actualUsedFsPercent), Integer.valueOf((int)this.fsPercentThreshold)}));
                }
                this.isEnoughSpace = false;
            } else {
                this.isEnoughSpace = true;
            }
        }
        catch (Throwable e) {
            this.reporter.error((String)"io.logz.sender.Uncaught error from validateEnoughSpace()", e);
        }
    }

    private void gcBigQueue() {
        try {
            this.logsQueue.gc();
        }
        catch (Throwable e) {
            this.reporter.error((String)"io.logz.sender.Uncaught error from BigQueue.gc()", e);
        }
    }

    public void close() {
        this.gcBigQueue();
    }

    public static Builder builder(LogzioSender.Builder context, ScheduledExecutorService diskSpaceTasks) {
        return new Builder(context, diskSpaceTasks);
    }

    public static class Builder
    extends Object {
        private boolean dontCheckEnoughDiskSpace = false;
        private int fsPercentThreshold = 98;
        private int gcPersistedQueueFilesIntervalSeconds = 30;
        private int checkDiskSpaceInterval = 1000;
        private File queueDir;
        private SenderStatusReporter reporter;
        private ScheduledExecutorService diskSpaceTasks;
        private LogzioSender.Builder context;

        Builder(LogzioSender.Builder context, ScheduledExecutorService diskSpaceTasks) {
            this.context = context;
            this.diskSpaceTasks = diskSpaceTasks;
        }

        public Builder setFsPercentThreshold(int fsPercentThreshold) {
            this.fsPercentThreshold = fsPercentThreshold;
            if (fsPercentThreshold == -1) {
                this.dontCheckEnoughDiskSpace = true;
            }
            return this;
        }

        public Builder setGcPersistedQueueFilesIntervalSeconds(int gcPersistedQueueFilesIntervalSeconds) {
            this.gcPersistedQueueFilesIntervalSeconds = gcPersistedQueueFilesIntervalSeconds;
            return this;
        }

        public Builder setCheckDiskSpaceInterval(int checkDiskSpaceInterval) {
            this.checkDiskSpaceInterval = checkDiskSpaceInterval;
            return this;
        }

        public Builder setQueueDir(File queueDir) {
            this.queueDir = queueDir;
            return this;
        }

        Builder setReporter(SenderStatusReporter reporter) {
            this.reporter = reporter;
            return this;
        }

        Builder setDiskSpaceTasks(ScheduledExecutorService diskSpaceTasks) {
            this.diskSpaceTasks = diskSpaceTasks;
            return this;
        }

        public LogzioSender.Builder endDiskQueue() {
            this.context.setDiskQueueBuilder(this);
            return this.context;
        }

        DiskQueue build() throws LogzioParameterErrorException {
            return new DiskQueue(this.queueDir, this.dontCheckEnoughDiskSpace, this.fsPercentThreshold, this.gcPersistedQueueFilesIntervalSeconds, this.reporter, this.checkDiskSpaceInterval, this.diskSpaceTasks);
        }
    }
}

