/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender;

import io.logz.sender.FormattedLogMessage;
import io.logz.sender.HttpsRequestConfiguration;
import io.logz.sender.SenderStatusReporter;
import io.logz.sender.exceptions.LogzioServerErrorException;
import io.logz.sender.java.io.IOException;
import io.logz.sender.java.lang.InterruptedException;
import io.logz.sender.java.lang.Object;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.lang.StringBuilder;
import io.logz.sender.java.lang.Thread;
import io.logz.sender.java.lang.Throwable;
import io.logz.sender.java.net.HttpURLConnection;
import io.logz.sender.java.nio.charset.StandardCharsets;
import io.logz.sender.java.util.List;

public class HttpsSyncSender
extends Object {
    private final HttpsRequestConfiguration configuration;
    private final SenderStatusReporter reporter;
    private static final byte[] NEW_LINE_AS_UTF8_BYTE_ARRAY = "io.logz.sender.\n".getBytes(StandardCharsets.UTF_8);
    private static final int NEW_LINE_AS_UTF8_BYTE_ARRAY_SIZE = NEW_LINE_AS_UTF8_BYTE_ARRAY.length;

    HttpsSyncSender(HttpsRequestConfiguration configuration, SenderStatusReporter reporter) {
        this.configuration = configuration;
        this.reporter = reporter;
    }

    public HttpsRequestConfiguration getConfiguration() {
        return this.configuration;
    }

    /*
     * Exception decompiling
     */
    private byte[] toNewLineSeparatedByteArray(List<FormattedLogMessage> messages) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundSuperForBase(org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance)" because "bindingSuperContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.getIterableIterType(LoopLivenessClash.java:35)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.detect(LoopLivenessClash.java:66)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.detect(LoopLivenessClash.java:25)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:827)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int sizeInBytes(List<FormattedLogMessage> logMessages) {
        int totalSize = 0;
        for (FormattedLogMessage currLog : logMessages) {
            totalSize += currLog.getSize();
        }
        return totalSize;
    }

    void sendToLogzio(List<FormattedLogMessage> messages) throws LogzioServerErrorException {
        try {
            byte[] payload = this.toNewLineSeparatedByteArray(messages);
            int currentRetrySleep = this.configuration.getInitialWaitBeforeRetryMS();
            for (int currTry = 1; currTry <= this.configuration.getMaxRetriesAttempts(); ++currTry) {
                boolean retry = true;
                int responseCode = 0;
                java.lang.String responseMessage = "io.logz.sender.";
                IOException savedException = null;
                try {
                    HttpURLConnection conn = this.sendRequest(payload);
                    responseCode = conn.getResponseCode();
                    responseMessage = conn.getResponseMessage();
                    retry = this.handleResponse(payload, responseCode, (String)responseMessage, conn);
                }
                catch (IOException e) {
                    savedException = e;
                    this.reporter.error(new StringBuilder().append((String)"io.logz.sender.Got IO exception - ").append(e.getMessage()).toString());
                }
                if (retry) {
                    currentRetrySleep = this.handleRetry(currentRetrySleep, currTry, responseCode, (String)responseMessage, savedException);
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException e) {
            this.reporter.info((String)"io.logz.sender.Got interrupted exception");
            Thread.currentThread().interrupt();
        }
    }

    private int handleRetry(int currentRetrySleep, int currTry, int responseCode, String responseMessage, IOException savedException) throws LogzioServerErrorException, InterruptedException {
        if (currTry == this.configuration.getMaxRetriesAttempts()) {
            if (savedException != null) {
                this.reporter.error((String)"io.logz.sender.Got IO exception on the last bulk try to logz.io", (Throwable)((java.lang.Object)savedException));
            }
            throw new LogzioServerErrorException(new StringBuilder().append((String)"io.logz.sender.Got HTTP ").append(responseCode).append((String)"io.logz.sender. code from logz.io, with message: ").append(responseMessage).toString());
        }
        this.reporter.warning(new StringBuilder().append((String)"io.logz.sender.Could not send log to logz.io, retry (").append(currTry).append((String)"io/logz/sender//").append(this.configuration.getMaxRetriesAttempts()).append((String)"io.logz.sender.)").toString());
        this.reporter.warning(new StringBuilder().append((String)"io.logz.sender.Sleeping for ").append(currentRetrySleep).append((String)"io.logz.sender. ms and will try again.").toString());
        Thread.sleep((long)currentRetrySleep);
        return currentRetrySleep * 2;
    }

    private boolean handleResponse(byte[] payload, int responseCode, String responseMessage, HttpURLConnection conn) {
        boolean retry = false;
        if (responseCode == 400) {
            String errorMessage = this.readErrorStream(conn);
            if (errorMessage != null) {
                this.reporter.warning(errorMessage);
            }
        } else if (responseCode == 401) {
            this.reporter.error(new StringBuilder().append((String)"io.logz.sender.Logz.io: Got forbidden! Your token is not right. Unfortunately, dropping logs. Message: ").append(responseMessage).toString());
        } else if (responseCode == 200) {
            this.reporter.info(new StringBuilder().append((String)"io.logz.sender.Successfully sent bulk to logz.io, size: ").append(payload.length).toString());
        } else {
            retry = true;
        }
        return retry;
    }

    /*
     * Exception decompiling
     */
    private String readErrorStream(HttpURLConnection conn) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Dynamic invoke Expected io.logz.sender.java.lang.invoke.MethodType, got (Lio/logz/sender/java/lang/Object;)V
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private HttpURLConnection sendRequest(byte[] payload) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)this.configuration.getLogzioListenerUrl().openConnection();
        conn.setRequestMethod(this.configuration.getRequestMethod());
        conn.setRequestProperty((String)"io.logz.sender.Content-length", String.valueOf((int)payload.length));
        conn.setRequestProperty((String)"io.logz.sender.Content-Type", (String)"io/logz/sender/text/plain");
        if (this.configuration.isCompressRequests()) {
            conn.setRequestProperty((String)"io.logz.sender.Content-Encoding", (String)"io.logz.sender.gzip");
        }
        conn.setReadTimeout(this.configuration.getSocketTimeout());
        conn.setConnectTimeout(this.configuration.getConnectTimeout());
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.getOutputStream().write(payload);
        return conn;
    }

    private static /* synthetic */ void lambda$readErrorStream$0(StringBuilder problemDescription, String line) {
        problemDescription.append((String)"io.logz.sender.\n").append(line);
    }
}

