/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender;

import io.logz.sender.LogsQueue;
import io.logz.sender.LogzioSender;
import io.logz.sender.SenderStatusReporter;
import io.logz.sender.java.io.IOException;
import io.logz.sender.java.lang.Long;
import io.logz.sender.java.lang.Object;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.util.concurrent.ConcurrentLinkedQueue;
import io.logz.sender.java.util.concurrent.locks.ReentrantLock;

public class InMemoryQueue
extends Object
implements LogsQueue {
    private static final int MB_IN_BYTES = 0x100000;
    public static int DONT_LIMIT_QUEUE_SPACE = -1;
    private final ConcurrentLinkedQueue<byte[]> logsBuffer = new ConcurrentLinkedQueue();
    private final boolean dontCheckEnoughMemorySpace;
    private final boolean dontCheckLogsCountLimit;
    private final long capacityInBytes;
    private final long logsCountLimit;
    private final SenderStatusReporter reporter;
    private volatile long size;
    private volatile long logsCounter;
    private final ReentrantLock queueLock;

    private InMemoryQueue(long capacityInBytes, long logsCountLimit, SenderStatusReporter reporter) {
        this.dontCheckEnoughMemorySpace = capacityInBytes == (long)DONT_LIMIT_QUEUE_SPACE;
        this.dontCheckLogsCountLimit = logsCountLimit == (long)DONT_LIMIT_QUEUE_SPACE;
        this.capacityInBytes = capacityInBytes;
        this.logsCountLimit = logsCountLimit;
        this.reporter = reporter;
        this.size = 0L;
        this.logsCounter = 0L;
        this.queueLock = new ReentrantLock();
    }

    @Override
    public void enqueue(byte[] log) {
        this.queueLock.lock();
        try {
            if (this.isEnoughSpace()) {
                this.logsBuffer.add((Object)log);
                this.size += (long)log.length;
                ++this.logsCounter;
                return;
            }
        }
        finally {
            this.queueLock.unlock();
        }
    }

    @Override
    public byte[] dequeue() {
        byte[] log;
        this.queueLock.lock();
        try {
            log = (byte[])this.logsBuffer.remove();
            this.size -= (long)log.length;
            --this.logsCounter;
        }
        finally {
            this.queueLock.unlock();
        }
        return log;
    }

    @Override
    public boolean isEmpty() {
        return this.logsBuffer.isEmpty();
    }

    private boolean isEnoughSpace() {
        if (!this.dontCheckEnoughMemorySpace && this.size >= this.capacityInBytes) {
            this.reporter.warning(String.format((String)"io.logz.sender.Logz.io: Dropping logs - we crossed the memory threshold of %d MB", (Object[])new Object[]{Long.valueOf((long)(this.capacityInBytes / 0x100000L))}));
            return false;
        }
        if (!this.dontCheckLogsCountLimit && this.logsCounter >= this.logsCountLimit) {
            this.reporter.warning(String.format((String)"io.logz.sender.Logz.io: Dropping logs - we crossed the logs counter threshold of %d logs", (Object[])new Object[]{Long.valueOf((long)this.logsCountLimit)}));
            return false;
        }
        return true;
    }

    public void close() throws IOException {
    }

    public static Builder builder(LogzioSender.Builder context) {
        return new Builder(context);
    }

    public static class Builder
    extends Object {
        private long inMemoryQueueCapacityInBytes = 0x6400000L;
        private long logsCountLimit = DONT_LIMIT_QUEUE_SPACE;
        private SenderStatusReporter reporter;
        private LogzioSender.Builder context;

        Builder(LogzioSender.Builder context) {
            this.context = context;
        }

        public Builder setCapacityInBytes(long inMemoryQueueCapacityInBytes) {
            this.inMemoryQueueCapacityInBytes = inMemoryQueueCapacityInBytes;
            return this;
        }

        public Builder setLogsCountLimit(long logsCountLimit) {
            this.logsCountLimit = logsCountLimit;
            return this;
        }

        Builder setReporter(SenderStatusReporter reporter) {
            this.reporter = reporter;
            return this;
        }

        public LogzioSender.Builder endInMemoryQueue() {
            this.context.setInMemoryQueueBuilder(this);
            return this.context;
        }

        public InMemoryQueue build() {
            return new InMemoryQueue(this.inMemoryQueueCapacityInBytes, this.logsCountLimit, this.reporter);
        }
    }
}

