/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.bluejeans.common.bigqueue;

import io.logz.sender.com.bluejeans.common.bigqueue.BigQueueException;
import io.logz.sender.com.bluejeans.common.bigqueue.CloseCommand;
import io.logz.sender.com.bluejeans.common.bigqueue.FileUtil;
import io.logz.sender.com.bluejeans.common.bigqueue.LRUCache;
import io.logz.sender.com.bluejeans.common.bigqueue.MappedPage;
import io.logz.sender.java.io.Closeable;
import io.logz.sender.java.io.File;
import io.logz.sender.java.io.IOException;
import io.logz.sender.java.io.RandomAccessFile;
import io.logz.sender.java.lang.Exception;
import io.logz.sender.java.lang.IllegalStateException;
import io.logz.sender.java.lang.InterruptedException;
import io.logz.sender.java.lang.Long;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.lang.StringBuilder;
import io.logz.sender.java.lang.Thread;
import io.logz.sender.java.nio.MappedByteBuffer;
import io.logz.sender.java.nio.channels.FileChannel;
import io.logz.sender.java.util.Collection;
import io.logz.sender.java.util.HashMap;
import io.logz.sender.java.util.HashSet;
import io.logz.sender.java.util.Iterator;
import io.logz.sender.java.util.Map;
import io.logz.sender.java.util.Set;
import io.logz.sender.java.util.TreeSet;
import io.logz.sender.org.slf4j.Logger;
import io.logz.sender.org.slf4j.LoggerFactory;

class MappedPageFactory
extends io.logz.sender.java.lang.Object {
    private static final Logger logger = LoggerFactory.getLogger(MappedPageFactory.class);
    private final int pageSize;
    private String pageDir;
    private final File pageDirFile;
    private final String pageFile;
    private final long ttl;
    private final io.logz.sender.java.lang.Object mapLock = new io.logz.sender.java.lang.Object();
    private final Map<Long, io.logz.sender.java.lang.Object> pageCreationLockMap = new HashMap();
    public static final String PAGE_FILE_NAME = "io.logz.sender.page";
    public static final String PAGE_FILE_SUFFIX = "io.logz.sender..dat";
    private final LRUCache<Long, MappedPage> cache;

    public MappedPageFactory(int pageSize, String pageDir, long cacheTTL) {
        this.pageSize = pageSize;
        this.pageDir = pageDir;
        this.ttl = cacheTTL;
        this.pageDirFile = new File(this.pageDir);
        if (!this.pageDirFile.exists()) {
            this.pageDirFile.mkdirs();
        }
        if (!this.pageDir.endsWith(File.separator)) {
            this.pageDir = new StringBuilder().append(this.pageDir).append(File.separator).toString();
        }
        this.pageFile = new StringBuilder().append(this.pageDir).append((String)"io.logz.sender.page").append((String)"io.logz.sender.-").toString();
        this.cache = new LRUCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MappedPage acquirePage(long index) {
        MappedPage mpi;
        block27: {
            block28: {
                mpi = this.cache.get(Long.valueOf((long)index));
                if (mpi != null) break block28;
                try {
                    io.logz.sender.java.lang.Object lock = null;
                    io.logz.sender.java.lang.Object object = this.mapLock;
                    synchronized (object) {
                        if (!this.pageCreationLockMap.containsKey((io.logz.sender.java.lang.Object)Long.valueOf((long)index))) {
                            this.pageCreationLockMap.put((io.logz.sender.java.lang.Object)Long.valueOf((long)index), new io.logz.sender.java.lang.Object());
                        }
                        lock = this.pageCreationLockMap.get((io.logz.sender.java.lang.Object)Long.valueOf((long)index));
                    }
                    object = lock;
                    synchronized (object) {
                        mpi = this.cache.get(Long.valueOf((long)index));
                        if (mpi == null) {
                            RandomAccessFile raf;
                            block26: {
                                raf = null;
                                FileChannel channel = null;
                                try {
                                    String fileName = this.getFileNameByIndex(index);
                                    raf = new RandomAccessFile(fileName, (String)"io.logz.sender.rw");
                                    channel = raf.getChannel();
                                    MappedByteBuffer mbb = channel.map(FileChannel.MapMode.READ_WRITE, 0L, (long)this.pageSize);
                                    mpi = new MappedPage(mbb, fileName, index);
                                    this.cache.put(Long.valueOf((long)index), mpi, this.ttl);
                                    if (logger.isDebugEnabled()) {
                                        logger.debug(new StringBuilder().append((String)"io.logz.sender.Mapped page for ").append(fileName).append((String)"io.logz.sender. was just created and cached.").toString());
                                    }
                                    if (channel == null) break block26;
                                }
                                catch (IOException e) {
                                    try {
                                        throw new BigQueueException((Exception)((Object)e));
                                    }
                                    catch (Throwable throwable) {
                                        if (channel != null) {
                                            CloseCommand.close(channel);
                                        }
                                        if (raf != null) {
                                            CloseCommand.close(raf);
                                        }
                                        throw throwable;
                                    }
                                }
                                CloseCommand.close((Closeable)channel);
                            }
                            if (raf != null) {
                                CloseCommand.close((Closeable)raf);
                            }
                            break block27;
                        }
                        break block27;
                    }
                }
                finally {
                    io.logz.sender.java.lang.Object object = this.mapLock;
                    synchronized (object) {
                        this.pageCreationLockMap.remove((io.logz.sender.java.lang.Object)Long.valueOf((long)index));
                    }
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug(new StringBuilder().append((String)"io.logz.sender.Hit mapped page ").append(mpi.getPageFile()).append((String)"io.logz.sender. in cache.").toString());
            }
        }
        return mpi;
    }

    private String getFileNameByIndex(long index) {
        return new StringBuilder().append(this.pageFile).append(index).append((String)"io.logz.sender..dat").toString();
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public String getPageDir() {
        return this.pageDir;
    }

    public void releasePage(long index) {
        this.cache.release(Long.valueOf((long)index));
    }

    public void releaseCachedPages() {
        this.cache.removeAll();
    }

    public void deleteAllPages() {
        this.cache.removeAll();
        Set<Long> indexSet = this.getExistingBackFileIndexSet();
        this.deletePages(indexSet);
        if (logger.isDebugEnabled()) {
            logger.debug(new StringBuilder().append((String)"io.logz.sender.All page files in dir ").append(this.pageDir).append((String)"io.logz.sender. have been deleted.").toString());
        }
    }

    public void deletePages(Set<Long> indexes) {
        if (indexes == null) {
            return;
        }
        Iterator iterator = indexes.iterator();
        while (iterator.hasNext()) {
            long index = ((Long)iterator.next()).longValue();
            this.deletePage(index);
        }
    }

    public void deletePage(long index) {
        this.cache.remove(Long.valueOf((long)index));
        String fileName = this.getFileNameByIndex(index);
        int maxRound = 10;
        boolean deleted = false;
        for (int count = 0; count < 10; ++count) {
            try {
                FileUtil.deleteFile(new File(fileName));
                deleted = true;
                break;
            }
            catch (IllegalStateException ex) {
                try {
                    Thread.sleep((long)200L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!logger.isDebugEnabled()) continue;
                logger.warn(new StringBuilder().append((String)"io.logz.sender.fail to delete file ").append(fileName).append((String)"io.logz.sender., tried round = ").append(count).toString());
                continue;
            }
        }
        if (deleted) {
            logger.info(new StringBuilder().append((String)"io.logz.sender.Page file ").append(fileName).append((String)"io.logz.sender. was just deleted.").toString());
        } else {
            logger.warn(new StringBuilder().append((String)"io.logz.sender.fail to delete file ").append(fileName).append((String)"io.logz.sender. after max ").append(10).append((String)"io.logz.sender. rounds of try, you may delete it manually.").toString());
        }
    }

    public Set<Long> getPageIndexSetBefore(long timestamp) {
        HashSet beforeIndexSet = new HashSet();
        File[] pageFiles = this.pageDirFile.listFiles();
        if (pageFiles != null && pageFiles.length > 0) {
            for (File pageFile : pageFiles) {
                String fileName;
                if (pageFile.lastModified() >= timestamp || !(fileName = pageFile.getName()).endsWith((String)"io.logz.sender..dat")) continue;
                long index = this.getIndexByFileName(fileName);
                beforeIndexSet.add((io.logz.sender.java.lang.Object)Long.valueOf((long)index));
            }
        }
        return beforeIndexSet;
    }

    private long getIndexByFileName(String fileName) {
        int beginIndex = fileName.lastIndexOf(45);
        int endIndex = fileName.lastIndexOf((String)"io.logz.sender..dat");
        String sIndex = fileName.substring(++beginIndex, endIndex);
        long index = Long.parseLong((String)sIndex);
        return index;
    }

    public void deletePagesBefore(long timestamp) {
        Set<Long> indexSet = this.getPageIndexSetBefore(timestamp);
        this.deletePages(indexSet);
        if (logger.isDebugEnabled()) {
            logger.debug(new StringBuilder().append((String)"io.logz.sender.All page files in dir [").append(this.pageDir).append((String)"io.logz.sender.], before [").append(timestamp).append((String)"io.logz.sender.] have been deleted.").toString());
        }
    }

    public void deletePagesBeforePageIndex(long pageIndex) {
        Set<Long> indexSet = this.getExistingBackFileIndexSet();
        for (Long index : indexSet) {
            if (index.longValue() >= pageIndex) continue;
            this.deletePage(index.longValue());
        }
    }

    public Set<Long> getExistingBackFileIndexSet() {
        HashSet indexSet = new HashSet();
        File[] pageFiles = this.pageDirFile.listFiles();
        if (pageFiles != null && pageFiles.length > 0) {
            for (File pageFile : pageFiles) {
                String fileName = pageFile.getName();
                if (!fileName.endsWith((String)"io.logz.sender..dat")) continue;
                long index = this.getIndexByFileName(fileName);
                indexSet.add((io.logz.sender.java.lang.Object)Long.valueOf((long)index));
            }
        }
        return indexSet;
    }

    public int getCacheSize() {
        return this.cache.size();
    }

    int getLockMapSize() {
        return this.pageCreationLockMap.size();
    }

    public long getPageFileLastModifiedTime(long index) {
        String pageFileName = this.getFileNameByIndex(index);
        File pageFile = new File(pageFileName);
        if (!pageFile.exists()) {
            return -1L;
        }
        return pageFile.lastModified();
    }

    public long getFirstPageIndexBefore(long timestamp) {
        Set<Long> beforeIndexSet = this.getPageIndexSetBefore(timestamp);
        if (beforeIndexSet.size() == 0) {
            return -1L;
        }
        TreeSet sortedIndexSet = new TreeSet(beforeIndexSet);
        Long largestIndex = (Long)sortedIndexSet.last();
        if (largestIndex.longValue() != java.lang.Long.MAX_VALUE) {
            return largestIndex.longValue();
        }
        Long next = Long.valueOf((long)0L);
        while (sortedIndexSet.contains((io.logz.sender.java.lang.Object)next)) {
            Long longVal = next;
            Long longVal2 = next = Long.valueOf((long)(next.longValue() + 1L));
        }
        if (next.longValue() == 0L) {
            return java.lang.Long.MAX_VALUE;
        }
        next = Long.valueOf((long)(next.longValue() - 1L));
        return next.longValue();
    }

    public void flush() {
        Collection<MappedPage> cachedPages = this.cache.getValues();
        for (MappedPage mappedPage : cachedPages) {
            mappedPage.flush();
        }
    }

    public Set<String> getBackPageFileSet() {
        HashSet fileSet = new HashSet();
        File[] pageFiles = this.pageDirFile.listFiles();
        if (pageFiles != null && pageFiles.length > 0) {
            for (File pageFile : pageFiles) {
                String fileName = pageFile.getName();
                if (!fileName.endsWith((String)"io.logz.sender..dat")) continue;
                fileSet.add((io.logz.sender.java.lang.Object)fileName);
            }
        }
        return fileSet;
    }

    public long getBackPageFileSize() {
        long totalSize = 0L;
        File[] pageFiles = this.pageDirFile.listFiles();
        if (pageFiles != null && pageFiles.length > 0) {
            for (File pageFile : pageFiles) {
                String fileName = pageFile.getName();
                if (!fileName.endsWith((String)"io.logz.sender..dat")) continue;
                totalSize += pageFile.length();
            }
        }
        return totalSize;
    }
}

