/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.base;

import io.logz.sender.com.google.common.annotations.GwtCompatible;
import io.logz.sender.com.google.common.annotations.GwtIncompatible;
import io.logz.sender.com.google.common.base.Converter;
import io.logz.sender.com.google.common.base.Optional;
import io.logz.sender.com.google.common.base.Platform;
import io.logz.sender.com.google.common.base.Preconditions;
import io.logz.sender.java.io.Serializable;
import io.logz.sender.java.lang.AssertionError;
import io.logz.sender.java.lang.Class;
import io.logz.sender.java.lang.Enum;
import io.logz.sender.java.lang.NoSuchFieldException;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.lang.StringBuilder;
import io.logz.sender.java.lang.ref.WeakReference;
import io.logz.sender.java.lang.reflect.Field;
import io.logz.sender.java.util.EnumSet;
import io.logz.sender.java.util.HashMap;
import io.logz.sender.java.util.Map;
import io.logz.sender.java.util.WeakHashMap;
import io.logz.sender.org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible(emulated=true)
public final class Enums
extends io.logz.sender.java.lang.Object {
    @GwtIncompatible
    private static final Map<Class<? extends Enum<?>>, Map<String, WeakReference<? extends Enum<?>>>> enumConstantCache = new WeakHashMap();

    private Enums() {
    }

    @GwtIncompatible
    public static Field getField(Enum<?> enumValue) {
        Class clazz = enumValue.getDeclaringClass();
        try {
            return clazz.getDeclaredField(enumValue.name());
        }
        catch (NoSuchFieldException impossible) {
            throw new AssertionError((io.logz.sender.java.lang.Object)impossible);
        }
    }

    public static <T extends Enum<T>> Optional<T> getIfPresent(Class<T> enumClass, String value) {
        Preconditions.checkNotNull(enumClass);
        Preconditions.checkNotNull(value);
        return Platform.getEnumIfPresent(enumClass, value);
    }

    @GwtIncompatible
    private static <T extends Enum<T>> Map<String, WeakReference<? extends Enum<?>>> populateCache(Class<T> enumClass) {
        HashMap result = new HashMap();
        for (Enum enumInstance : EnumSet.allOf(enumClass)) {
            result.put((io.logz.sender.java.lang.Object)enumInstance.name(), (io.logz.sender.java.lang.Object)new WeakReference((io.logz.sender.java.lang.Object)enumInstance));
        }
        enumConstantCache.put(enumClass, (io.logz.sender.java.lang.Object)result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GwtIncompatible
    static <T extends Enum<T>> Map<String, WeakReference<? extends Enum<?>>> getEnumConstants(Class<T> enumClass) {
        Map<Class<? extends Enum<?>>, Map<String, WeakReference<? extends Enum<?>>>> map = enumConstantCache;
        synchronized (map) {
            Map<String, WeakReference<Enum<?>>> constants = (Map<String, WeakReference<Enum<?>>>)enumConstantCache.get(enumClass);
            if (constants == null) {
                constants = Enums.populateCache(enumClass);
            }
            return constants;
        }
    }

    public static <T extends Enum<T>> Converter<String, T> stringConverter(Class<T> enumClass) {
        return new StringConverter<T>(enumClass);
    }

    private static final class StringConverter<T extends Enum<T>>
    extends Converter<String, T>
    implements Serializable {
        private final Class<T> enumClass;
        private static final long serialVersionUID = 0L;

        StringConverter(Class<T> enumClass) {
            this.enumClass = Preconditions.checkNotNull(enumClass);
        }

        @Override
        protected T doForward(String value) {
            return (T)Enum.valueOf(this.enumClass, (String)value);
        }

        @Override
        protected String doBackward(T enumValue) {
            return enumValue.name();
        }

        @Override
        public boolean equals(@NullableDecl io.logz.sender.java.lang.Object object) {
            if (object instanceof StringConverter) {
                StringConverter that = (StringConverter)object;
                return this.enumClass.equals(that.enumClass);
            }
            return false;
        }

        public int hashCode() {
            return this.enumClass.hashCode();
        }

        public String toString() {
            return new StringBuilder().append((String)"io.logz.sender.Enums.stringConverter(").append(this.enumClass.getName()).append((String)"io.logz.sender..class)").toString();
        }
    }
}

