/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.base;

import io.logz.sender.com.google.common.annotations.Beta;
import io.logz.sender.com.google.common.annotations.GwtCompatible;
import io.logz.sender.com.google.common.base.Absent;
import io.logz.sender.com.google.common.base.AbstractIterator;
import io.logz.sender.com.google.common.base.Function;
import io.logz.sender.com.google.common.base.Preconditions;
import io.logz.sender.com.google.common.base.Present;
import io.logz.sender.com.google.common.base.Supplier;
import io.logz.sender.java.io.Serializable;
import io.logz.sender.java.lang.Iterable;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.util.Iterator;
import io.logz.sender.java.util.Set;
import io.logz.sender.org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible(serializable=true)
public abstract class Optional<T extends io.logz.sender.java.lang.Object>
extends io.logz.sender.java.lang.Object
implements Serializable {
    private static final long serialVersionUID = 0L;

    public static <T extends io.logz.sender.java.lang.Object> Optional<T> absent() {
        return Absent.withType();
    }

    public static <T extends io.logz.sender.java.lang.Object> Optional<T> of(T reference) {
        return new Present<T>(Preconditions.checkNotNull(reference));
    }

    public static <T extends io.logz.sender.java.lang.Object> Optional<T> fromNullable(@NullableDecl T nullableReference) {
        return nullableReference == null ? Optional.absent() : new Present<T>(nullableReference);
    }

    @NullableDecl
    public static <T extends io.logz.sender.java.lang.Object> Optional<T> fromJavaUtil(@NullableDecl io.logz.sender.java.util.Optional<T> javaUtilOptional) {
        return javaUtilOptional == null ? null : Optional.fromNullable(javaUtilOptional.orElse(null));
    }

    @NullableDecl
    public static <T extends io.logz.sender.java.lang.Object> io.logz.sender.java.util.Optional<T> toJavaUtil(@NullableDecl Optional<T> googleOptional) {
        return googleOptional == null ? null : googleOptional.toJavaUtil();
    }

    public io.logz.sender.java.util.Optional<T> toJavaUtil() {
        return io.logz.sender.java.util.Optional.ofNullable(this.orNull());
    }

    Optional() {
    }

    public abstract boolean isPresent();

    public abstract T get();

    public abstract T or(T var1);

    public abstract Optional<T> or(Optional<? extends T> var1);

    @Beta
    public abstract T or(Supplier<? extends T> var1);

    @NullableDecl
    public abstract T orNull();

    public abstract Set<T> asSet();

    public abstract <V extends io.logz.sender.java.lang.Object> Optional<V> transform(Function<? super T, V> var1);

    public abstract boolean equals(@NullableDecl io.logz.sender.java.lang.Object var1);

    public abstract int hashCode();

    public abstract String toString();

    @Beta
    public static <T extends io.logz.sender.java.lang.Object> Iterable<T> presentInstances(final Iterable<? extends Optional<? extends T>> optionals) {
        Preconditions.checkNotNull(optionals);
        return new Iterable<T>(){

            public Iterator<T> iterator() {
                return new AbstractIterator<T>(){
                    private final Iterator<? extends Optional<? extends T>> iterator;
                    {
                        this.iterator = Preconditions.checkNotNull(optionals.iterator());
                    }

                    @Override
                    protected T computeNext() {
                        while (this.iterator.hasNext()) {
                            Optional optional = (Optional)this.iterator.next();
                            if (!optional.isPresent()) continue;
                            return optional.get();
                        }
                        return this.endOfData();
                    }
                };
            }
        };
    }
}

