/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.base;

import io.logz.sender.com.google.common.annotations.GwtCompatible;
import io.logz.sender.com.google.common.base.CharMatcher;
import io.logz.sender.com.google.common.base.CommonPattern;
import io.logz.sender.com.google.common.base.Enums;
import io.logz.sender.com.google.common.base.JdkPattern;
import io.logz.sender.com.google.common.base.Optional;
import io.logz.sender.com.google.common.base.PatternCompiler;
import io.logz.sender.com.google.common.base.Preconditions;
import io.logz.sender.java.lang.Class;
import io.logz.sender.java.lang.Double;
import io.logz.sender.java.lang.Enum;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.lang.System;
import io.logz.sender.java.lang.Throwable;
import io.logz.sender.java.lang.ref.WeakReference;
import io.logz.sender.java.util.Iterator;
import io.logz.sender.java.util.Locale;
import io.logz.sender.java.util.ServiceConfigurationError;
import io.logz.sender.java.util.ServiceLoader;
import io.logz.sender.java.util.logging.Level;
import io.logz.sender.java.util.logging.Logger;
import io.logz.sender.java.util.regex.Pattern;
import io.logz.sender.org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible(emulated=true)
final class Platform
extends io.logz.sender.java.lang.Object {
    private static final Logger logger = Logger.getLogger((String)Platform.class.getName());
    private static final PatternCompiler patternCompiler = Platform.loadPatternCompiler();

    private Platform() {
    }

    static long systemNanoTime() {
        return System.nanoTime();
    }

    static CharMatcher precomputeCharMatcher(CharMatcher matcher) {
        return matcher.precomputedInternal();
    }

    static <T extends Enum<T>> Optional<T> getEnumIfPresent(Class<T> enumClass, String value) {
        WeakReference ref = (WeakReference)Enums.getEnumConstants(enumClass).get((io.logz.sender.java.lang.Object)value);
        return ref == null ? Optional.absent() : Optional.of(enumClass.cast(ref.get()));
    }

    static String formatCompact4Digits(double value) {
        return String.format((Locale)Locale.ROOT, (String)"io.logz.sender.%.4g", (io.logz.sender.java.lang.Object[])new io.logz.sender.java.lang.Object[]{Double.valueOf((double)value)});
    }

    static boolean stringIsNullOrEmpty(@NullableDecl String string) {
        return string == null || string.isEmpty();
    }

    static String nullToEmpty(@NullableDecl String string) {
        return string == null ? "io.logz.sender." : string;
    }

    static String emptyToNull(@NullableDecl String string) {
        return Platform.stringIsNullOrEmpty(string) ? null : string;
    }

    static CommonPattern compilePattern(String pattern) {
        Preconditions.checkNotNull(pattern);
        return patternCompiler.compile(pattern);
    }

    static boolean usingJdkPatternCompiler() {
        return patternCompiler instanceof JdkPatternCompiler;
    }

    private static PatternCompiler loadPatternCompiler() {
        ServiceLoader loader = ServiceLoader.load(PatternCompiler.class);
        try {
            Iterator it = loader.iterator();
            while (it.hasNext()) {
                try {
                    return (PatternCompiler)it.next();
                }
                catch (ServiceConfigurationError e) {
                    Platform.logPatternCompilerError(e);
                }
            }
        }
        catch (ServiceConfigurationError e) {
            Platform.logPatternCompilerError(e);
        }
        return new JdkPatternCompiler();
    }

    private static void logPatternCompilerError(ServiceConfigurationError e) {
        logger.log(Level.WARNING, (String)"io.logz.sender.Error loading regex compiler, falling back to next option", (Throwable)((Object)e));
    }

    private static final class JdkPatternCompiler
    extends io.logz.sender.java.lang.Object
    implements PatternCompiler {
        private JdkPatternCompiler() {
        }

        @Override
        public CommonPattern compile(String pattern) {
            return new JdkPattern(Pattern.compile((String)pattern));
        }
    }
}

