/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.collect;

import io.logz.sender.com.google.common.annotations.GwtCompatible;
import io.logz.sender.com.google.common.base.Preconditions;
import io.logz.sender.com.google.common.collect.Iterators;
import io.logz.sender.com.google.common.collect.Maps;
import io.logz.sender.com.google.common.collect.Multimap;
import io.logz.sender.com.google.common.collect.Multimaps;
import io.logz.sender.com.google.common.collect.Multiset;
import io.logz.sender.com.google.common.collect.SetMultimap;
import io.logz.sender.com.google.common.collect.Sets;
import io.logz.sender.com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.logz.sender.java.lang.Iterable;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.util.AbstractCollection;
import io.logz.sender.java.util.Collection;
import io.logz.sender.java.util.Iterator;
import io.logz.sender.java.util.Map;
import io.logz.sender.java.util.Set;
import io.logz.sender.java.util.Spliterator;
import io.logz.sender.java.util.Spliterators;
import io.logz.sender.org.checkerframework.checker.nullness.compatqual.MonotonicNonNullDecl;
import io.logz.sender.org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible
abstract class AbstractMultimap<K extends io.logz.sender.java.lang.Object, V extends io.logz.sender.java.lang.Object>
extends io.logz.sender.java.lang.Object
implements Multimap<K, V> {
    @MonotonicNonNullDecl
    private transient Collection<Map.Entry<K, V>> entries;
    @MonotonicNonNullDecl
    private transient Set<K> keySet;
    @MonotonicNonNullDecl
    private transient Multiset<K> keys;
    @MonotonicNonNullDecl
    private transient Collection<V> values;
    @MonotonicNonNullDecl
    private transient Map<K, Collection<V>> asMap;

    AbstractMultimap() {
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsValue(@NullableDecl io.logz.sender.java.lang.Object value) {
        for (Collection collection : this.asMap().values()) {
            if (!collection.contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsEntry(@NullableDecl io.logz.sender.java.lang.Object key, @NullableDecl io.logz.sender.java.lang.Object value) {
        Collection collection = (Collection)this.asMap().get(key);
        return collection != null && collection.contains(value);
    }

    @Override
    @CanIgnoreReturnValue
    public boolean remove(@NullableDecl io.logz.sender.java.lang.Object key, @NullableDecl io.logz.sender.java.lang.Object value) {
        Collection collection = (Collection)this.asMap().get(key);
        return collection != null && collection.remove(value);
    }

    @Override
    @CanIgnoreReturnValue
    public boolean put(@NullableDecl K key, @NullableDecl V value) {
        return this.get((io.logz.sender.java.lang.Object)key).add(value);
    }

    @Override
    @CanIgnoreReturnValue
    public boolean putAll(@NullableDecl K key, Iterable<? extends V> values) {
        Preconditions.checkNotNull(values);
        if (values instanceof Collection) {
            Collection valueCollection = (Collection)values;
            return !valueCollection.isEmpty() && this.get((io.logz.sender.java.lang.Object)key).addAll(valueCollection);
        }
        Iterator valueItr = values.iterator();
        return valueItr.hasNext() && Iterators.addAll(this.get((io.logz.sender.java.lang.Object)key), valueItr);
    }

    @Override
    @CanIgnoreReturnValue
    public boolean putAll(Multimap<? extends K, ? extends V> multimap) {
        boolean changed = false;
        for (Map.Entry entry : multimap.entries()) {
            changed |= this.put(entry.getKey(), entry.getValue());
        }
        return changed;
    }

    @Override
    @CanIgnoreReturnValue
    public Collection<V> replaceValues(@NullableDecl K key, Iterable<? extends V> values) {
        Preconditions.checkNotNull(values);
        Collection result = this.removeAll((io.logz.sender.java.lang.Object)key);
        this.putAll(key, values);
        return result;
    }

    @Override
    public Collection<Map.Entry<K, V>> entries() {
        Collection<Map.Entry<K, V>> result = this.entries;
        return result == null ? (this.entries = this.createEntries()) : result;
    }

    abstract Collection<Map.Entry<K, V>> createEntries();

    abstract Iterator<Map.Entry<K, V>> entryIterator();

    Spliterator<Map.Entry<K, V>> entrySpliterator() {
        return Spliterators.spliterator(this.entryIterator(), (long)this.size(), (int)(this instanceof SetMultimap ? 1 : 0));
    }

    @Override
    public Set<K> keySet() {
        Set<K> result = this.keySet;
        return result == null ? (this.keySet = this.createKeySet()) : result;
    }

    abstract Set<K> createKeySet();

    @Override
    public Multiset<K> keys() {
        Multiset<K> result = this.keys;
        return result == null ? (this.keys = this.createKeys()) : result;
    }

    abstract Multiset<K> createKeys();

    @Override
    public Collection<V> values() {
        Collection<V> result = this.values;
        return result == null ? (this.values = this.createValues()) : result;
    }

    abstract Collection<V> createValues();

    Iterator<V> valueIterator() {
        return Maps.valueIterator(this.entries().iterator());
    }

    Spliterator<V> valueSpliterator() {
        return Spliterators.spliterator(this.valueIterator(), (long)this.size(), (int)0);
    }

    @Override
    public Map<K, Collection<V>> asMap() {
        Map<K, Collection<V>> result = this.asMap;
        return result == null ? (this.asMap = this.createAsMap()) : result;
    }

    abstract Map<K, Collection<V>> createAsMap();

    @Override
    public boolean equals(@NullableDecl io.logz.sender.java.lang.Object object) {
        return Multimaps.equalsImpl(this, object);
    }

    @Override
    public int hashCode() {
        return this.asMap().hashCode();
    }

    public String toString() {
        return this.asMap().toString();
    }

    class Values
    extends AbstractCollection<V> {
        Values() {
        }

        public Iterator<V> iterator() {
            return AbstractMultimap.this.valueIterator();
        }

        public Spliterator<V> spliterator() {
            return AbstractMultimap.this.valueSpliterator();
        }

        public int size() {
            return AbstractMultimap.this.size();
        }

        public boolean contains(@NullableDecl io.logz.sender.java.lang.Object o) {
            return AbstractMultimap.this.containsValue(o);
        }

        public void clear() {
            AbstractMultimap.this.clear();
        }
    }

    class EntrySet
    extends Entries
    implements Set<Map.Entry<K, V>> {
        EntrySet() {
        }

        public int hashCode() {
            return Sets.hashCodeImpl(this);
        }

        public boolean equals(@NullableDecl io.logz.sender.java.lang.Object obj) {
            return Sets.equalsImpl(this, obj);
        }
    }

    class Entries
    extends Multimaps.Entries<K, V> {
        Entries() {
        }

        @Override
        Multimap<K, V> multimap() {
            return AbstractMultimap.this;
        }

        public Iterator<Map.Entry<K, V>> iterator() {
            return AbstractMultimap.this.entryIterator();
        }

        public Spliterator<Map.Entry<K, V>> spliterator() {
            return AbstractMultimap.this.entrySpliterator();
        }
    }
}

