/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.collect;

import io.logz.sender.com.google.common.annotations.GwtCompatible;
import io.logz.sender.com.google.common.collect.AbstractMapBasedMultimap;
import io.logz.sender.com.google.common.collect.AbstractSetMultimap;
import io.logz.sender.com.google.common.collect.Sets;
import io.logz.sender.com.google.common.collect.SortedSetMultimap;
import io.logz.sender.com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.logz.sender.java.lang.Iterable;
import io.logz.sender.java.util.Collection;
import io.logz.sender.java.util.Collections;
import io.logz.sender.java.util.Map;
import io.logz.sender.java.util.NavigableSet;
import io.logz.sender.java.util.SortedSet;
import io.logz.sender.org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible
abstract class AbstractSortedSetMultimap<K extends io.logz.sender.java.lang.Object, V extends io.logz.sender.java.lang.Object>
extends AbstractSetMultimap<K, V>
implements SortedSetMultimap<K, V> {
    private static final long serialVersionUID = 430848587173315748L;

    protected AbstractSortedSetMultimap(Map<K, Collection<V>> map) {
        super(map);
    }

    @Override
    abstract SortedSet<V> createCollection();

    @Override
    SortedSet<V> createUnmodifiableEmptyCollection() {
        return this.unmodifiableCollectionSubclass((Collection<E>)((Collection)this.createCollection()));
    }

    @Override
    <E extends io.logz.sender.java.lang.Object> SortedSet<E> unmodifiableCollectionSubclass(Collection<E> collection) {
        if (collection instanceof NavigableSet) {
            return Sets.unmodifiableNavigableSet((NavigableSet)collection);
        }
        return Collections.unmodifiableSortedSet((SortedSet)((SortedSet)collection));
    }

    @Override
    Collection<V> wrapCollection(K key, Collection<V> collection) {
        if (collection instanceof NavigableSet) {
            return new AbstractMapBasedMultimap.WrappedNavigableSet((AbstractMapBasedMultimap)this, key, (NavigableSet)collection, null);
        }
        return new AbstractMapBasedMultimap.WrappedSortedSet((AbstractMapBasedMultimap)this, key, (SortedSet)collection, null);
    }

    @Override
    public SortedSet<V> get(@NullableDecl K key) {
        return (SortedSet)super.get(key);
    }

    @Override
    @CanIgnoreReturnValue
    public SortedSet<V> removeAll(@NullableDecl io.logz.sender.java.lang.Object key) {
        return (SortedSet)super.removeAll(key);
    }

    @Override
    @CanIgnoreReturnValue
    public SortedSet<V> replaceValues(@NullableDecl K key, Iterable<? extends V> values) {
        return (SortedSet)super.replaceValues(key, values);
    }

    @Override
    public Map<K, Collection<V>> asMap() {
        return super.asMap();
    }

    @Override
    public Collection<V> values() {
        return super.values();
    }
}

