/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.collect;

import io.logz.sender.com.google.common.annotations.GwtCompatible;
import io.logz.sender.com.google.common.base.Preconditions;
import io.logz.sender.com.google.common.collect.AbstractIterator;
import io.logz.sender.java.util.ArrayDeque;
import io.logz.sender.java.util.Collections;
import io.logz.sender.java.util.Queue;

@GwtCompatible
class ConsumingQueueIterator<T extends io.logz.sender.java.lang.Object>
extends AbstractIterator<T> {
    private final Queue<T> queue;

    ConsumingQueueIterator(T ... elements) {
        this.queue = new ArrayDeque(elements.length);
        Collections.addAll(this.queue, elements);
    }

    ConsumingQueueIterator(Queue<T> queue) {
        this.queue = Preconditions.checkNotNull(queue);
    }

    @Override
    public T computeNext() {
        return (T)(this.queue.isEmpty() ? this.endOfData() : this.queue.remove());
    }
}

