/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.collect;

import io.logz.sender.com.google.common.annotations.GwtCompatible;
import io.logz.sender.com.google.common.annotations.GwtIncompatible;
import io.logz.sender.com.google.common.collect.BoundType;
import io.logz.sender.com.google.common.collect.ContiguousSet;
import io.logz.sender.com.google.common.collect.DiscreteDomain;
import io.logz.sender.com.google.common.collect.ImmutableList;
import io.logz.sender.com.google.common.collect.ImmutableSortedSet;
import io.logz.sender.com.google.common.collect.Iterators;
import io.logz.sender.com.google.common.collect.Ordering;
import io.logz.sender.com.google.common.collect.Range;
import io.logz.sender.com.google.common.collect.UnmodifiableIterator;
import io.logz.sender.java.io.Serializable;
import io.logz.sender.java.lang.Comparable;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.util.NoSuchElementException;
import io.logz.sender.java.util.Set;
import io.logz.sender.org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible(emulated=true)
final class EmptyContiguousSet<C extends Comparable>
extends ContiguousSet<C> {
    EmptyContiguousSet(DiscreteDomain<C> domain) {
        super(domain);
    }

    @Override
    public C first() {
        throw new NoSuchElementException();
    }

    @Override
    public C last() {
        throw new NoSuchElementException();
    }

    public int size() {
        return 0;
    }

    @Override
    public ContiguousSet<C> intersection(ContiguousSet<C> other) {
        return this;
    }

    @Override
    public Range<C> range() {
        throw new NoSuchElementException();
    }

    @Override
    public Range<C> range(BoundType lowerBoundType, BoundType upperBoundType) {
        throw new NoSuchElementException();
    }

    @Override
    ContiguousSet<C> headSetImpl(C toElement, boolean inclusive) {
        return this;
    }

    @Override
    ContiguousSet<C> subSetImpl(C fromElement, boolean fromInclusive, C toElement, boolean toInclusive) {
        return this;
    }

    @Override
    ContiguousSet<C> tailSetImpl(C fromElement, boolean fromInclusive) {
        return this;
    }

    @Override
    public boolean contains(io.logz.sender.java.lang.Object object) {
        return false;
    }

    @Override
    @GwtIncompatible
    int indexOf(io.logz.sender.java.lang.Object target) {
        return -1;
    }

    @Override
    public UnmodifiableIterator<C> iterator() {
        return Iterators.emptyIterator();
    }

    @Override
    @GwtIncompatible
    public UnmodifiableIterator<C> descendingIterator() {
        return Iterators.emptyIterator();
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    public boolean isEmpty() {
        return true;
    }

    @Override
    public ImmutableList<C> asList() {
        return ImmutableList.of();
    }

    @Override
    public String toString() {
        return "io.logz.sender.[]";
    }

    @Override
    public boolean equals(@NullableDecl io.logz.sender.java.lang.Object object) {
        if (object instanceof Set) {
            Set that = (Set)object;
            return that.isEmpty();
        }
        return false;
    }

    @Override
    @GwtIncompatible
    boolean isHashCodeFast() {
        return true;
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    @GwtIncompatible
    io.logz.sender.java.lang.Object writeReplace() {
        return new SerializedForm(this.domain);
    }

    @Override
    @GwtIncompatible
    ImmutableSortedSet<C> createDescendingSet() {
        return ImmutableSortedSet.emptySet(Ordering.natural().reverse());
    }

    @GwtIncompatible
    private static final class SerializedForm<C extends Comparable>
    extends io.logz.sender.java.lang.Object
    implements Serializable {
        private final DiscreteDomain<C> domain;
        private static final long serialVersionUID = 0L;

        private SerializedForm(DiscreteDomain<C> domain) {
            this.domain = domain;
        }

        private io.logz.sender.java.lang.Object readResolve() {
            return new EmptyContiguousSet<C>(this.domain);
        }
    }
}

