/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.collect;

import io.logz.sender.com.google.common.annotations.GwtCompatible;
import io.logz.sender.com.google.common.collect.ImmutableMap;
import io.logz.sender.com.google.common.collect.Maps;
import io.logz.sender.com.google.common.collect.Ordering;
import io.logz.sender.java.io.Serializable;
import io.logz.sender.java.lang.Integer;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.lang.StringBuilder;
import io.logz.sender.java.util.List;
import io.logz.sender.org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible(serializable=true)
final class ExplicitOrdering<T extends io.logz.sender.java.lang.Object>
extends Ordering<T>
implements Serializable {
    final ImmutableMap<T, Integer> rankMap;
    private static final long serialVersionUID = 0L;

    ExplicitOrdering(List<T> valuesInOrder) {
        this(Maps.indexMap(valuesInOrder));
    }

    ExplicitOrdering(ImmutableMap<T, Integer> rankMap) {
        this.rankMap = rankMap;
    }

    @Override
    public int compare(T left, T right) {
        return this.rank(left) - this.rank(right);
    }

    private int rank(T value) {
        Integer rank = this.rankMap.get((io.logz.sender.java.lang.Object)value);
        if (rank == null) {
            throw new Ordering.IncomparableValueException((io.logz.sender.java.lang.Object)value);
        }
        return rank.intValue();
    }

    public boolean equals(@NullableDecl io.logz.sender.java.lang.Object object) {
        if (object instanceof ExplicitOrdering) {
            ExplicitOrdering that = (ExplicitOrdering)object;
            return this.rankMap.equals(that.rankMap);
        }
        return false;
    }

    public int hashCode() {
        return this.rankMap.hashCode();
    }

    public String toString() {
        return new StringBuilder().append((String)"io.logz.sender.Ordering.explicit(").append((io.logz.sender.java.lang.Object)this.rankMap.keySet()).append((String)"io.logz.sender.)").toString();
    }
}

