/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.collect;

import io.logz.sender.com.google.common.annotations.GwtCompatible;
import io.logz.sender.com.google.common.base.Objects;
import io.logz.sender.com.google.common.collect.Collections2;
import io.logz.sender.com.google.common.collect.ForwardingObject;
import io.logz.sender.com.google.common.collect.Iterators;
import io.logz.sender.com.google.common.collect.ObjectArrays;
import io.logz.sender.com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.util.Collection;
import io.logz.sender.java.util.Iterator;
import io.logz.sender.org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible
public abstract class ForwardingCollection<E extends io.logz.sender.java.lang.Object>
extends ForwardingObject
implements Collection<E> {
    protected ForwardingCollection() {
    }

    protected abstract Collection<E> delegate();

    public Iterator<E> iterator() {
        return this.delegate().iterator();
    }

    public int size() {
        return this.delegate().size();
    }

    @CanIgnoreReturnValue
    public boolean removeAll(Collection<?> collection) {
        return this.delegate().removeAll(collection);
    }

    public boolean isEmpty() {
        return this.delegate().isEmpty();
    }

    public boolean contains(io.logz.sender.java.lang.Object object) {
        return this.delegate().contains(object);
    }

    @CanIgnoreReturnValue
    public boolean add(E element) {
        return this.delegate().add(element);
    }

    @CanIgnoreReturnValue
    public boolean remove(io.logz.sender.java.lang.Object object) {
        return this.delegate().remove(object);
    }

    public boolean containsAll(Collection<?> collection) {
        return this.delegate().containsAll(collection);
    }

    @CanIgnoreReturnValue
    public boolean addAll(Collection<? extends E> collection) {
        return this.delegate().addAll(collection);
    }

    @CanIgnoreReturnValue
    public boolean retainAll(Collection<?> collection) {
        return this.delegate().retainAll(collection);
    }

    public void clear() {
        this.delegate().clear();
    }

    public io.logz.sender.java.lang.Object[] toArray() {
        return this.delegate().toArray();
    }

    @CanIgnoreReturnValue
    public <T extends io.logz.sender.java.lang.Object> T[] toArray(T[] array) {
        return this.delegate().toArray(array);
    }

    protected boolean standardContains(@NullableDecl io.logz.sender.java.lang.Object object) {
        return Iterators.contains(this.iterator(), object);
    }

    protected boolean standardContainsAll(Collection<?> collection) {
        return Collections2.containsAllImpl(this, collection);
    }

    protected boolean standardAddAll(Collection<? extends E> collection) {
        return Iterators.addAll(this, collection.iterator());
    }

    protected boolean standardRemove(@NullableDecl io.logz.sender.java.lang.Object object) {
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!Objects.equal(iterator.next(), object)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    protected boolean standardRemoveAll(Collection<?> collection) {
        return Iterators.removeAll(this.iterator(), collection);
    }

    protected boolean standardRetainAll(Collection<?> collection) {
        return Iterators.retainAll(this.iterator(), collection);
    }

    protected void standardClear() {
        Iterators.clear(this.iterator());
    }

    protected boolean standardIsEmpty() {
        return !this.iterator().hasNext();
    }

    protected String standardToString() {
        return Collections2.toStringImpl(this);
    }

    protected io.logz.sender.java.lang.Object[] standardToArray() {
        io.logz.sender.java.lang.Object[] newArray = new io.logz.sender.java.lang.Object[this.size()];
        return this.toArray(newArray);
    }

    protected <T extends io.logz.sender.java.lang.Object> T[] standardToArray(T[] array) {
        return ObjectArrays.toArrayImpl((Collection)this, array);
    }
}

