/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.collect;

import io.logz.sender.com.google.common.annotations.Beta;
import io.logz.sender.com.google.common.annotations.GwtCompatible;
import io.logz.sender.com.google.common.collect.ForwardingCollection;
import io.logz.sender.com.google.common.collect.Lists;
import io.logz.sender.com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.logz.sender.java.lang.Iterable;
import io.logz.sender.java.util.Collection;
import io.logz.sender.java.util.Iterator;
import io.logz.sender.java.util.List;
import io.logz.sender.java.util.ListIterator;
import io.logz.sender.org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible
public abstract class ForwardingList<E extends io.logz.sender.java.lang.Object>
extends ForwardingCollection<E>
implements List<E> {
    protected ForwardingList() {
    }

    @Override
    protected abstract List<E> delegate();

    public void add(int index, E element) {
        this.delegate().add(index, element);
    }

    @CanIgnoreReturnValue
    public boolean addAll(int index, Collection<? extends E> elements) {
        return this.delegate().addAll(index, elements);
    }

    public E get(int index) {
        return (E)this.delegate().get(index);
    }

    public int indexOf(io.logz.sender.java.lang.Object element) {
        return this.delegate().indexOf(element);
    }

    public int lastIndexOf(io.logz.sender.java.lang.Object element) {
        return this.delegate().lastIndexOf(element);
    }

    public ListIterator<E> listIterator() {
        return this.delegate().listIterator();
    }

    public ListIterator<E> listIterator(int index) {
        return this.delegate().listIterator(index);
    }

    @CanIgnoreReturnValue
    public E remove(int index) {
        return (E)this.delegate().remove(index);
    }

    @CanIgnoreReturnValue
    public E set(int index, E element) {
        return (E)this.delegate().set(index, element);
    }

    public List<E> subList(int fromIndex, int toIndex) {
        return this.delegate().subList(fromIndex, toIndex);
    }

    public boolean equals(@NullableDecl io.logz.sender.java.lang.Object object) {
        return object == this || this.delegate().equals(object);
    }

    public int hashCode() {
        return this.delegate().hashCode();
    }

    protected boolean standardAdd(E element) {
        this.add(this.size(), element);
        return true;
    }

    protected boolean standardAddAll(int index, Iterable<? extends E> elements) {
        return Lists.addAllImpl(this, index, elements);
    }

    protected int standardIndexOf(@NullableDecl io.logz.sender.java.lang.Object element) {
        return Lists.indexOfImpl(this, element);
    }

    protected int standardLastIndexOf(@NullableDecl io.logz.sender.java.lang.Object element) {
        return Lists.lastIndexOfImpl(this, element);
    }

    protected Iterator<E> standardIterator() {
        return this.listIterator();
    }

    protected ListIterator<E> standardListIterator() {
        return this.listIterator(0);
    }

    @Beta
    protected ListIterator<E> standardListIterator(int start) {
        return Lists.listIteratorImpl(this, start);
    }

    @Beta
    protected List<E> standardSubList(int fromIndex, int toIndex) {
        return Lists.subListImpl(this, fromIndex, toIndex);
    }

    @Beta
    protected boolean standardEquals(@NullableDecl io.logz.sender.java.lang.Object object) {
        return Lists.equalsImpl(this, object);
    }

    @Beta
    protected int standardHashCode() {
        return Lists.hashCodeImpl(this);
    }
}

