/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.collect;

import io.logz.sender.com.google.common.annotations.Beta;
import io.logz.sender.com.google.common.annotations.GwtCompatible;
import io.logz.sender.com.google.common.base.Objects;
import io.logz.sender.com.google.common.collect.ForwardingObject;
import io.logz.sender.com.google.common.collect.Iterators;
import io.logz.sender.com.google.common.collect.Maps;
import io.logz.sender.com.google.common.collect.Sets;
import io.logz.sender.com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.util.Collection;
import io.logz.sender.java.util.Iterator;
import io.logz.sender.java.util.Map;
import io.logz.sender.java.util.Set;
import io.logz.sender.org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible
public abstract class ForwardingMap<K extends io.logz.sender.java.lang.Object, V extends io.logz.sender.java.lang.Object>
extends ForwardingObject
implements Map<K, V> {
    protected ForwardingMap() {
    }

    protected abstract Map<K, V> delegate();

    public int size() {
        return this.delegate().size();
    }

    public boolean isEmpty() {
        return this.delegate().isEmpty();
    }

    @CanIgnoreReturnValue
    public V remove(io.logz.sender.java.lang.Object object) {
        return (V)this.delegate().remove(object);
    }

    public void clear() {
        this.delegate().clear();
    }

    public boolean containsKey(@NullableDecl io.logz.sender.java.lang.Object key) {
        return this.delegate().containsKey(key);
    }

    public boolean containsValue(@NullableDecl io.logz.sender.java.lang.Object value) {
        return this.delegate().containsValue(value);
    }

    public V get(@NullableDecl io.logz.sender.java.lang.Object key) {
        return (V)this.delegate().get(key);
    }

    @CanIgnoreReturnValue
    public V put(K key, V value) {
        return (V)this.delegate().put(key, value);
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        this.delegate().putAll(map);
    }

    public Set<K> keySet() {
        return this.delegate().keySet();
    }

    public Collection<V> values() {
        return this.delegate().values();
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegate().entrySet();
    }

    public boolean equals(@NullableDecl io.logz.sender.java.lang.Object object) {
        return object == this || this.delegate().equals(object);
    }

    public int hashCode() {
        return this.delegate().hashCode();
    }

    protected void standardPutAll(Map<? extends K, ? extends V> map) {
        Maps.putAllImpl(this, map);
    }

    @Beta
    protected V standardRemove(@NullableDecl io.logz.sender.java.lang.Object key) {
        Iterator entryIterator = this.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry entry = (Map.Entry)entryIterator.next();
            if (!Objects.equal(entry.getKey(), key)) continue;
            io.logz.sender.java.lang.Object value = entry.getValue();
            entryIterator.remove();
            return (V)value;
        }
        return null;
    }

    protected void standardClear() {
        Iterators.clear(this.entrySet().iterator());
    }

    @Beta
    protected boolean standardContainsKey(@NullableDecl io.logz.sender.java.lang.Object key) {
        return Maps.containsKeyImpl(this, key);
    }

    protected boolean standardContainsValue(@NullableDecl io.logz.sender.java.lang.Object value) {
        return Maps.containsValueImpl(this, value);
    }

    protected boolean standardIsEmpty() {
        return !this.entrySet().iterator().hasNext();
    }

    protected boolean standardEquals(@NullableDecl io.logz.sender.java.lang.Object object) {
        return Maps.equalsImpl(this, object);
    }

    protected int standardHashCode() {
        return Sets.hashCodeImpl(this.entrySet());
    }

    protected String standardToString() {
        return Maps.toStringImpl(this);
    }

    @Beta
    protected abstract class StandardEntrySet
    extends Maps.EntrySet<K, V> {
        @Override
        Map<K, V> map() {
            return ForwardingMap.this;
        }
    }

    @Beta
    protected class StandardValues
    extends Maps.Values<K, V> {
        public StandardValues() {
            super(ForwardingMap.this);
        }
    }

    @Beta
    protected class StandardKeySet
    extends Maps.KeySet<K, V> {
        public StandardKeySet() {
            super(ForwardingMap.this);
        }
    }
}

