/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.collect;

import io.logz.sender.com.google.common.annotations.Beta;
import io.logz.sender.com.google.common.annotations.GwtCompatible;
import io.logz.sender.com.google.common.base.Objects;
import io.logz.sender.com.google.common.collect.ForwardingObject;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.lang.StringBuilder;
import io.logz.sender.java.util.Map;
import io.logz.sender.org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible
public abstract class ForwardingMapEntry<K extends io.logz.sender.java.lang.Object, V extends io.logz.sender.java.lang.Object>
extends ForwardingObject
implements Map.Entry<K, V> {
    protected ForwardingMapEntry() {
    }

    protected abstract Map.Entry<K, V> delegate();

    public K getKey() {
        return (K)this.delegate().getKey();
    }

    public V getValue() {
        return (V)this.delegate().getValue();
    }

    public V setValue(V value) {
        return (V)this.delegate().setValue(value);
    }

    public boolean equals(@NullableDecl io.logz.sender.java.lang.Object object) {
        return this.delegate().equals(object);
    }

    public int hashCode() {
        return this.delegate().hashCode();
    }

    protected boolean standardEquals(@NullableDecl io.logz.sender.java.lang.Object object) {
        if (object instanceof Map.Entry) {
            Map.Entry that = (Map.Entry)object;
            return Objects.equal(this.getKey(), that.getKey()) && Objects.equal(this.getValue(), that.getValue());
        }
        return false;
    }

    protected int standardHashCode() {
        K k = this.getKey();
        V v = this.getValue();
        return (k == null ? 0 : k.hashCode()) ^ (v == null ? 0 : v.hashCode());
    }

    @Beta
    protected String standardToString() {
        return new StringBuilder().append(this.getKey()).append((String)"io.logz.sender.=").append(this.getValue()).toString();
    }
}

