/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.collect;

import io.logz.sender.com.google.common.annotations.Beta;
import io.logz.sender.com.google.common.annotations.GwtCompatible;
import io.logz.sender.com.google.common.collect.ForwardingSet;
import io.logz.sender.java.lang.ClassCastException;
import io.logz.sender.java.lang.Comparable;
import io.logz.sender.java.lang.NullPointerException;
import io.logz.sender.java.util.Comparator;
import io.logz.sender.java.util.Iterator;
import io.logz.sender.java.util.NoSuchElementException;
import io.logz.sender.java.util.SortedSet;
import io.logz.sender.org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible
public abstract class ForwardingSortedSet<E extends io.logz.sender.java.lang.Object>
extends ForwardingSet<E>
implements SortedSet<E> {
    protected ForwardingSortedSet() {
    }

    @Override
    protected abstract SortedSet<E> delegate();

    public Comparator<? super E> comparator() {
        return this.delegate().comparator();
    }

    public E first() {
        return (E)this.delegate().first();
    }

    public SortedSet<E> headSet(E toElement) {
        return this.delegate().headSet(toElement);
    }

    public E last() {
        return (E)this.delegate().last();
    }

    public SortedSet<E> subSet(E fromElement, E toElement) {
        return this.delegate().subSet(fromElement, toElement);
    }

    public SortedSet<E> tailSet(E fromElement) {
        return this.delegate().tailSet(fromElement);
    }

    private int unsafeCompare(@NullableDecl io.logz.sender.java.lang.Object o1, @NullableDecl io.logz.sender.java.lang.Object o2) {
        Comparator<E> comparator = this.comparator();
        return comparator == null ? ((Comparable)o1).compareTo(o2) : comparator.compare(o1, o2);
    }

    @Override
    @Beta
    protected boolean standardContains(@NullableDecl io.logz.sender.java.lang.Object object) {
        try {
            ForwardingSortedSet self = this;
            io.logz.sender.java.lang.Object ceiling = self.tailSet(object).first();
            return this.unsafeCompare(ceiling, object) == 0;
        }
        catch (ClassCastException | NullPointerException | NoSuchElementException e) {
            return false;
        }
    }

    @Override
    @Beta
    protected boolean standardRemove(@NullableDecl io.logz.sender.java.lang.Object object) {
        try {
            io.logz.sender.java.lang.Object ceiling;
            ForwardingSortedSet self = this;
            Iterator iterator = self.tailSet(object).iterator();
            if (iterator.hasNext() && this.unsafeCompare(ceiling = iterator.next(), object) == 0) {
                iterator.remove();
                return true;
            }
        }
        catch (ClassCastException | NullPointerException e) {
            return false;
        }
        return false;
    }

    @Beta
    protected SortedSet<E> standardSubSet(E fromElement, E toElement) {
        return this.tailSet(fromElement).headSet(toElement);
    }
}

