/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.collect;

import io.logz.sender.com.google.common.annotations.Beta;
import io.logz.sender.com.google.common.annotations.GwtCompatible;
import io.logz.sender.com.google.common.annotations.VisibleForTesting;
import io.logz.sender.com.google.common.base.Preconditions;
import io.logz.sender.com.google.common.collect.BiMap;
import io.logz.sender.com.google.common.collect.CollectCollectors;
import io.logz.sender.com.google.common.collect.CollectPreconditions;
import io.logz.sender.com.google.common.collect.ImmutableBiMapFauxverideShim;
import io.logz.sender.com.google.common.collect.ImmutableMap;
import io.logz.sender.com.google.common.collect.ImmutableSet;
import io.logz.sender.com.google.common.collect.Iterables;
import io.logz.sender.com.google.common.collect.Maps;
import io.logz.sender.com.google.common.collect.Ordering;
import io.logz.sender.com.google.common.collect.RegularImmutableBiMap;
import io.logz.sender.com.google.common.collect.SingletonImmutableBiMap;
import io.logz.sender.com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.logz.sender.java.lang.AssertionError;
import io.logz.sender.java.lang.Deprecated;
import io.logz.sender.java.lang.Iterable;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.lang.UnsupportedOperationException;
import io.logz.sender.java.util.Arrays;
import io.logz.sender.java.util.Comparator;
import io.logz.sender.java.util.Map;
import io.logz.sender.java.util.function.Function;
import io.logz.sender.java.util.stream.Collector;

@GwtCompatible(serializable=true, emulated=true)
public abstract class ImmutableBiMap<K extends io.logz.sender.java.lang.Object, V extends io.logz.sender.java.lang.Object>
extends ImmutableBiMapFauxverideShim<K, V>
implements BiMap<K, V> {
    @Beta
    public static <T extends io.logz.sender.java.lang.Object, K extends io.logz.sender.java.lang.Object, V extends io.logz.sender.java.lang.Object> Collector<T, ?, ImmutableBiMap<K, V>> toImmutableBiMap(Function<? super T, ? extends K> keyFunction, Function<? super T, ? extends V> valueFunction) {
        return CollectCollectors.toImmutableBiMap(keyFunction, valueFunction);
    }

    public static <K extends io.logz.sender.java.lang.Object, V extends io.logz.sender.java.lang.Object> ImmutableBiMap<K, V> of() {
        return RegularImmutableBiMap.EMPTY;
    }

    public static <K extends io.logz.sender.java.lang.Object, V extends io.logz.sender.java.lang.Object> ImmutableBiMap<K, V> of(K k1, V v1) {
        return new SingletonImmutableBiMap<K, V>(k1, v1);
    }

    public static <K extends io.logz.sender.java.lang.Object, V extends io.logz.sender.java.lang.Object> ImmutableBiMap<K, V> of(K k1, V v1, K k2, V v2) {
        return RegularImmutableBiMap.fromEntries(ImmutableBiMap.entryOf(k1, v1), ImmutableBiMap.entryOf(k2, v2));
    }

    public static <K extends io.logz.sender.java.lang.Object, V extends io.logz.sender.java.lang.Object> ImmutableBiMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        return RegularImmutableBiMap.fromEntries(ImmutableBiMap.entryOf(k1, v1), ImmutableBiMap.entryOf(k2, v2), ImmutableBiMap.entryOf(k3, v3));
    }

    public static <K extends io.logz.sender.java.lang.Object, V extends io.logz.sender.java.lang.Object> ImmutableBiMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        return RegularImmutableBiMap.fromEntries(ImmutableBiMap.entryOf(k1, v1), ImmutableBiMap.entryOf(k2, v2), ImmutableBiMap.entryOf(k3, v3), ImmutableBiMap.entryOf(k4, v4));
    }

    public static <K extends io.logz.sender.java.lang.Object, V extends io.logz.sender.java.lang.Object> ImmutableBiMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        return RegularImmutableBiMap.fromEntries(ImmutableBiMap.entryOf(k1, v1), ImmutableBiMap.entryOf(k2, v2), ImmutableBiMap.entryOf(k3, v3), ImmutableBiMap.entryOf(k4, v4), ImmutableBiMap.entryOf(k5, v5));
    }

    public static <K extends io.logz.sender.java.lang.Object, V extends io.logz.sender.java.lang.Object> Builder<K, V> builder() {
        return new Builder();
    }

    @Beta
    public static <K extends io.logz.sender.java.lang.Object, V extends io.logz.sender.java.lang.Object> Builder<K, V> builderWithExpectedSize(int expectedSize) {
        CollectPreconditions.checkNonnegative(expectedSize, (String)"io.logz.sender.expectedSize");
        return new Builder(expectedSize);
    }

    public static <K extends io.logz.sender.java.lang.Object, V extends io.logz.sender.java.lang.Object> ImmutableBiMap<K, V> copyOf(Map<? extends K, ? extends V> map) {
        ImmutableBiMap bimap;
        if (map instanceof ImmutableBiMap && !(bimap = (ImmutableBiMap)map).isPartialView()) {
            return bimap;
        }
        return ImmutableBiMap.copyOf(map.entrySet());
    }

    @Beta
    public static <K extends io.logz.sender.java.lang.Object, V extends io.logz.sender.java.lang.Object> ImmutableBiMap<K, V> copyOf(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries) {
        Map.Entry[] entryArray = (Map.Entry[])Iterables.toArray(entries, (io.logz.sender.java.lang.Object[])EMPTY_ENTRY_ARRAY);
        switch (entryArray.length) {
            case 0: {
                return ImmutableBiMap.of();
            }
            case 1: {
                Map.Entry entry = entryArray[0];
                return ImmutableBiMap.of(entry.getKey(), entry.getValue());
            }
        }
        return RegularImmutableBiMap.fromEntries(entryArray);
    }

    ImmutableBiMap() {
    }

    @Override
    public abstract ImmutableBiMap<V, K> inverse();

    @Override
    public ImmutableSet<V> values() {
        return ((ImmutableMap)((Object)this.inverse())).keySet();
    }

    @Override
    final ImmutableSet<V> createValues() {
        throw new AssertionError((io.logz.sender.java.lang.Object)"io.logz.sender.should never be called");
    }

    @Override
    @Deprecated
    @CanIgnoreReturnValue
    public V forcePut(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    io.logz.sender.java.lang.Object writeReplace() {
        return new SerializedForm(this);
    }

    private static class SerializedForm
    extends ImmutableMap.SerializedForm {
        private static final long serialVersionUID = 0L;

        SerializedForm(ImmutableBiMap<?, ?> bimap) {
            super(bimap);
        }

        @Override
        io.logz.sender.java.lang.Object readResolve() {
            Builder<io.logz.sender.java.lang.Object, io.logz.sender.java.lang.Object> builder = new Builder<io.logz.sender.java.lang.Object, io.logz.sender.java.lang.Object>();
            return this.createMap(builder);
        }
    }

    public static final class Builder<K extends io.logz.sender.java.lang.Object, V extends io.logz.sender.java.lang.Object>
    extends ImmutableMap.Builder<K, V> {
        public Builder() {
        }

        Builder(int size) {
            super(size);
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<K, V> put(K key, V value) {
            super.put(key, value);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<K, V> put(Map.Entry<? extends K, ? extends V> entry) {
            super.put(entry);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<K, V> putAll(Map<? extends K, ? extends V> map) {
            super.putAll(map);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        @Beta
        public Builder<K, V> putAll(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries) {
            super.putAll(entries);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        @Beta
        public Builder<K, V> orderEntriesByValue(Comparator<? super V> valueComparator) {
            super.orderEntriesByValue(valueComparator);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        Builder<K, V> combine(ImmutableMap.Builder<K, V> builder) {
            super.combine(builder);
            return this;
        }

        @Override
        public ImmutableBiMap<K, V> build() {
            switch (this.size) {
                case 0: {
                    return ImmutableBiMap.of();
                }
                case 1: {
                    return ImmutableBiMap.of(this.entries[0].getKey(), this.entries[0].getValue());
                }
            }
            if (this.valueComparator != null) {
                if (this.entriesUsed) {
                    this.entries = (Map.Entry[])Arrays.copyOf((io.logz.sender.java.lang.Object[])this.entries, (int)this.size);
                }
                Arrays.sort((io.logz.sender.java.lang.Object[])this.entries, (int)0, (int)this.size, Ordering.from(this.valueComparator).onResultOf(Maps.valueFunction()));
            }
            this.entriesUsed = true;
            return RegularImmutableBiMap.fromEntryArray(this.size, this.entries);
        }

        @Override
        @VisibleForTesting
        ImmutableBiMap<K, V> buildJdkBacked() {
            Preconditions.checkState(this.valueComparator == null, (io.logz.sender.java.lang.Object)"io.logz.sender.buildJdkBacked is for tests only, doesn't support orderEntriesByValue");
            switch (this.size) {
                case 0: {
                    return ImmutableBiMap.of();
                }
                case 1: {
                    return ImmutableBiMap.of(this.entries[0].getKey(), this.entries[0].getValue());
                }
            }
            this.entriesUsed = true;
            return RegularImmutableBiMap.fromEntryArray(this.size, this.entries);
        }
    }
}

