/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.collect;

import io.logz.sender.com.google.common.annotations.GwtCompatible;
import io.logz.sender.com.google.common.base.Preconditions;
import io.logz.sender.com.google.common.collect.ImmutableList;
import io.logz.sender.com.google.common.collect.ObjectArrays;
import io.logz.sender.com.google.common.collect.RegularImmutableAsList;
import io.logz.sender.com.google.common.collect.UnmodifiableIterator;
import io.logz.sender.com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.logz.sender.java.io.Serializable;
import io.logz.sender.java.lang.AssertionError;
import io.logz.sender.java.lang.Deprecated;
import io.logz.sender.java.lang.Integer;
import io.logz.sender.java.lang.Iterable;
import io.logz.sender.java.lang.UnsupportedOperationException;
import io.logz.sender.java.util.AbstractCollection;
import io.logz.sender.java.util.Collection;
import io.logz.sender.java.util.Iterator;
import io.logz.sender.java.util.Spliterator;
import io.logz.sender.java.util.Spliterators;
import io.logz.sender.java.util.function.Predicate;
import io.logz.sender.org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible(emulated=true)
public abstract class ImmutableCollection<E extends io.logz.sender.java.lang.Object>
extends AbstractCollection<E>
implements Serializable {
    static final int SPLITERATOR_CHARACTERISTICS = 1296;
    private static final io.logz.sender.java.lang.Object[] EMPTY_ARRAY = new io.logz.sender.java.lang.Object[0];

    ImmutableCollection() {
    }

    public abstract UnmodifiableIterator<E> iterator();

    public Spliterator<E> spliterator() {
        return Spliterators.spliterator((Collection)this, (int)1296);
    }

    public final io.logz.sender.java.lang.Object[] toArray() {
        int size = this.size();
        if (size == 0) {
            return EMPTY_ARRAY;
        }
        io.logz.sender.java.lang.Object[] result = new io.logz.sender.java.lang.Object[size];
        this.copyIntoArray(result, 0);
        return result;
    }

    @CanIgnoreReturnValue
    public final <T extends io.logz.sender.java.lang.Object> T[] toArray(T[] other) {
        Preconditions.checkNotNull(other);
        int size = this.size();
        if (other.length < size) {
            other = ObjectArrays.newArray(other, (int)size);
        } else if (other.length > size) {
            other[size] = null;
        }
        this.copyIntoArray((io.logz.sender.java.lang.Object[])other, 0);
        return other;
    }

    public abstract boolean contains(@NullableDecl io.logz.sender.java.lang.Object var1);

    @Deprecated
    @CanIgnoreReturnValue
    public final boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @CanIgnoreReturnValue
    public final boolean remove(io.logz.sender.java.lang.Object object) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @CanIgnoreReturnValue
    public final boolean addAll(Collection<? extends E> newElements) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @CanIgnoreReturnValue
    public final boolean removeAll(Collection<?> oldElements) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @CanIgnoreReturnValue
    public final boolean removeIf(Predicate<? super E> filter) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public final boolean retainAll(Collection<?> elementsToKeep) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    public ImmutableList<E> asList() {
        switch (this.size()) {
            case 0: {
                return ImmutableList.of();
            }
            case 1: {
                return ImmutableList.of(this.iterator().next());
            }
        }
        return new RegularImmutableAsList(this, this.toArray());
    }

    abstract boolean isPartialView();

    @CanIgnoreReturnValue
    int copyIntoArray(io.logz.sender.java.lang.Object[] dst, int offset) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            io.logz.sender.java.lang.Object e = iterator.next();
            dst[offset++] = e;
        }
        return offset;
    }

    io.logz.sender.java.lang.Object writeReplace() {
        return new ImmutableList.SerializedForm(this.toArray());
    }

    public static abstract class Builder<E extends io.logz.sender.java.lang.Object>
    extends io.logz.sender.java.lang.Object {
        static final int DEFAULT_INITIAL_CAPACITY = 4;

        static int expandedCapacity(int oldCapacity, int minCapacity) {
            if (minCapacity < 0) {
                throw new AssertionError((io.logz.sender.java.lang.Object)"io.logz.sender.cannot store more than MAX_VALUE elements");
            }
            int newCapacity = oldCapacity + (oldCapacity >> 1) + 1;
            if (newCapacity < minCapacity) {
                newCapacity = Integer.highestOneBit((int)(minCapacity - 1)) << 1;
            }
            if (newCapacity < 0) {
                newCapacity = java.lang.Integer.MAX_VALUE;
            }
            return newCapacity;
        }

        Builder() {
        }

        @CanIgnoreReturnValue
        public abstract Builder<E> add(E var1);

        @CanIgnoreReturnValue
        public Builder<E> add(E ... elements) {
            for (E element : elements) {
                this.add(element);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<E> addAll(Iterable<? extends E> elements) {
            for (io.logz.sender.java.lang.Object element : elements) {
                this.add((E)element);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<E> addAll(Iterator<? extends E> elements) {
            while (elements.hasNext()) {
                this.add((E)elements.next());
            }
            return this;
        }

        public abstract ImmutableCollection<E> build();
    }
}

