/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.collect;

import io.logz.sender.com.google.common.annotations.GwtCompatible;
import io.logz.sender.com.google.common.collect.ImmutableSet;
import io.logz.sender.com.google.common.collect.Iterables;
import io.logz.sender.com.google.common.collect.Iterators;
import io.logz.sender.com.google.common.collect.UnmodifiableIterator;
import io.logz.sender.com.google.errorprone.annotations.concurrent.LazyInit;
import io.logz.sender.java.io.Serializable;
import io.logz.sender.java.lang.Enum;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.util.Collection;
import io.logz.sender.java.util.EnumSet;
import io.logz.sender.java.util.Spliterator;
import io.logz.sender.java.util.function.Consumer;

@GwtCompatible(serializable=true, emulated=true)
final class ImmutableEnumSet<E extends Enum<E>>
extends ImmutableSet<E> {
    private final transient EnumSet<E> delegate;
    @LazyInit
    private transient int hashCode;

    static ImmutableSet asImmutable(EnumSet set) {
        switch (set.size()) {
            case 0: {
                return ImmutableSet.of();
            }
            case 1: {
                return ImmutableSet.of(Iterables.getOnlyElement(set));
            }
        }
        return new ImmutableEnumSet(set);
    }

    private ImmutableEnumSet(EnumSet<E> delegate) {
        this.delegate = delegate;
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return Iterators.unmodifiableIterator(this.delegate.iterator());
    }

    @Override
    public Spliterator<E> spliterator() {
        return this.delegate.spliterator();
    }

    public void forEach(Consumer<? super E> action) {
        this.delegate.forEach(action);
    }

    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean contains(io.logz.sender.java.lang.Object object) {
        return this.delegate.contains(object);
    }

    public boolean containsAll(Collection<?> collection) {
        if (collection instanceof ImmutableEnumSet) {
            collection = ((ImmutableEnumSet)collection).delegate;
        }
        return this.delegate.containsAll(collection);
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean equals(io.logz.sender.java.lang.Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ImmutableEnumSet) {
            object = ((ImmutableEnumSet)object).delegate;
        }
        return this.delegate.equals(object);
    }

    @Override
    boolean isHashCodeFast() {
        return true;
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        return result == 0 ? (this.hashCode = this.delegate.hashCode()) : result;
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    io.logz.sender.java.lang.Object writeReplace() {
        return new EnumSerializedForm<E>(this.delegate);
    }

    private static class EnumSerializedForm<E extends Enum<E>>
    extends io.logz.sender.java.lang.Object
    implements Serializable {
        final EnumSet<E> delegate;
        private static final long serialVersionUID = 0L;

        EnumSerializedForm(EnumSet<E> delegate) {
            this.delegate = delegate;
        }

        io.logz.sender.java.lang.Object readResolve() {
            return new ImmutableEnumSet(this.delegate.clone());
        }
    }
}

