/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.collect;

import io.logz.sender.com.google.common.annotations.Beta;
import io.logz.sender.com.google.common.annotations.GwtCompatible;
import io.logz.sender.com.google.common.annotations.GwtIncompatible;
import io.logz.sender.com.google.common.base.Preconditions;
import io.logz.sender.com.google.common.collect.CollectCollectors;
import io.logz.sender.com.google.common.collect.ImmutableCollection;
import io.logz.sender.com.google.common.collect.ImmutableList;
import io.logz.sender.com.google.common.collect.ImmutableSet;
import io.logz.sender.com.google.common.collect.ImmutableSortedSetFauxverideShim;
import io.logz.sender.com.google.common.collect.Iterables;
import io.logz.sender.com.google.common.collect.Iterators;
import io.logz.sender.com.google.common.collect.ObjectArrays;
import io.logz.sender.com.google.common.collect.Ordering;
import io.logz.sender.com.google.common.collect.RegularImmutableSortedSet;
import io.logz.sender.com.google.common.collect.SortedIterable;
import io.logz.sender.com.google.common.collect.SortedIterables;
import io.logz.sender.com.google.common.collect.UnmodifiableIterator;
import io.logz.sender.com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.logz.sender.com.google.errorprone.annotations.concurrent.LazyInit;
import io.logz.sender.java.io.InvalidObjectException;
import io.logz.sender.java.io.ObjectInputStream;
import io.logz.sender.java.io.Serializable;
import io.logz.sender.java.lang.AssertionError;
import io.logz.sender.java.lang.Comparable;
import io.logz.sender.java.lang.Deprecated;
import io.logz.sender.java.lang.Iterable;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.lang.StringBuilder;
import io.logz.sender.java.lang.System;
import io.logz.sender.java.lang.UnsupportedOperationException;
import io.logz.sender.java.util.Arrays;
import io.logz.sender.java.util.Collection;
import io.logz.sender.java.util.Collections;
import io.logz.sender.java.util.Comparator;
import io.logz.sender.java.util.Iterator;
import io.logz.sender.java.util.NavigableSet;
import io.logz.sender.java.util.SortedSet;
import io.logz.sender.java.util.Spliterator;
import io.logz.sender.java.util.Spliterators;
import io.logz.sender.java.util.function.Consumer;
import io.logz.sender.java.util.stream.Collector;
import io.logz.sender.org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible(serializable=true, emulated=true)
public abstract class ImmutableSortedSet<E extends io.logz.sender.java.lang.Object>
extends ImmutableSortedSetFauxverideShim<E>
implements NavigableSet<E>,
SortedIterable<E> {
    static final int SPLITERATOR_CHARACTERISTICS = 1301;
    final transient Comparator<? super E> comparator;
    @LazyInit
    @GwtIncompatible
    transient ImmutableSortedSet<E> descendingSet;

    @Beta
    public static <E extends io.logz.sender.java.lang.Object> Collector<E, ?, ImmutableSortedSet<E>> toImmutableSortedSet(Comparator<? super E> comparator) {
        return CollectCollectors.toImmutableSortedSet(comparator);
    }

    static <E extends io.logz.sender.java.lang.Object> RegularImmutableSortedSet<E> emptySet(Comparator<? super E> comparator) {
        if (Ordering.natural().equals((io.logz.sender.java.lang.Object)comparator)) {
            return RegularImmutableSortedSet.NATURAL_EMPTY_SET;
        }
        return new RegularImmutableSortedSet<E>(ImmutableList.of(), comparator);
    }

    public static <E extends io.logz.sender.java.lang.Object> ImmutableSortedSet<E> of() {
        return RegularImmutableSortedSet.NATURAL_EMPTY_SET;
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E element) {
        return new RegularImmutableSortedSet<E>(ImmutableList.of(element), Ordering.natural());
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E e1, E e2) {
        return ImmutableSortedSet.construct(Ordering.natural(), (int)2, (io.logz.sender.java.lang.Object[])new Comparable[]{e1, e2});
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E e1, E e2, E e3) {
        return ImmutableSortedSet.construct(Ordering.natural(), (int)3, (io.logz.sender.java.lang.Object[])new Comparable[]{e1, e2, e3});
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E e1, E e2, E e3, E e4) {
        return ImmutableSortedSet.construct(Ordering.natural(), (int)4, (io.logz.sender.java.lang.Object[])new Comparable[]{e1, e2, e3, e4});
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E e1, E e2, E e3, E e4, E e5) {
        return ImmutableSortedSet.construct(Ordering.natural(), (int)5, (io.logz.sender.java.lang.Object[])new Comparable[]{e1, e2, e3, e4, e5});
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E e1, E e2, E e3, E e4, E e5, E e6, E ... remaining) {
        Comparable[] contents = new Comparable[6 + remaining.length];
        contents[0] = e1;
        contents[1] = e2;
        contents[2] = e3;
        contents[3] = e4;
        contents[4] = e5;
        contents[5] = e6;
        System.arraycopy(remaining, (int)0, (io.logz.sender.java.lang.Object)contents, (int)6, (int)remaining.length);
        return ImmutableSortedSet.construct(Ordering.natural(), (int)contents.length, (io.logz.sender.java.lang.Object[])contents);
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> copyOf(E[] elements) {
        return ImmutableSortedSet.construct(Ordering.natural(), (int)elements.length, (io.logz.sender.java.lang.Object[])((io.logz.sender.java.lang.Object[])elements.clone()));
    }

    public static <E extends io.logz.sender.java.lang.Object> ImmutableSortedSet<E> copyOf(Iterable<? extends E> elements) {
        Ordering naturalOrder = Ordering.natural();
        return ImmutableSortedSet.copyOf(naturalOrder, elements);
    }

    public static <E extends io.logz.sender.java.lang.Object> ImmutableSortedSet<E> copyOf(Collection<? extends E> elements) {
        Ordering naturalOrder = Ordering.natural();
        return ImmutableSortedSet.copyOf(naturalOrder, elements);
    }

    public static <E extends io.logz.sender.java.lang.Object> ImmutableSortedSet<E> copyOf(Iterator<? extends E> elements) {
        Ordering naturalOrder = Ordering.natural();
        return ImmutableSortedSet.copyOf(naturalOrder, elements);
    }

    public static <E extends io.logz.sender.java.lang.Object> ImmutableSortedSet<E> copyOf(Comparator<? super E> comparator, Iterator<? extends E> elements) {
        return ((Builder)new Builder<E>(comparator).addAll((Iterator)elements)).build();
    }

    public static <E extends io.logz.sender.java.lang.Object> ImmutableSortedSet<E> copyOf(Comparator<? super E> comparator, Iterable<? extends E> elements) {
        ImmutableSortedSet original;
        Preconditions.checkNotNull(comparator);
        boolean hasSameComparator = SortedIterables.hasSameComparator(comparator, elements);
        if (hasSameComparator && elements instanceof ImmutableSortedSet && !(original = (ImmutableSortedSet)elements).isPartialView()) {
            return original;
        }
        io.logz.sender.java.lang.Object[] array = Iterables.toArray(elements);
        return ImmutableSortedSet.construct(comparator, (int)array.length, (io.logz.sender.java.lang.Object[])array);
    }

    public static <E extends io.logz.sender.java.lang.Object> ImmutableSortedSet<E> copyOf(Comparator<? super E> comparator, Collection<? extends E> elements) {
        return ImmutableSortedSet.copyOf(comparator, elements);
    }

    public static <E extends io.logz.sender.java.lang.Object> ImmutableSortedSet<E> copyOfSorted(SortedSet<E> sortedSet) {
        Comparator<E> comparator = SortedIterables.comparator(sortedSet);
        ImmutableList<E> list = ImmutableList.copyOf(sortedSet);
        if (list.isEmpty()) {
            return ImmutableSortedSet.emptySet(comparator);
        }
        return new RegularImmutableSortedSet<E>(list, comparator);
    }

    static <E extends io.logz.sender.java.lang.Object> ImmutableSortedSet<E> construct(Comparator<? super E> comparator, int n, E ... contents) {
        if (n == 0) {
            return ImmutableSortedSet.emptySet(comparator);
        }
        ObjectArrays.checkElementsNotNull(contents, n);
        Arrays.sort(contents, (int)0, (int)n, comparator);
        int uniques = 1;
        for (int i = 1; i < n; ++i) {
            E cur = contents[i];
            E prev = contents[uniques - 1];
            if (comparator.compare(cur, prev) == 0) continue;
            contents[uniques++] = cur;
        }
        Arrays.fill(contents, (int)uniques, (int)n, null);
        return new RegularImmutableSortedSet<E>(ImmutableList.asImmutableList(contents, uniques), comparator);
    }

    public static <E extends io.logz.sender.java.lang.Object> Builder<E> orderedBy(Comparator<E> comparator) {
        return new Builder<E>(comparator);
    }

    public static <E extends Comparable<?>> Builder<E> reverseOrder() {
        return new Builder(Collections.reverseOrder());
    }

    public static <E extends Comparable<?>> Builder<E> naturalOrder() {
        return new Builder(Ordering.natural());
    }

    int unsafeCompare(io.logz.sender.java.lang.Object a, io.logz.sender.java.lang.Object b) {
        return ImmutableSortedSet.unsafeCompare(this.comparator, a, b);
    }

    static int unsafeCompare(Comparator<?> comparator, io.logz.sender.java.lang.Object a, io.logz.sender.java.lang.Object b) {
        Comparator<?> unsafeComparator = comparator;
        return unsafeComparator.compare(a, b);
    }

    ImmutableSortedSet(Comparator<? super E> comparator) {
        this.comparator = comparator;
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    @Override
    public abstract UnmodifiableIterator<E> iterator();

    public ImmutableSortedSet<E> headSet(E toElement) {
        return this.headSet((io.logz.sender.java.lang.Object)toElement, false);
    }

    @GwtIncompatible
    public ImmutableSortedSet<E> headSet(E toElement, boolean inclusive) {
        return this.headSetImpl(Preconditions.checkNotNull(toElement), inclusive);
    }

    public ImmutableSortedSet<E> subSet(E fromElement, E toElement) {
        return this.subSet((io.logz.sender.java.lang.Object)fromElement, true, (io.logz.sender.java.lang.Object)toElement, false);
    }

    @GwtIncompatible
    public ImmutableSortedSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        Preconditions.checkNotNull(fromElement);
        Preconditions.checkNotNull(toElement);
        Preconditions.checkArgument(this.comparator.compare(fromElement, toElement) <= 0);
        return this.subSetImpl(fromElement, fromInclusive, toElement, toInclusive);
    }

    public ImmutableSortedSet<E> tailSet(E fromElement) {
        return this.tailSet((io.logz.sender.java.lang.Object)fromElement, true);
    }

    @GwtIncompatible
    public ImmutableSortedSet<E> tailSet(E fromElement, boolean inclusive) {
        return this.tailSetImpl(Preconditions.checkNotNull(fromElement), inclusive);
    }

    abstract ImmutableSortedSet<E> headSetImpl(E var1, boolean var2);

    abstract ImmutableSortedSet<E> subSetImpl(E var1, boolean var2, E var3, boolean var4);

    abstract ImmutableSortedSet<E> tailSetImpl(E var1, boolean var2);

    @GwtIncompatible
    public E lower(E e) {
        return Iterators.getNext(this.headSet((io.logz.sender.java.lang.Object)e, false).descendingIterator(), null);
    }

    @GwtIncompatible
    public E floor(E e) {
        return Iterators.getNext(this.headSet((io.logz.sender.java.lang.Object)e, true).descendingIterator(), null);
    }

    @GwtIncompatible
    public E ceiling(E e) {
        return Iterables.getFirst(this.tailSet((io.logz.sender.java.lang.Object)e, true), null);
    }

    @GwtIncompatible
    public E higher(E e) {
        return Iterables.getFirst(this.tailSet((io.logz.sender.java.lang.Object)e, false), null);
    }

    public E first() {
        return (E)this.iterator().next();
    }

    public E last() {
        return (E)this.descendingIterator().next();
    }

    @Deprecated
    @CanIgnoreReturnValue
    @GwtIncompatible
    public final E pollFirst() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    @CanIgnoreReturnValue
    @GwtIncompatible
    public final E pollLast() {
        throw new UnsupportedOperationException();
    }

    @GwtIncompatible
    public ImmutableSortedSet<E> descendingSet() {
        ImmutableSortedSet<E> result = this.descendingSet;
        if (result == null) {
            result = this.descendingSet = this.createDescendingSet();
            result.descendingSet = this;
        }
        return result;
    }

    @GwtIncompatible
    abstract ImmutableSortedSet<E> createDescendingSet();

    @Override
    public Spliterator<E> spliterator() {
        return new Spliterators.AbstractSpliterator<E>(this.size(), 1365){
            final UnmodifiableIterator<E> iterator;
            {
                this.iterator = ImmutableSortedSet.this.iterator();
            }

            public boolean tryAdvance(Consumer<? super E> action) {
                if (this.iterator.hasNext()) {
                    action.accept(this.iterator.next());
                    return true;
                }
                return false;
            }

            public Comparator<? super E> getComparator() {
                return ImmutableSortedSet.this.comparator;
            }
        };
    }

    @GwtIncompatible
    public abstract UnmodifiableIterator<E> descendingIterator();

    abstract int indexOf(@NullableDecl io.logz.sender.java.lang.Object var1);

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException((String)"io.logz.sender.Use SerializedForm");
    }

    @Override
    io.logz.sender.java.lang.Object writeReplace() {
        return new SerializedForm<E>(this.comparator, this.toArray());
    }

    private static class SerializedForm<E extends io.logz.sender.java.lang.Object>
    extends io.logz.sender.java.lang.Object
    implements Serializable {
        final Comparator<? super E> comparator;
        final io.logz.sender.java.lang.Object[] elements;
        private static final long serialVersionUID = 0L;

        public SerializedForm(Comparator<? super E> comparator, io.logz.sender.java.lang.Object[] elements) {
            this.comparator = comparator;
            this.elements = elements;
        }

        io.logz.sender.java.lang.Object readResolve() {
            return ((Builder)new Builder<E>(this.comparator).add(this.elements)).build();
        }
    }

    public static final class Builder<E extends io.logz.sender.java.lang.Object>
    extends ImmutableSet.Builder<E> {
        private final Comparator<? super E> comparator;
        private E[] elements;
        private int n;

        public Builder(Comparator<? super E> comparator) {
            super(true);
            this.comparator = Preconditions.checkNotNull(comparator);
            this.elements = new io.logz.sender.java.lang.Object[4];
            this.n = 0;
        }

        @Override
        void copy() {
            this.elements = Arrays.copyOf(this.elements, (int)this.elements.length);
        }

        private void sortAndDedup() {
            if (this.n == 0) {
                return;
            }
            Arrays.sort(this.elements, (int)0, (int)this.n, this.comparator);
            int unique = 1;
            for (int i = 1; i < this.n; ++i) {
                int cmp = this.comparator.compare(this.elements[unique - 1], this.elements[i]);
                if (cmp < 0) {
                    this.elements[unique++] = this.elements[i];
                    continue;
                }
                if (cmp <= 0) continue;
                throw new AssertionError((io.logz.sender.java.lang.Object)new StringBuilder().append((String)"io.logz.sender.Comparator ").append(this.comparator).append((String)"io.logz.sender. compare method violates its contract").toString());
            }
            Arrays.fill(this.elements, (int)unique, (int)this.n, null);
            this.n = unique;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<E> add(E element) {
            Preconditions.checkNotNull(element);
            this.copyIfNecessary();
            if (this.n == this.elements.length) {
                this.sortAndDedup();
                int newLength = ImmutableCollection.Builder.expandedCapacity(this.n, this.n + 1);
                if (newLength > this.elements.length) {
                    this.elements = Arrays.copyOf(this.elements, (int)newLength);
                }
            }
            this.elements[this.n++] = element;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<E> add(E ... elements) {
            ObjectArrays.checkElementsNotNull(elements);
            for (E e : elements) {
                this.add((io.logz.sender.java.lang.Object)e);
            }
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<E> addAll(Iterable<? extends E> elements) {
            super.addAll((Iterable)elements);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<E> addAll(Iterator<? extends E> elements) {
            super.addAll((Iterator)elements);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        Builder<E> combine(ImmutableSet.Builder<E> builder) {
            this.copyIfNecessary();
            Builder other = (Builder)builder;
            for (int i = 0; i < other.n; ++i) {
                this.add((io.logz.sender.java.lang.Object)other.elements[i]);
            }
            return this;
        }

        @Override
        public ImmutableSortedSet<E> build() {
            this.sortAndDedup();
            if (this.n == 0) {
                return ImmutableSortedSet.emptySet(this.comparator);
            }
            this.forceCopy = true;
            return new RegularImmutableSortedSet<E>(ImmutableList.asImmutableList(this.elements, this.n), this.comparator);
        }
    }
}

