/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.collect;

import io.logz.sender.com.google.common.annotations.GwtCompatible;
import io.logz.sender.com.google.common.annotations.GwtIncompatible;
import io.logz.sender.com.google.common.base.Ascii;
import io.logz.sender.com.google.common.base.Equivalence;
import io.logz.sender.com.google.common.base.MoreObjects;
import io.logz.sender.com.google.common.base.Preconditions;
import io.logz.sender.com.google.common.collect.MapMakerInternalMap;
import io.logz.sender.com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.logz.sender.java.lang.Enum;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.util.concurrent.ConcurrentHashMap;
import io.logz.sender.java.util.concurrent.ConcurrentMap;
import io.logz.sender.org.checkerframework.checker.nullness.compatqual.MonotonicNonNullDecl;

@GwtCompatible(emulated=true)
public final class MapMaker
extends io.logz.sender.java.lang.Object {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int DEFAULT_CONCURRENCY_LEVEL = 4;
    static final int UNSET_INT = -1;
    boolean useCustomMap;
    int initialCapacity = -1;
    int concurrencyLevel = -1;
    @MonotonicNonNullDecl
    MapMakerInternalMap.Strength keyStrength;
    @MonotonicNonNullDecl
    MapMakerInternalMap.Strength valueStrength;
    @MonotonicNonNullDecl
    Equivalence<io.logz.sender.java.lang.Object> keyEquivalence;

    @CanIgnoreReturnValue
    @GwtIncompatible
    MapMaker keyEquivalence(Equivalence<io.logz.sender.java.lang.Object> equivalence) {
        Preconditions.checkState(this.keyEquivalence == null, (String)"io.logz.sender.key equivalence was already set to %s", this.keyEquivalence);
        this.keyEquivalence = Preconditions.checkNotNull(equivalence);
        this.useCustomMap = true;
        return this;
    }

    Equivalence<io.logz.sender.java.lang.Object> getKeyEquivalence() {
        return MoreObjects.firstNonNull(this.keyEquivalence, this.getKeyStrength().defaultEquivalence());
    }

    @CanIgnoreReturnValue
    public MapMaker initialCapacity(int initialCapacity) {
        Preconditions.checkState(this.initialCapacity == -1, (String)"io.logz.sender.initial capacity was already set to %s", this.initialCapacity);
        Preconditions.checkArgument(initialCapacity >= 0);
        this.initialCapacity = initialCapacity;
        return this;
    }

    int getInitialCapacity() {
        return this.initialCapacity == -1 ? 16 : this.initialCapacity;
    }

    @CanIgnoreReturnValue
    public MapMaker concurrencyLevel(int concurrencyLevel) {
        Preconditions.checkState(this.concurrencyLevel == -1, (String)"io.logz.sender.concurrency level was already set to %s", this.concurrencyLevel);
        Preconditions.checkArgument(concurrencyLevel > 0);
        this.concurrencyLevel = concurrencyLevel;
        return this;
    }

    int getConcurrencyLevel() {
        return this.concurrencyLevel == -1 ? 4 : this.concurrencyLevel;
    }

    @CanIgnoreReturnValue
    @GwtIncompatible
    public MapMaker weakKeys() {
        return this.setKeyStrength(MapMakerInternalMap.Strength.WEAK);
    }

    MapMaker setKeyStrength(MapMakerInternalMap.Strength strength) {
        Preconditions.checkState(this.keyStrength == null, (String)"io.logz.sender.Key strength was already set to %s", (io.logz.sender.java.lang.Object)this.keyStrength);
        this.keyStrength = Preconditions.checkNotNull(strength);
        if (strength != MapMakerInternalMap.Strength.STRONG) {
            this.useCustomMap = true;
        }
        return this;
    }

    MapMakerInternalMap.Strength getKeyStrength() {
        return MoreObjects.firstNonNull(this.keyStrength, MapMakerInternalMap.Strength.STRONG);
    }

    @CanIgnoreReturnValue
    @GwtIncompatible
    public MapMaker weakValues() {
        return this.setValueStrength(MapMakerInternalMap.Strength.WEAK);
    }

    MapMaker setValueStrength(MapMakerInternalMap.Strength strength) {
        Preconditions.checkState(this.valueStrength == null, (String)"io.logz.sender.Value strength was already set to %s", (io.logz.sender.java.lang.Object)this.valueStrength);
        this.valueStrength = Preconditions.checkNotNull(strength);
        if (strength != MapMakerInternalMap.Strength.STRONG) {
            this.useCustomMap = true;
        }
        return this;
    }

    MapMakerInternalMap.Strength getValueStrength() {
        return MoreObjects.firstNonNull(this.valueStrength, MapMakerInternalMap.Strength.STRONG);
    }

    public <K extends io.logz.sender.java.lang.Object, V extends io.logz.sender.java.lang.Object> ConcurrentMap<K, V> makeMap() {
        if (!this.useCustomMap) {
            return new ConcurrentHashMap(this.getInitialCapacity(), 0.75f, this.getConcurrencyLevel());
        }
        return MapMakerInternalMap.create(this);
    }

    public String toString() {
        MoreObjects.ToStringHelper s = MoreObjects.toStringHelper(this);
        if (this.initialCapacity != -1) {
            s.add((String)"io.logz.sender.initialCapacity", this.initialCapacity);
        }
        if (this.concurrencyLevel != -1) {
            s.add((String)"io.logz.sender.concurrencyLevel", this.concurrencyLevel);
        }
        if (this.keyStrength != null) {
            s.add((String)"io.logz.sender.keyStrength", (io.logz.sender.java.lang.Object)Ascii.toLowerCase(this.keyStrength.toString()));
        }
        if (this.valueStrength != null) {
            s.add((String)"io.logz.sender.valueStrength", (io.logz.sender.java.lang.Object)Ascii.toLowerCase(this.valueStrength.toString()));
        }
        if (this.keyEquivalence != null) {
            s.addValue((io.logz.sender.java.lang.Object)"io.logz.sender.keyEquivalence");
        }
        return s.toString();
    }

    static final class Dummy
    extends Enum<Dummy> {
        public static final /* enum */ Dummy VALUE = new Dummy((String)"io.logz.sender.VALUE", 0);
        private static final /* synthetic */ Dummy[] $VALUES;

        public static Dummy[] values() {
            return (Dummy[])$VALUES.clone();
        }

        public static Dummy valueOf(String name) {
            return (Dummy)Enum.valueOf(Dummy.class, (String)name);
        }

        private Dummy() {
            super((String)string, n);
        }

        static {
            $VALUES = new Dummy[]{VALUE};
        }
    }
}

