/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.collect;

import io.logz.sender.com.google.common.annotations.GwtCompatible;
import io.logz.sender.com.google.common.base.Preconditions;
import io.logz.sender.com.google.common.collect.Ordering;
import io.logz.sender.com.google.common.collect.ReverseNaturalOrdering;
import io.logz.sender.java.io.Serializable;
import io.logz.sender.java.lang.Comparable;
import io.logz.sender.java.lang.String;
import io.logz.sender.org.checkerframework.checker.nullness.compatqual.MonotonicNonNullDecl;

@GwtCompatible(serializable=true)
final class NaturalOrdering
extends Ordering<Comparable>
implements Serializable {
    static final NaturalOrdering INSTANCE = new NaturalOrdering();
    @MonotonicNonNullDecl
    private transient Ordering<Comparable> nullsFirst;
    @MonotonicNonNullDecl
    private transient Ordering<Comparable> nullsLast;
    private static final long serialVersionUID = 0L;

    @Override
    public int compare(Comparable left, Comparable right) {
        Preconditions.checkNotNull(left);
        Preconditions.checkNotNull(right);
        return left.compareTo((io.logz.sender.java.lang.Object)right);
    }

    @Override
    public <S extends Comparable> Ordering<S> nullsFirst() {
        Ordering<Object> result = this.nullsFirst;
        if (result == null) {
            result = this.nullsFirst = super.nullsFirst();
        }
        return result;
    }

    @Override
    public <S extends Comparable> Ordering<S> nullsLast() {
        Ordering<Object> result = this.nullsLast;
        if (result == null) {
            result = this.nullsLast = super.nullsLast();
        }
        return result;
    }

    @Override
    public <S extends Comparable> Ordering<S> reverse() {
        return ReverseNaturalOrdering.INSTANCE;
    }

    private io.logz.sender.java.lang.Object readResolve() {
        return INSTANCE;
    }

    public String toString() {
        return "io.logz.sender.Ordering.natural()";
    }

    private NaturalOrdering() {
    }
}

