/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.collect;

import io.logz.sender.com.google.common.annotations.GwtCompatible;
import io.logz.sender.com.google.common.annotations.GwtIncompatible;
import io.logz.sender.com.google.common.base.Preconditions;
import io.logz.sender.com.google.common.collect.Platform;
import io.logz.sender.com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.logz.sender.java.lang.Class;
import io.logz.sender.java.lang.Iterable;
import io.logz.sender.java.lang.NullPointerException;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.lang.StringBuilder;
import io.logz.sender.java.lang.System;
import io.logz.sender.java.lang.reflect.Array;
import io.logz.sender.java.util.Arrays;
import io.logz.sender.java.util.Collection;
import io.logz.sender.org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible(emulated=true)
public final class ObjectArrays
extends io.logz.sender.java.lang.Object {
    private ObjectArrays() {
    }

    @GwtIncompatible
    public static <T extends io.logz.sender.java.lang.Object> T[] newArray(Class<T> type, int length) {
        return (io.logz.sender.java.lang.Object[])Array.newInstance(type, (int)length);
    }

    public static <T extends io.logz.sender.java.lang.Object> T[] newArray(T[] reference, int length) {
        return Platform.newArray(reference, (int)length);
    }

    @GwtIncompatible
    public static <T extends io.logz.sender.java.lang.Object> T[] concat(T[] first, T[] second, Class<T> type) {
        io.logz.sender.java.lang.Object[] result = ObjectArrays.newArray(type, (int)(first.length + second.length));
        System.arraycopy(first, (int)0, (io.logz.sender.java.lang.Object)result, (int)0, (int)first.length);
        System.arraycopy(second, (int)0, (io.logz.sender.java.lang.Object)result, (int)first.length, (int)second.length);
        return result;
    }

    public static <T extends io.logz.sender.java.lang.Object> T[] concat(@NullableDecl T element, T[] array) {
        io.logz.sender.java.lang.Object[] result = ObjectArrays.newArray(array, (int)(array.length + 1));
        result[0] = element;
        System.arraycopy(array, (int)0, (io.logz.sender.java.lang.Object)result, (int)1, (int)array.length);
        return result;
    }

    public static <T extends io.logz.sender.java.lang.Object> T[] concat(T[] array, @NullableDecl T element) {
        io.logz.sender.java.lang.Object[] result = Arrays.copyOf(array, (int)(array.length + 1));
        result[array.length] = element;
        return result;
    }

    static <T extends io.logz.sender.java.lang.Object> T[] toArrayImpl(Collection<?> c, T[] array) {
        int size = c.size();
        if (array.length < size) {
            array = ObjectArrays.newArray(array, (int)size);
        }
        ObjectArrays.fillArray(c, array);
        if (array.length > size) {
            array[size] = null;
        }
        return array;
    }

    static <T extends io.logz.sender.java.lang.Object> T[] toArrayImpl(io.logz.sender.java.lang.Object[] src, int offset, int len, T[] dst) {
        Preconditions.checkPositionIndexes(offset, offset + len, src.length);
        if (dst.length < len) {
            dst = ObjectArrays.newArray(dst, (int)len);
        } else if (dst.length > len) {
            dst[len] = null;
        }
        System.arraycopy((io.logz.sender.java.lang.Object)src, (int)offset, dst, (int)0, (int)len);
        return dst;
    }

    static io.logz.sender.java.lang.Object[] toArrayImpl(Collection<?> c) {
        return ObjectArrays.fillArray(c, new io.logz.sender.java.lang.Object[c.size()]);
    }

    static io.logz.sender.java.lang.Object[] copyAsObjectArray(io.logz.sender.java.lang.Object[] elements, int offset, int length) {
        Preconditions.checkPositionIndexes(offset, offset + length, elements.length);
        if (length == 0) {
            return new io.logz.sender.java.lang.Object[0];
        }
        io.logz.sender.java.lang.Object[] result = new io.logz.sender.java.lang.Object[length];
        System.arraycopy((io.logz.sender.java.lang.Object)elements, (int)offset, (io.logz.sender.java.lang.Object)result, (int)0, (int)length);
        return result;
    }

    @CanIgnoreReturnValue
    private static io.logz.sender.java.lang.Object[] fillArray(Iterable<?> elements, io.logz.sender.java.lang.Object[] array) {
        int i = 0;
        for (io.logz.sender.java.lang.Object element : elements) {
            array[i++] = element;
        }
        return array;
    }

    static void swap(io.logz.sender.java.lang.Object[] array, int i, int j) {
        io.logz.sender.java.lang.Object temp = array[i];
        array[i] = array[j];
        array[j] = temp;
    }

    @CanIgnoreReturnValue
    static io.logz.sender.java.lang.Object[] checkElementsNotNull(io.logz.sender.java.lang.Object ... array) {
        return ObjectArrays.checkElementsNotNull(array, array.length);
    }

    @CanIgnoreReturnValue
    static io.logz.sender.java.lang.Object[] checkElementsNotNull(io.logz.sender.java.lang.Object[] array, int length) {
        for (int i = 0; i < length; ++i) {
            ObjectArrays.checkElementNotNull(array[i], i);
        }
        return array;
    }

    @CanIgnoreReturnValue
    static io.logz.sender.java.lang.Object checkElementNotNull(io.logz.sender.java.lang.Object element, int index) {
        if (element == null) {
            throw new NullPointerException(new StringBuilder().append((String)"io.logz.sender.at index ").append(index).toString());
        }
        return element;
    }
}

