/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.collect;

import io.logz.sender.com.google.common.annotations.GwtIncompatible;
import io.logz.sender.com.google.common.collect.Multimap;
import io.logz.sender.com.google.common.collect.Multiset;
import io.logz.sender.java.io.IOException;
import io.logz.sender.java.io.ObjectInputStream;
import io.logz.sender.java.io.ObjectOutputStream;
import io.logz.sender.java.lang.AssertionError;
import io.logz.sender.java.lang.Class;
import io.logz.sender.java.lang.ClassNotFoundException;
import io.logz.sender.java.lang.IllegalAccessException;
import io.logz.sender.java.lang.Integer;
import io.logz.sender.java.lang.NoSuchFieldException;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.lang.reflect.Field;
import io.logz.sender.java.util.Collection;
import io.logz.sender.java.util.Map;

@GwtIncompatible
final class Serialization
extends io.logz.sender.java.lang.Object {
    private Serialization() {
    }

    static int readCount(ObjectInputStream stream) throws IOException {
        return stream.readInt();
    }

    static <K extends io.logz.sender.java.lang.Object, V extends io.logz.sender.java.lang.Object> void writeMap(Map<K, V> map, ObjectOutputStream stream) throws IOException {
        stream.writeInt(map.size());
        for (Map.Entry entry : map.entrySet()) {
            stream.writeObject(entry.getKey());
            stream.writeObject(entry.getValue());
        }
    }

    static <K extends io.logz.sender.java.lang.Object, V extends io.logz.sender.java.lang.Object> void populateMap(Map<K, V> map, ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int size = stream.readInt();
        Serialization.populateMap(map, stream, size);
    }

    static <K extends io.logz.sender.java.lang.Object, V extends io.logz.sender.java.lang.Object> void populateMap(Map<K, V> map, ObjectInputStream stream, int size) throws IOException, ClassNotFoundException {
        for (int i = 0; i < size; ++i) {
            io.logz.sender.java.lang.Object key = stream.readObject();
            io.logz.sender.java.lang.Object value = stream.readObject();
            map.put(key, value);
        }
    }

    static <E extends io.logz.sender.java.lang.Object> void writeMultiset(Multiset<E> multiset, ObjectOutputStream stream) throws IOException {
        int entryCount = multiset.entrySet().size();
        stream.writeInt(entryCount);
        for (Multiset.Entry entry : multiset.entrySet()) {
            stream.writeObject(entry.getElement());
            stream.writeInt(entry.getCount());
        }
    }

    static <E extends io.logz.sender.java.lang.Object> void populateMultiset(Multiset<E> multiset, ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int distinctElements = stream.readInt();
        Serialization.populateMultiset(multiset, stream, distinctElements);
    }

    static <E extends io.logz.sender.java.lang.Object> void populateMultiset(Multiset<E> multiset, ObjectInputStream stream, int distinctElements) throws IOException, ClassNotFoundException {
        for (int i = 0; i < distinctElements; ++i) {
            io.logz.sender.java.lang.Object element = stream.readObject();
            int count = stream.readInt();
            multiset.add(element, count);
        }
    }

    static <K extends io.logz.sender.java.lang.Object, V extends io.logz.sender.java.lang.Object> void writeMultimap(Multimap<K, V> multimap, ObjectOutputStream stream) throws IOException {
        stream.writeInt(multimap.asMap().size());
        for (Map.Entry entry : multimap.asMap().entrySet()) {
            stream.writeObject(entry.getKey());
            stream.writeInt(((Collection)entry.getValue()).size());
            for (io.logz.sender.java.lang.Object value : (Collection)entry.getValue()) {
                stream.writeObject(value);
            }
        }
    }

    static <K extends io.logz.sender.java.lang.Object, V extends io.logz.sender.java.lang.Object> void populateMultimap(Multimap<K, V> multimap, ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int distinctKeys = stream.readInt();
        Serialization.populateMultimap(multimap, stream, distinctKeys);
    }

    static <K extends io.logz.sender.java.lang.Object, V extends io.logz.sender.java.lang.Object> void populateMultimap(Multimap<K, V> multimap, ObjectInputStream stream, int distinctKeys) throws IOException, ClassNotFoundException {
        for (int i = 0; i < distinctKeys; ++i) {
            io.logz.sender.java.lang.Object key = stream.readObject();
            Collection<V> values = multimap.get(key);
            int valueCount = stream.readInt();
            for (int j = 0; j < valueCount; ++j) {
                io.logz.sender.java.lang.Object value = stream.readObject();
                values.add(value);
            }
        }
    }

    static <T extends io.logz.sender.java.lang.Object> FieldSetter<T> getFieldSetter(Class<T> clazz, String fieldName) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            return new FieldSetter(field);
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((io.logz.sender.java.lang.Object)e);
        }
    }

    static final class FieldSetter<T extends io.logz.sender.java.lang.Object>
    extends io.logz.sender.java.lang.Object {
        private final Field field;

        private FieldSetter(Field field) {
            this.field = field;
            field.setAccessible(true);
        }

        void set(T instance, io.logz.sender.java.lang.Object value) {
            try {
                this.field.set(instance, value);
            }
            catch (IllegalAccessException impossible) {
                throw new AssertionError((io.logz.sender.java.lang.Object)impossible);
            }
        }

        void set(T instance, int value) {
            try {
                this.field.set(instance, (io.logz.sender.java.lang.Object)Integer.valueOf((int)value));
            }
            catch (IllegalAccessException impossible) {
                throw new AssertionError((io.logz.sender.java.lang.Object)impossible);
            }
        }
    }
}

