/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.collect;

import io.logz.sender.com.google.common.annotations.GwtCompatible;
import io.logz.sender.com.google.common.base.Preconditions;
import io.logz.sender.com.google.common.collect.ImmutableList;
import io.logz.sender.com.google.common.collect.Iterators;
import io.logz.sender.com.google.common.collect.UnmodifiableIterator;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.lang.StringBuilder;
import io.logz.sender.java.util.Collections;
import io.logz.sender.java.util.Spliterator;

@GwtCompatible(serializable=true, emulated=true)
final class SingletonImmutableList<E extends io.logz.sender.java.lang.Object>
extends ImmutableList<E> {
    final transient E element;

    SingletonImmutableList(E element) {
        this.element = Preconditions.checkNotNull(element);
    }

    public E get(int index) {
        Preconditions.checkElementIndex(index, 1);
        return this.element;
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return Iterators.singletonIterator(this.element);
    }

    @Override
    public Spliterator<E> spliterator() {
        return Collections.singleton(this.element).spliterator();
    }

    public int size() {
        return 1;
    }

    @Override
    public ImmutableList<E> subList(int fromIndex, int toIndex) {
        Preconditions.checkPositionIndexes(fromIndex, toIndex, 1);
        return fromIndex == toIndex ? ImmutableList.of() : this;
    }

    public String toString() {
        return new StringBuilder().append('[').append(this.element.toString()).append(']').toString();
    }

    @Override
    boolean isPartialView() {
        return false;
    }
}

