/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.primitives;

import io.logz.sender.com.google.common.annotations.GwtCompatible;
import io.logz.sender.java.lang.NumberFormatException;
import io.logz.sender.java.lang.String;

@GwtCompatible
final class ParseRequest
extends io.logz.sender.java.lang.Object {
    final String rawValue;
    final int radix;

    private ParseRequest(String rawValue, int radix) {
        this.rawValue = rawValue;
        this.radix = radix;
    }

    static ParseRequest fromString(String stringValue) {
        int radix;
        String rawValue;
        if (stringValue.length() == 0) {
            throw new NumberFormatException((String)"io.logz.sender.empty string");
        }
        char firstChar = stringValue.charAt(0);
        if (stringValue.startsWith((String)"io.logz.sender.0x") || stringValue.startsWith((String)"io.logz.sender.0X")) {
            rawValue = stringValue.substring(2);
            radix = 16;
        } else if (firstChar == '#') {
            rawValue = stringValue.substring(1);
            radix = 16;
        } else if (firstChar == '0' && stringValue.length() > 1) {
            rawValue = stringValue.substring(1);
            radix = 8;
        } else {
            rawValue = stringValue;
            radix = 10;
        }
        return new ParseRequest(rawValue, radix);
    }
}

