/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.util.concurrent;

import io.logz.sender.com.google.common.annotations.GwtCompatible;
import io.logz.sender.com.google.common.base.Function;
import io.logz.sender.com.google.common.base.Preconditions;
import io.logz.sender.com.google.common.util.concurrent.AbstractFuture;
import io.logz.sender.com.google.common.util.concurrent.AsyncFunction;
import io.logz.sender.com.google.common.util.concurrent.Futures;
import io.logz.sender.com.google.common.util.concurrent.ListenableFuture;
import io.logz.sender.com.google.common.util.concurrent.MoreExecutors;
import io.logz.sender.com.google.errorprone.annotations.ForOverride;
import io.logz.sender.java.lang.Error;
import io.logz.sender.java.lang.Exception;
import io.logz.sender.java.lang.Runnable;
import io.logz.sender.java.lang.RuntimeException;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.lang.StringBuilder;
import io.logz.sender.java.lang.Throwable;
import io.logz.sender.java.lang.reflect.UndeclaredThrowableException;
import io.logz.sender.java.util.concurrent.CancellationException;
import io.logz.sender.java.util.concurrent.ExecutionException;
import io.logz.sender.java.util.concurrent.Executor;
import io.logz.sender.org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible
abstract class AbstractTransformFuture<I extends io.logz.sender.java.lang.Object, O extends io.logz.sender.java.lang.Object, F extends io.logz.sender.java.lang.Object, T extends io.logz.sender.java.lang.Object>
extends AbstractFuture.TrustedFuture<O>
implements Runnable {
    @NullableDecl
    ListenableFuture<? extends I> inputFuture;
    @NullableDecl
    F function;

    static <I extends io.logz.sender.java.lang.Object, O extends io.logz.sender.java.lang.Object> ListenableFuture<O> create(ListenableFuture<I> input, AsyncFunction<? super I, ? extends O> function, Executor executor) {
        Preconditions.checkNotNull(executor);
        AsyncTransformFuture<? super I, ? extends O> output = new AsyncTransformFuture<I, O>(input, function);
        input.addListener(output, MoreExecutors.rejectionPropagatingExecutor(executor, output));
        return output;
    }

    static <I extends io.logz.sender.java.lang.Object, O extends io.logz.sender.java.lang.Object> ListenableFuture<O> create(ListenableFuture<I> input, Function<? super I, ? extends O> function, Executor executor) {
        Preconditions.checkNotNull(function);
        TransformFuture<? super I, ? extends O> output = new TransformFuture<I, O>(input, function);
        input.addListener(output, MoreExecutors.rejectionPropagatingExecutor(executor, output));
        return output;
    }

    AbstractTransformFuture(ListenableFuture<? extends I> inputFuture, F function) {
        this.inputFuture = Preconditions.checkNotNull(inputFuture);
        this.function = Preconditions.checkNotNull(function);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        T transformResult;
        I sourceResult;
        ListenableFuture<? extends I> localInputFuture = this.inputFuture;
        F localFunction = this.function;
        if (this.isCancelled() | localInputFuture == null | localFunction == null) {
            return;
        }
        this.inputFuture = null;
        try {
            sourceResult = Futures.getDone(localInputFuture);
        }
        catch (CancellationException e) {
            this.cancel(false);
            return;
        }
        catch (ExecutionException e) {
            this.setException(e.getCause());
            return;
        }
        catch (RuntimeException e) {
            this.setException((Throwable)((Object)e));
            return;
        }
        catch (Error e) {
            this.setException((Throwable)((Object)e));
            return;
        }
        try {
            transformResult = this.doTransform(localFunction, sourceResult);
        }
        catch (UndeclaredThrowableException e) {
            this.setException(e.getCause());
            return;
        }
        catch (Throwable t) {
            this.setException(t);
            return;
        }
        finally {
            this.function = null;
        }
        this.setResult(transformResult);
    }

    @NullableDecl
    @ForOverride
    abstract T doTransform(F var1, @NullableDecl I var2) throws Exception;

    @ForOverride
    abstract void setResult(@NullableDecl T var1);

    @Override
    protected final void afterDone() {
        this.maybePropagateCancellationTo(this.inputFuture);
        this.inputFuture = null;
        this.function = null;
    }

    @Override
    protected String pendingToString() {
        ListenableFuture<? extends I> localInputFuture = this.inputFuture;
        F localFunction = this.function;
        String superString = super.pendingToString();
        java.lang.String resultString = "io.logz.sender.";
        if (localInputFuture != null) {
            resultString = new StringBuilder().append((String)"io.logz.sender.inputFuture=[").append(localInputFuture).append((String)"io.logz.sender.], ").toString();
        }
        if (localFunction != null) {
            return new StringBuilder().append((String)resultString).append((String)"io.logz.sender.function=[").append(localFunction).append((String)"io.logz.sender.]").toString();
        }
        if (superString != null) {
            return new StringBuilder().append((String)resultString).append(superString).toString();
        }
        return null;
    }

    private static final class TransformFuture<I extends io.logz.sender.java.lang.Object, O extends io.logz.sender.java.lang.Object>
    extends AbstractTransformFuture<I, O, Function<? super I, ? extends O>, O> {
        TransformFuture(ListenableFuture<? extends I> inputFuture, Function<? super I, ? extends O> function) {
            super(inputFuture, function);
        }

        @Override
        @NullableDecl
        O doTransform(Function<? super I, ? extends O> function, @NullableDecl I input) {
            return function.apply(input);
        }

        @Override
        void setResult(@NullableDecl O result) {
            this.set(result);
        }
    }

    private static final class AsyncTransformFuture<I extends io.logz.sender.java.lang.Object, O extends io.logz.sender.java.lang.Object>
    extends AbstractTransformFuture<I, O, AsyncFunction<? super I, ? extends O>, ListenableFuture<? extends O>> {
        AsyncTransformFuture(ListenableFuture<? extends I> inputFuture, AsyncFunction<? super I, ? extends O> function) {
            super(inputFuture, function);
        }

        @Override
        ListenableFuture<? extends O> doTransform(AsyncFunction<? super I, ? extends O> function, @NullableDecl I input) throws Exception {
            ListenableFuture<? extends O> outputFuture = function.apply(input);
            Preconditions.checkNotNull(outputFuture, (io.logz.sender.java.lang.Object)"io.logz.sender.AsyncFunction.apply returned null instead of a Future. Did you mean to return immediateFuture(null)?");
            return outputFuture;
        }

        @Override
        void setResult(ListenableFuture<? extends O> result) {
            this.setFuture(result);
        }
    }
}

