/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.util.concurrent;

import io.logz.sender.com.google.common.annotations.GwtCompatible;
import io.logz.sender.com.google.common.base.Preconditions;
import io.logz.sender.com.google.common.collect.ImmutableCollection;
import io.logz.sender.com.google.common.util.concurrent.AbstractFuture;
import io.logz.sender.com.google.common.util.concurrent.AggregateFutureState;
import io.logz.sender.com.google.common.util.concurrent.Futures;
import io.logz.sender.com.google.common.util.concurrent.ListenableFuture;
import io.logz.sender.com.google.common.util.concurrent.MoreExecutors;
import io.logz.sender.com.google.errorprone.annotations.ForOverride;
import io.logz.sender.com.google.errorprone.annotations.OverridingMethodsMustInvokeSuper;
import io.logz.sender.java.lang.Error;
import io.logz.sender.java.lang.Runnable;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.lang.StringBuilder;
import io.logz.sender.java.lang.Throwable;
import io.logz.sender.java.util.Iterator;
import io.logz.sender.java.util.Set;
import io.logz.sender.java.util.concurrent.ExecutionException;
import io.logz.sender.java.util.concurrent.Future;
import io.logz.sender.java.util.logging.Level;
import io.logz.sender.java.util.logging.Logger;
import io.logz.sender.org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible
abstract class AggregateFuture<InputT extends io.logz.sender.java.lang.Object, OutputT extends io.logz.sender.java.lang.Object>
extends AbstractFuture.TrustedFuture<OutputT> {
    private static final Logger logger = Logger.getLogger((String)AggregateFuture.class.getName());
    @NullableDecl
    private RunningState runningState;

    AggregateFuture() {
    }

    @Override
    protected final void afterDone() {
        super.afterDone();
        RunningState localRunningState = this.runningState;
        if (localRunningState != null) {
            this.runningState = null;
            ImmutableCollection futures = localRunningState.futures;
            boolean wasInterrupted = this.wasInterrupted();
            if (wasInterrupted) {
                localRunningState.interruptTask();
            }
            if (this.isCancelled() & futures != null) {
                Iterator iterator = futures.iterator();
                while (iterator.hasNext()) {
                    ListenableFuture future = (ListenableFuture)iterator.next();
                    future.cancel(wasInterrupted);
                }
            }
        }
    }

    @Override
    protected String pendingToString() {
        RunningState localRunningState = this.runningState;
        if (localRunningState == null) {
            return null;
        }
        ImmutableCollection localFutures = localRunningState.futures;
        if (localFutures != null) {
            return new StringBuilder().append((String)"io.logz.sender.futures=[").append((io.logz.sender.java.lang.Object)localFutures).append((String)"io.logz.sender.]").toString();
        }
        return null;
    }

    final void init(RunningState runningState) {
        this.runningState = runningState;
        runningState.init();
    }

    private static boolean addCausalChain(Set<Throwable> seen, Throwable t) {
        while (t != null) {
            boolean firstTimeSeen = seen.add((io.logz.sender.java.lang.Object)t);
            if (!firstTimeSeen) {
                return false;
            }
            t = t.getCause();
        }
        return true;
    }

    abstract class RunningState
    extends AggregateFutureState
    implements Runnable {
        private ImmutableCollection<? extends ListenableFuture<? extends InputT>> futures;
        private final boolean allMustSucceed;
        private final boolean collectsValues;

        RunningState(ImmutableCollection<? extends ListenableFuture<? extends InputT>> futures, boolean allMustSucceed, boolean collectsValues) {
            super(futures.size());
            this.futures = Preconditions.checkNotNull(futures);
            this.allMustSucceed = allMustSucceed;
            this.collectsValues = collectsValues;
        }

        public final void run() {
            this.decrementCountAndMaybeComplete();
        }

        private void init() {
            if (this.futures.isEmpty()) {
                this.handleAllCompleted();
                return;
            }
            if (this.allMustSucceed) {
                int i = 0;
                Iterator iterator = this.futures.iterator();
                while (iterator.hasNext()) {
                    final ListenableFuture listenable = (ListenableFuture)iterator.next();
                    final int index = i++;
                    listenable.addListener(new Runnable(){

                        public void run() {
                            try {
                                RunningState.this.handleOneInputDone(index, listenable);
                            }
                            finally {
                                RunningState.this.decrementCountAndMaybeComplete();
                            }
                        }
                    }, MoreExecutors.directExecutor());
                }
            } else {
                Iterator iterator = this.futures.iterator();
                while (iterator.hasNext()) {
                    ListenableFuture listenable = (ListenableFuture)iterator.next();
                    listenable.addListener(this, MoreExecutors.directExecutor());
                }
            }
        }

        private void handleException(Throwable throwable) {
            Preconditions.checkNotNull(throwable);
            boolean completedWithFailure = false;
            boolean firstTimeSeeingThisException = true;
            if (this.allMustSucceed) {
                completedWithFailure = AggregateFuture.this.setException(throwable);
                if (completedWithFailure) {
                    this.releaseResourcesAfterFailure();
                } else {
                    firstTimeSeeingThisException = AggregateFuture.addCausalChain((Set<Throwable>)this.getOrInitSeenExceptions(), throwable);
                }
            }
            if (throwable instanceof Error | this.allMustSucceed & !completedWithFailure & firstTimeSeeingThisException) {
                java.lang.String message = throwable instanceof Error ? "io.logz.sender.Input Future failed with Error" : "io.logz.sender.Got more than one input Future failure. Logging failures after the first";
                logger.log(Level.SEVERE, (String)message, throwable);
            }
        }

        @Override
        final void addInitialException(Set<Throwable> seen) {
            if (!AggregateFuture.this.isCancelled()) {
                boolean bl = AggregateFuture.addCausalChain((Set<Throwable>)seen, AggregateFuture.this.trustedGetException());
            }
        }

        private void handleOneInputDone(int index, Future<? extends InputT> future) {
            Preconditions.checkState(this.allMustSucceed || !AggregateFuture.this.isDone() || AggregateFuture.this.isCancelled(), (io.logz.sender.java.lang.Object)"io.logz.sender.Future was done before all dependencies completed");
            try {
                Preconditions.checkState(future.isDone(), (io.logz.sender.java.lang.Object)"io.logz.sender.Tried to set value from future which is not done");
                if (this.allMustSucceed) {
                    if (future.isCancelled()) {
                        AggregateFuture.this.runningState = null;
                        AggregateFuture.this.cancel(false);
                    } else {
                        Object result = Futures.getDone(future);
                        if (this.collectsValues) {
                            this.collectOneValue(this.allMustSucceed, index, result);
                        }
                    }
                } else if (this.collectsValues && !future.isCancelled()) {
                    this.collectOneValue(this.allMustSucceed, index, Futures.getDone(future));
                }
            }
            catch (ExecutionException e) {
                this.handleException(e.getCause());
            }
            catch (Throwable t) {
                this.handleException(t);
            }
        }

        private void decrementCountAndMaybeComplete() {
            int newRemaining = this.decrementRemainingAndGet();
            Preconditions.checkState(newRemaining >= 0, (io.logz.sender.java.lang.Object)"io.logz.sender.Less than 0 remaining futures");
            if (newRemaining == 0) {
                this.processCompleted();
            }
        }

        private void processCompleted() {
            if (this.collectsValues & !this.allMustSucceed) {
                int i = 0;
                Iterator iterator = this.futures.iterator();
                while (iterator.hasNext()) {
                    ListenableFuture listenable = (ListenableFuture)iterator.next();
                    this.handleOneInputDone(i++, listenable);
                }
            }
            this.handleAllCompleted();
        }

        @ForOverride
        @OverridingMethodsMustInvokeSuper
        void releaseResourcesAfterFailure() {
            this.futures = null;
        }

        abstract void collectOneValue(boolean var1, int var2, @NullableDecl InputT var3);

        abstract void handleAllCompleted();

        void interruptTask() {
        }
    }
}

