/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.util.concurrent;

import io.logz.sender.com.google.common.annotations.Beta;
import io.logz.sender.com.google.common.annotations.GwtCompatible;
import io.logz.sender.com.google.common.annotations.GwtIncompatible;
import io.logz.sender.com.google.common.base.Preconditions;
import io.logz.sender.com.google.common.base.Supplier;
import io.logz.sender.com.google.common.util.concurrent.AsyncCallable;
import io.logz.sender.com.google.common.util.concurrent.ListenableFuture;
import io.logz.sender.com.google.common.util.concurrent.ListeningExecutorService;
import io.logz.sender.java.lang.Exception;
import io.logz.sender.java.lang.Runnable;
import io.logz.sender.java.lang.SecurityException;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.lang.Thread;
import io.logz.sender.java.util.concurrent.Callable;
import io.logz.sender.org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible(emulated=true)
public final class Callables
extends io.logz.sender.java.lang.Object {
    private Callables() {
    }

    public static <T extends io.logz.sender.java.lang.Object> Callable<T> returning(final @NullableDecl T value) {
        return new Callable<T>(){

            public T call() {
                return value;
            }
        };
    }

    @Beta
    @GwtIncompatible
    public static <T extends io.logz.sender.java.lang.Object> AsyncCallable<T> asAsyncCallable(final Callable<T> callable, final ListeningExecutorService listeningExecutorService) {
        Preconditions.checkNotNull(callable);
        Preconditions.checkNotNull(listeningExecutorService);
        return new AsyncCallable<T>(){

            @Override
            public ListenableFuture<T> call() throws Exception {
                return listeningExecutorService.submit(callable);
            }
        };
    }

    @GwtIncompatible
    static <T extends io.logz.sender.java.lang.Object> Callable<T> threadRenaming(final Callable<T> callable, final Supplier<String> nameSupplier) {
        Preconditions.checkNotNull(nameSupplier);
        Preconditions.checkNotNull(callable);
        return new Callable<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public T call() throws Exception {
                Thread currentThread = Thread.currentThread();
                String oldName = currentThread.getName();
                boolean restoreName = Callables.trySetName((String)nameSupplier.get(), currentThread);
                try {
                    io.logz.sender.java.lang.Object object = callable.call();
                    return object;
                }
                finally {
                    if (restoreName) {
                        boolean bl = Callables.trySetName(oldName, currentThread);
                    }
                }
            }
        };
    }

    @GwtIncompatible
    static Runnable threadRenaming(final Runnable task, final Supplier<String> nameSupplier) {
        Preconditions.checkNotNull(nameSupplier);
        Preconditions.checkNotNull(task);
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Thread currentThread = Thread.currentThread();
                String oldName = currentThread.getName();
                boolean restoreName = Callables.trySetName((String)nameSupplier.get(), currentThread);
                try {
                    task.run();
                }
                finally {
                    if (restoreName) {
                        boolean bl = Callables.trySetName(oldName, currentThread);
                    }
                }
            }
        };
    }

    @GwtIncompatible
    private static boolean trySetName(String threadName, Thread currentThread) {
        try {
            currentThread.setName(threadName);
            return true;
        }
        catch (SecurityException e) {
            return false;
        }
    }
}

