/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.util.concurrent;

import io.logz.sender.com.google.common.annotations.GwtIncompatible;
import io.logz.sender.com.google.common.annotations.VisibleForTesting;
import io.logz.sender.com.google.common.base.Function;
import io.logz.sender.com.google.common.base.Preconditions;
import io.logz.sender.com.google.common.collect.Ordering;
import io.logz.sender.com.google.common.util.concurrent.ExecutionError;
import io.logz.sender.com.google.common.util.concurrent.UncheckedExecutionException;
import io.logz.sender.com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.logz.sender.java.lang.AssertionError;
import io.logz.sender.java.lang.Boolean;
import io.logz.sender.java.lang.Class;
import io.logz.sender.java.lang.ClassValue;
import io.logz.sender.java.lang.Enum;
import io.logz.sender.java.lang.Error;
import io.logz.sender.java.lang.Exception;
import io.logz.sender.java.lang.IllegalAccessException;
import io.logz.sender.java.lang.IllegalArgumentException;
import io.logz.sender.java.lang.InstantiationException;
import io.logz.sender.java.lang.InterruptedException;
import io.logz.sender.java.lang.RuntimeException;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.lang.StringBuilder;
import io.logz.sender.java.lang.Thread;
import io.logz.sender.java.lang.Throwable;
import io.logz.sender.java.lang.ref.WeakReference;
import io.logz.sender.java.lang.reflect.Constructor;
import io.logz.sender.java.lang.reflect.InvocationTargetException;
import io.logz.sender.java.util.Arrays;
import io.logz.sender.java.util.List;
import io.logz.sender.java.util.Set;
import io.logz.sender.java.util.concurrent.CopyOnWriteArraySet;
import io.logz.sender.java.util.concurrent.ExecutionException;
import io.logz.sender.java.util.concurrent.Future;
import io.logz.sender.java.util.concurrent.TimeUnit;
import io.logz.sender.java.util.concurrent.TimeoutException;
import io.logz.sender.org.checkerframework.checker.nullness.compatqual.NullableDecl;
import io.logz.sender.org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

@GwtIncompatible
final class FuturesGetChecked
extends io.logz.sender.java.lang.Object {
    private static final Ordering<Constructor<?>> WITH_STRING_PARAM_FIRST = Ordering.natural().onResultOf(new Function<Constructor<?>, Boolean>(){

        @Override
        public Boolean apply(Constructor<?> input) {
            return Boolean.valueOf((boolean)Arrays.asList((io.logz.sender.java.lang.Object[])input.getParameterTypes()).contains(String.class));
        }
    }).reverse();

    @CanIgnoreReturnValue
    static <V extends io.logz.sender.java.lang.Object, X extends Exception> V getChecked(Future<V> future, Class<X> exceptionClass) throws X {
        return FuturesGetChecked.getChecked(FuturesGetChecked.bestGetCheckedTypeValidator(), future, exceptionClass);
    }

    @CanIgnoreReturnValue
    @VisibleForTesting
    static <V extends io.logz.sender.java.lang.Object, X extends Exception> V getChecked(GetCheckedTypeValidator validator, Future<V> future, Class<X> exceptionClass) throws X {
        validator.validateClass(exceptionClass);
        try {
            return (V)future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw FuturesGetChecked.newWithCause(exceptionClass, (Throwable)((Object)e));
        }
        catch (ExecutionException e) {
            FuturesGetChecked.wrapAndThrowExceptionOrError(e.getCause(), exceptionClass);
            throw new AssertionError();
        }
    }

    @CanIgnoreReturnValue
    static <V extends io.logz.sender.java.lang.Object, X extends Exception> V getChecked(Future<V> future, Class<X> exceptionClass, long timeout, TimeUnit unit) throws X {
        FuturesGetChecked.bestGetCheckedTypeValidator().validateClass(exceptionClass);
        try {
            return (V)future.get(timeout, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw FuturesGetChecked.newWithCause(exceptionClass, (Throwable)((Object)e));
        }
        catch (TimeoutException e) {
            throw FuturesGetChecked.newWithCause(exceptionClass, (Throwable)((Object)e));
        }
        catch (ExecutionException e) {
            FuturesGetChecked.wrapAndThrowExceptionOrError(e.getCause(), exceptionClass);
            throw new AssertionError();
        }
    }

    private static GetCheckedTypeValidator bestGetCheckedTypeValidator() {
        return GetCheckedTypeValidatorHolder.BEST_VALIDATOR;
    }

    @VisibleForTesting
    static GetCheckedTypeValidator weakSetValidator() {
        return GetCheckedTypeValidatorHolder.WeakSetValidator.INSTANCE;
    }

    @VisibleForTesting
    static GetCheckedTypeValidator classValueValidator() {
        return GetCheckedTypeValidatorHolder.ClassValueValidator.INSTANCE;
    }

    private static <X extends Exception> void wrapAndThrowExceptionOrError(Throwable cause, Class<X> exceptionClass) throws X {
        if (cause instanceof Error) {
            throw new ExecutionError((Error)((Object)cause));
        }
        if (cause instanceof RuntimeException) {
            throw new UncheckedExecutionException(cause);
        }
        throw FuturesGetChecked.newWithCause(exceptionClass, cause);
    }

    private static boolean hasConstructorUsableByGetChecked(Class<? extends Exception> exceptionClass) {
        try {
            Exception unused = FuturesGetChecked.newWithCause(exceptionClass, (Throwable)((Object)new Exception()));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static <X extends Exception> X newWithCause(Class<X> exceptionClass, Throwable cause) {
        List constructors = Arrays.asList((io.logz.sender.java.lang.Object[])exceptionClass.getConstructors());
        for (Constructor constructor : FuturesGetChecked.preferringStrings(constructors)) {
            Exception instance = (Exception)((Object)FuturesGetChecked.newFromConstructor(constructor, cause));
            if (instance == null) continue;
            if (instance.getCause() == null) {
                instance.initCause(cause);
            }
            return (X)((Object)instance);
        }
        throw new IllegalArgumentException(new StringBuilder().append((String)"io.logz.sender.No appropriate constructor for exception of type ").append(exceptionClass).append((String)"io.logz.sender. in response to chained exception").toString(), cause);
    }

    private static <X extends Exception> List<Constructor<X>> preferringStrings(List<Constructor<X>> constructors) {
        return WITH_STRING_PARAM_FIRST.sortedCopy(constructors);
    }

    @NullableDecl
    private static <X extends io.logz.sender.java.lang.Object> X newFromConstructor(Constructor<X> constructor, Throwable cause) {
        Class[] paramTypes = constructor.getParameterTypes();
        io.logz.sender.java.lang.Object[] params = new io.logz.sender.java.lang.Object[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            Class paramType = paramTypes[i];
            if (paramType.equals(String.class)) {
                params[i] = cause.toString();
                continue;
            }
            if (paramType.equals(Throwable.class)) {
                params[i] = cause;
                continue;
            }
            return null;
        }
        try {
            return (X)constructor.newInstance(params);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            return null;
        }
    }

    @VisibleForTesting
    static boolean isCheckedException(Class<? extends Exception> type) {
        return !RuntimeException.class.isAssignableFrom(type);
    }

    @VisibleForTesting
    static void checkExceptionClassValidity(Class<? extends Exception> exceptionClass) {
        Preconditions.checkArgument(FuturesGetChecked.isCheckedException(exceptionClass), (String)"io.logz.sender.Futures.getChecked exception type (%s) must not be a RuntimeException", exceptionClass);
        Preconditions.checkArgument(FuturesGetChecked.hasConstructorUsableByGetChecked(exceptionClass), (String)"io/logz/sender/Futures.getChecked exception type (%s) must be an accessible class with an accessible constructor whose parameters (if any) must be of type String and/or Throwable", exceptionClass);
    }

    private FuturesGetChecked() {
    }

    @VisibleForTesting
    static class GetCheckedTypeValidatorHolder
    extends io.logz.sender.java.lang.Object {
        static final String CLASS_VALUE_VALIDATOR_NAME = new StringBuilder().append(GetCheckedTypeValidatorHolder.class.getName()).append((String)"io.logz.sender.$ClassValueValidator").toString();
        static final GetCheckedTypeValidator BEST_VALIDATOR = GetCheckedTypeValidatorHolder.getBestValidator();

        GetCheckedTypeValidatorHolder() {
        }

        static GetCheckedTypeValidator getBestValidator() {
            try {
                Class theClass = Class.forName((String)CLASS_VALUE_VALIDATOR_NAME);
                return (GetCheckedTypeValidator)theClass.getEnumConstants()[0];
            }
            catch (Throwable t) {
                return FuturesGetChecked.weakSetValidator();
            }
        }

        static final class WeakSetValidator
        extends Enum<WeakSetValidator>
        implements GetCheckedTypeValidator {
            public static final /* enum */ WeakSetValidator INSTANCE = new WeakSetValidator((String)"io.logz.sender.INSTANCE", 0);
            private static final Set<WeakReference<Class<? extends Exception>>> validClasses;
            private static final /* synthetic */ WeakSetValidator[] $VALUES;

            public static WeakSetValidator[] values() {
                return (WeakSetValidator[])$VALUES.clone();
            }

            public static WeakSetValidator valueOf(String name) {
                return (WeakSetValidator)Enum.valueOf(WeakSetValidator.class, (String)name);
            }

            private WeakSetValidator() {
                super((String)string, n);
            }

            @Override
            public void validateClass(Class<? extends Exception> exceptionClass) {
                for (WeakReference knownGood : validClasses) {
                    if (!exceptionClass.equals(knownGood.get())) continue;
                    return;
                }
                FuturesGetChecked.checkExceptionClassValidity(exceptionClass);
                if (validClasses.size() > 1000) {
                    validClasses.clear();
                }
                validClasses.add((io.logz.sender.java.lang.Object)new WeakReference(exceptionClass));
            }

            static {
                $VALUES = new WeakSetValidator[]{INSTANCE};
                validClasses = new CopyOnWriteArraySet();
            }
        }

        @IgnoreJRERequirement
        static final class ClassValueValidator
        extends Enum<ClassValueValidator>
        implements GetCheckedTypeValidator {
            public static final /* enum */ ClassValueValidator INSTANCE = new ClassValueValidator((String)"io.logz.sender.INSTANCE", 0);
            private static final ClassValue<Boolean> isValidClass;
            private static final /* synthetic */ ClassValueValidator[] $VALUES;

            public static ClassValueValidator[] values() {
                return (ClassValueValidator[])$VALUES.clone();
            }

            public static ClassValueValidator valueOf(String name) {
                return (ClassValueValidator)Enum.valueOf(ClassValueValidator.class, (String)name);
            }

            private ClassValueValidator() {
                super((String)string, n);
            }

            @Override
            public void validateClass(Class<? extends Exception> exceptionClass) {
                isValidClass.get(exceptionClass);
            }

            static {
                $VALUES = new ClassValueValidator[]{INSTANCE};
                isValidClass = new ClassValue<Boolean>(){

                    protected Boolean computeValue(Class<?> type) {
                        FuturesGetChecked.checkExceptionClassValidity((Class<? extends Exception>)type.asSubclass(Exception.class));
                        return Boolean.valueOf((boolean)true);
                    }
                };
            }
        }
    }

    @VisibleForTesting
    static interface GetCheckedTypeValidator {
        public void validateClass(Class<? extends Exception> var1);
    }
}

