/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.util.concurrent;

import io.logz.sender.com.google.common.annotations.GwtCompatible;
import io.logz.sender.com.google.common.annotations.GwtIncompatible;
import io.logz.sender.com.google.common.base.Preconditions;
import io.logz.sender.com.google.common.util.concurrent.AbstractFuture;
import io.logz.sender.com.google.common.util.concurrent.CheckedFuture;
import io.logz.sender.com.google.common.util.concurrent.FluentFuture;
import io.logz.sender.java.lang.Exception;
import io.logz.sender.java.lang.Runnable;
import io.logz.sender.java.lang.RuntimeException;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.lang.StringBuilder;
import io.logz.sender.java.lang.Throwable;
import io.logz.sender.java.util.concurrent.ExecutionException;
import io.logz.sender.java.util.concurrent.Executor;
import io.logz.sender.java.util.concurrent.TimeUnit;
import io.logz.sender.java.util.logging.Level;
import io.logz.sender.java.util.logging.Logger;
import io.logz.sender.org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible(emulated=true)
abstract class ImmediateFuture<V extends io.logz.sender.java.lang.Object>
extends FluentFuture<V> {
    private static final Logger log = Logger.getLogger((String)ImmediateFuture.class.getName());

    ImmediateFuture() {
    }

    @Override
    public void addListener(Runnable listener, Executor executor) {
        Preconditions.checkNotNull(listener, (io.logz.sender.java.lang.Object)"io.logz.sender.Runnable was null.");
        Preconditions.checkNotNull(executor, (io.logz.sender.java.lang.Object)"io.logz.sender.Executor was null.");
        try {
            executor.execute(listener);
        }
        catch (RuntimeException e) {
            log.log(Level.SEVERE, new StringBuilder().append((String)"io.logz.sender.RuntimeException while executing runnable ").append((io.logz.sender.java.lang.Object)listener).append((String)"io.logz.sender. with executor ").append((io.logz.sender.java.lang.Object)executor).toString(), (Throwable)((Object)e));
        }
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    public abstract V get() throws ExecutionException;

    public V get(long timeout, TimeUnit unit) throws ExecutionException {
        Preconditions.checkNotNull(unit);
        return this.get();
    }

    public boolean isCancelled() {
        return false;
    }

    public boolean isDone() {
        return true;
    }

    @GwtIncompatible
    static class ImmediateFailedCheckedFuture<V extends io.logz.sender.java.lang.Object, X extends Exception>
    extends ImmediateFuture<V>
    implements CheckedFuture<V, X> {
        private final X thrown;

        ImmediateFailedCheckedFuture(X thrown) {
            this.thrown = thrown;
        }

        @Override
        public V get() throws ExecutionException {
            throw new ExecutionException(this.thrown);
        }

        @Override
        public V checkedGet() throws X {
            throw this.thrown;
        }

        @Override
        public V checkedGet(long timeout, TimeUnit unit) throws X {
            Preconditions.checkNotNull(unit);
            throw this.thrown;
        }

        public String toString() {
            return new StringBuilder().append(super.toString()).append((String)"io.logz.sender.[status=FAILURE, cause=[").append(this.thrown).append((String)"io.logz.sender.]]").toString();
        }
    }

    static final class ImmediateCancelledFuture<V extends io.logz.sender.java.lang.Object>
    extends AbstractFuture.TrustedFuture<V> {
        ImmediateCancelledFuture() {
            this.cancel(false);
        }
    }

    static final class ImmediateFailedFuture<V extends io.logz.sender.java.lang.Object>
    extends AbstractFuture.TrustedFuture<V> {
        ImmediateFailedFuture(Throwable thrown) {
            this.setException(thrown);
        }
    }

    @GwtIncompatible
    static class ImmediateSuccessfulCheckedFuture<V extends io.logz.sender.java.lang.Object, X extends Exception>
    extends ImmediateFuture<V>
    implements CheckedFuture<V, X> {
        @NullableDecl
        private final V value;

        ImmediateSuccessfulCheckedFuture(@NullableDecl V value) {
            this.value = value;
        }

        @Override
        public V get() {
            return this.value;
        }

        @Override
        public V checkedGet() {
            return this.value;
        }

        @Override
        public V checkedGet(long timeout, TimeUnit unit) {
            Preconditions.checkNotNull(unit);
            return this.value;
        }

        public String toString() {
            return new StringBuilder().append(super.toString()).append((String)"io.logz.sender.[status=SUCCESS, result=[").append(this.value).append((String)"io.logz.sender.]]").toString();
        }
    }

    static class ImmediateSuccessfulFuture<V extends io.logz.sender.java.lang.Object>
    extends ImmediateFuture<V> {
        static final ImmediateSuccessfulFuture<io.logz.sender.java.lang.Object> NULL = new ImmediateSuccessfulFuture<Object>(null);
        @NullableDecl
        private final V value;

        ImmediateSuccessfulFuture(@NullableDecl V value) {
            this.value = value;
        }

        @Override
        public V get() {
            return this.value;
        }

        public String toString() {
            return new StringBuilder().append(super.toString()).append((String)"io.logz.sender.[status=SUCCESS, result=[").append(this.value).append((String)"io.logz.sender.]]").toString();
        }
    }
}

