/*
 * Decompiled with CFR 0.152.
 */
package io.logz.sender.com.google.common.util.concurrent;

import io.logz.sender.com.google.common.annotations.GwtIncompatible;
import io.logz.sender.com.google.common.base.Preconditions;
import io.logz.sender.com.google.errorprone.annotations.concurrent.GuardedBy;
import io.logz.sender.java.lang.Enum;
import io.logz.sender.java.lang.Error;
import io.logz.sender.java.lang.Runnable;
import io.logz.sender.java.lang.RuntimeException;
import io.logz.sender.java.lang.String;
import io.logz.sender.java.lang.StringBuilder;
import io.logz.sender.java.lang.Thread;
import io.logz.sender.java.util.ArrayDeque;
import io.logz.sender.java.util.Deque;
import io.logz.sender.java.util.concurrent.Executor;
import io.logz.sender.java.util.concurrent.RejectedExecutionException;
import io.logz.sender.java.util.logging.Level;
import io.logz.sender.java.util.logging.Logger;

@GwtIncompatible
final class SequentialExecutor
extends io.logz.sender.java.lang.Object
implements Executor {
    private static final Logger log = Logger.getLogger((String)SequentialExecutor.class.getName());
    private final Executor executor;
    @GuardedBy(value="io.logz.sender.queue")
    private final Deque<Runnable> queue = new ArrayDeque();
    @GuardedBy(value="io.logz.sender.queue")
    private WorkerRunningState workerRunningState = WorkerRunningState.IDLE;
    @GuardedBy(value="io.logz.sender.queue")
    private long workerRunCount = 0L;
    private final QueueWorker worker = new QueueWorker();

    SequentialExecutor(Executor executor) {
        this.executor = Preconditions.checkNotNull(executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(final Runnable task) {
        boolean alreadyMarkedQueued;
        Runnable submittedTask;
        long oldRunCount;
        Preconditions.checkNotNull(task);
        Deque<Runnable> deque = this.queue;
        synchronized (deque) {
            if (this.workerRunningState == WorkerRunningState.RUNNING || this.workerRunningState == WorkerRunningState.QUEUED) {
                this.queue.add((io.logz.sender.java.lang.Object)task);
                return;
            }
            oldRunCount = this.workerRunCount;
            submittedTask = new Runnable(){

                public void run() {
                    task.run();
                }
            };
            this.queue.add((io.logz.sender.java.lang.Object)submittedTask);
            this.workerRunningState = WorkerRunningState.QUEUING;
        }
        try {
            this.executor.execute((Runnable)this.worker);
        }
        catch (Error | RuntimeException t) {
            Deque<Runnable> deque2 = this.queue;
            synchronized (deque2) {
                boolean removed;
                boolean bl = removed = (this.workerRunningState == WorkerRunningState.IDLE || this.workerRunningState == WorkerRunningState.QUEUING) && this.queue.removeLastOccurrence((io.logz.sender.java.lang.Object)submittedTask);
                if (!(t instanceof RejectedExecutionException) || removed) {
                    throw t;
                }
            }
            return;
        }
        boolean bl = alreadyMarkedQueued = this.workerRunningState != WorkerRunningState.QUEUING;
        if (alreadyMarkedQueued) {
            return;
        }
        Deque<Runnable> deque3 = this.queue;
        synchronized (deque3) {
            if (this.workerRunCount == oldRunCount && this.workerRunningState == WorkerRunningState.QUEUING) {
                this.workerRunningState = WorkerRunningState.QUEUED;
            }
        }
    }

    private final class QueueWorker
    extends io.logz.sender.java.lang.Object
    implements Runnable {
        private QueueWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.workOnQueue();
            }
            catch (Error e) {
                Deque deque = SequentialExecutor.this.queue;
                synchronized (deque) {
                    SequentialExecutor.this.workerRunningState = WorkerRunningState.IDLE;
                }
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private void workOnQueue() {
            boolean interruptedDuringTask = false;
            boolean hasSetRunning = false;
            while (true) {
                Deque deque = SequentialExecutor.this.queue;
                // MONITORENTER : deque
                if (hasSetRunning) break block11;
                if (SequentialExecutor.this.workerRunningState != WorkerRunningState.RUNNING) break block12;
                // MONITOREXIT : deque
                if (!interruptedDuringTask) return;
                break;
            }
            catch (Throwable throwable) {
                if (!interruptedDuringTask) throw throwable;
                Thread.currentThread().interrupt();
                throw throwable;
            }
            {
                Runnable task;
                block11: {
                    block12: {
                        Thread.currentThread().interrupt();
                        return;
                    }
                    SequentialExecutor.this.workerRunCount++;
                    SequentialExecutor.this.workerRunningState = WorkerRunningState.RUNNING;
                    hasSetRunning = true;
                }
                if ((task = (Runnable)SequentialExecutor.this.queue.poll()) == null) {
                    SequentialExecutor.this.workerRunningState = WorkerRunningState.IDLE;
                    // MONITOREXIT : deque
                    if (!interruptedDuringTask) return;
                    Thread.currentThread().interrupt();
                    return;
                }
                // MONITOREXIT : deque
                interruptedDuringTask |= Thread.interrupted();
                try {
                    task.run();
                }
                catch (RuntimeException e) {
                    log.log(Level.SEVERE, new StringBuilder().append((String)"io.logz.sender.Exception while executing runnable ").append((io.logz.sender.java.lang.Object)task).toString(), (io.logz.sender.java.lang.Throwable)((Object)e));
                }
                continue;
            }
        }
    }

    static final class WorkerRunningState
    extends Enum<WorkerRunningState> {
        public static final /* enum */ WorkerRunningState IDLE = new WorkerRunningState((String)"io.logz.sender.IDLE", 0);
        public static final /* enum */ WorkerRunningState QUEUING = new WorkerRunningState((String)"io.logz.sender.QUEUING", 1);
        public static final /* enum */ WorkerRunningState QUEUED = new WorkerRunningState((String)"io.logz.sender.QUEUED", 2);
        public static final /* enum */ WorkerRunningState RUNNING = new WorkerRunningState((String)"io.logz.sender.RUNNING", 3);
        private static final /* synthetic */ WorkerRunningState[] $VALUES;

        public static WorkerRunningState[] values() {
            return (WorkerRunningState[])$VALUES.clone();
        }

        public static WorkerRunningState valueOf(String name) {
            return (WorkerRunningState)Enum.valueOf(WorkerRunningState.class, (String)name);
        }

        private WorkerRunningState() {
            super((String)string, n);
        }

        static {
            $VALUES = new WorkerRunningState[]{IDLE, QUEUING, QUEUED, RUNNING};
        }
    }
}

